# main.tcl --
#
#       This is the main entry point for the srmv2 tool.
#       Tcl source code expansion with tcl-expand.tcl starts here.
#       Tcl execution also starts here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


proc havefont { f } { return 1 }

source tcl/common/application.tcl
source tcl/net/network.tcl
source tcl/common/log.tcl
source tcl/common/tkerror.tcl
source tcl/common/timer.tcl

source tcl/srmv2/source-srmv2.tcl
source tcl/srmv2/session-srmv2.tcl
source tcl/srmv2/manager-srmv2.tcl
source tcl/srmv2/text-srmv2.tcl
source tcl/srmv2/bt-srmv2.tcl

proc main args {
	set lst [lindex $args 0]
	if {[llength $lst] < 3} {
		puts ""
		puts -nonewline "Usage: bulk_transfer mcast_address/port/srmv2/ttl"
		puts " \[rate\] \[logfile\] \[src_dir\]"
		puts ""
		puts "\t rate    = Maximum rate for token bucket. \n\t           Default = 128 Kb/s"
		puts "\t logfile = Output file for traces. This is only a temporary"
                puts "\t           feature to allow emulation results to be logged."
		puts "\t src_dir = Source of data. If unspecified, this is a receiver.\n"
		exit 1
	}
	set ab [lindex $lst 0]
	set peakrate [lindex $lst 1]

	set logfile  [lindex $lst 2]
	set filename [lindex $lst 3]
	puts "peakrate $peakrate filename $filename logfile $logfile"
	new BulkTransfer $ab $logfile $peakrate $filename
}

main $argv

