# client-dc.tcl --
#
#       Provides an abstract interface to the DC API to control the DC
#       remotely.
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import DpClient

Class DcClient

DcClient instproc init {hostname port} {
    $self instvar dc_

    set dc_ [new DpClient $hostname $port]
}

DcClient public getThumbnailInfo {} {
    $self instvar dc_

    set retVal [$dc_ do dcApi_getThumbnailInfo]
    return $retVal
}

DcClient public getPreviewInfo {} {
    $self instvar dc_

    set retVal [$dc_ do dcApi_getPreviewInfo]
    return $retVal
}

DcClient public getBroadcastInfo {} {
    $self instvar dc_

    set retVal [$dc_ do dcApi_getBroadcastInfo]
    return $retVal
}

DcClient public previewAll {} {
    $self instvar dc_

    set retVal [$dc_ do dcApi_getThumbnailInfo]
    array set thumbInfo $retVal
    foreach index $thumbInfo(windows) {
	$dc_ do dcApi_previewThumbnail $index
    }
}


DcClient public broadcastAll {} {
    $self instvar dc_

    set retVal [$dc_ do dcApi_getThumbnailInfo]
    array set thumbInfo $retVal
    foreach index $thumbInfo(windows) {
	$dc_ do dcApi_broadcastThumbnail $index
    }
}

DcClient public clearPreviewPane {} {
    $self instvar dc_

    $dc_ do dcApi_clearPreviewPane
}

DcClient public clearBroadcastPane {} {
    $self instvar dc_

    $dc_ do dcApi_clearBroadcastPane
}

DcClient public clearAll {} {
    $self instvar dc_

    $dc_ do dcApi_clearPreviewPane
    $dc_ do dcApi_clearBroadcastPane
}

DcClient public broadcastHost {hostname} {
    $self instvar dc_

    set hostname [string tolower $hostname]
    set retVal [$dc_ do dcApi_getBroadcastInfo]
    array set broadcastInfo $retVal
    foreach index $broadcastInfo(windows) {
	if {$broadcastInfo($index,hostname) == $hostname} {
	    # already broadcasting
	    return 1
	}
    }

    set retVal [$dc_ do dcApi_getThumbnailInfo]
    array set thumbInfo $retVal
    foreach index $thumbInfo(windows) {
	if {$thumbInfo($index,hostname) == $hostname} {
	    $dc_ do dcApi_broadcastThumbnail $index
	    return 1
	}
    }

    # if we got here, there is no thumbnail from that host, so fail
    return 0
}

DcClient public unbroadcastHost {hostname} {
    $self instvar dc_

    set hostname [string tolower $hostname]
    set retVal [$dc_ do dcApi_getBroadcastInfo]
    array set broadcastInfo $retVal
    foreach index $broadcastInfo(windows) {
	if {$broadcastInfo($index,hostname) == $hostname} {
	    $dc_ do dcApi_removeBroadcast $index
	}
    }
    return 1
}

