/*
 * Copyright (c) 1997 Carnegie Mellon University. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation is hereby granted (including for commercial or
 * for-profit use), provided that both the copyright notice and this
 * permission notice appear in all copies of the software, derivative
 * works, or modified versions, and any portions thereof, and that
 * both notices appear in supporting documentation, and that credit
 * is given to Carnegie Mellon University in all publications reporting
 * on direct or indirect use of this code or its derivatives.
 *
 * THIS SOFTWARE IS EXPERIMENTAL AND IS KNOWN TO HAVE BUGS, SOME OF
 * WHICH MAY HAVE SERIOUS CONSEQUENCES.  CARNEGIE MELLON PROVIDES THIS
 * SOFTWARE IN ITS ``AS IS'' CONDITION, AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CARNEGIE MELLON UNIVERSITY BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 *
 * Carnegie Mellon encourages (but does not require) users of this
 * software to return any improvements or extensions that they make,
 * and to grant Carnegie Mellon the rights to redistribute these
 * changes without encumbrance.
 */
#ifndef INCL_FUN
#define INCL_FUN
#include "hfsc_decl.h"
#include "hfsc_hierarchy.h"
//#include "srmv2-api.h"

#define COARSE_FACTOR 100
#define mult(x) ((int)(((int) x)*COARSE_FACTOR)) /* yc-m: int mult(int); */
#ifdef __cplusplus
extern "C" {
#endif
	int coarseClock();
	void HFCSInit(void);

	void getSegmentIntersection(int,int,int,int,int,int,int,int,int*,int*);
	ServiceCurve *newSC(int,int,int,...);                           /* bug ???? */
	RTServiceCurve *newRTSC(int,int,int,int,int);
	void minRTSC(RTServiceCurve *, ServiceCurve *, int, int);
	int getRTSC_y(RTServiceCurve *,int);
	int getRTSC_x(RTServiceCurve *,int);
	ServiceCurve *addSC(ServiceCurve *, ServiceCurve *);
	GenServiceCurve *newGSC(void);
	int IsSCLessThanGSC(ServiceCurve *, GenServiceCurve *);
	void addSCtoGSC(GenServiceCurve *, ServiceCurve *);
	void subSCtoGSC(GenServiceCurve *, ServiceCurve *);
	void addRTSCtoGSC(GenServiceCurve *, RTServiceCurve *);
	void subRTSCfromGSC(GenServiceCurve *, RTServiceCurve *);
	int getGSC_y(GenServiceCurve *, int);
	void cutGSC(GenServiceCurve *, int);
	void cutRTSC(RTServiceCurve *, int);
	int cutRTSC_X(RTServiceCurve *, int);
	int IsGSCLessThanSC(GenServiceCurve *pgsc, ServiceCurve *psc);
	void subSCfromGSC(GenServiceCurve *pgsc, ServiceCurve    *psc);
	void printGSC(char *text,  GenServiceCurve *pgsc);
	void printSC(char *text, ServiceCurve *psc);
	void printRTSC(char *text, RTServiceCurve *prtsc);

        /* function implemented in hfsc_hierarchy.c */
	HFSCStruct *newHFSCData(ClassItem *);
	ClassItem *newClassItem(int, unsigned, ServiceCurve *);
	ClassItem *insertClassItem(ClassItem *, int, ClassItem *);
	void updateHierarchy(ClassItem *, u_int);
	void changeSessionStatus(HFSCStruct *, ClassItem *, u_int);
	/*void updateBussyFlags(void);*/
	ClassItem *selSesByVT(ClassItem *);
	ClassItem *getClassItem(ClassItem *, int);
	int resetAllClasses();
 
        /* function implemented in hfsc_calendar.c or hfsc_heap.c */
#ifdef HFSC_CALENDAR
	CalPriorQueue *allocCalPriorQueue(void);
	void enqueueReq(void);
	ReqItem *dequeueReq(void);
	void changeReq(void);
	ReqItem *getReq(void);
#else
#define getReq(ph) (ph->num ? ph->a[0] : NULL)
	Heap *newHeap(void);
	void enqueueReq(Heap *, ReqItem *);
	ReqItem *dequeueReq(Heap *,...);                                 /* bug ??? */
	void changeReq(Heap *, u_int, key_t);
#endif
        void removeReq(Heap *, u_int);

        /* function implemented in hfsc_calheap.c */
	CalHeapStruct *allocCalHeapStruct(int, u_int *);
	void rehashCal(CalHeapStruct *, u_int);
	void enqueueReq2(CalHeapStruct *, ReqItem *, u_int);
	ReqItem *dequeueFirstReq2(CalHeapStruct *, u_int);
	void dequeueReq2(CalHeapStruct *, ReqItem *, u_int); 

	void getLineIntersection(int,int,int,int,int,int,int,int,int*,int*);
	void addSegToGSC(GenServiceCurve *, int,int,int,int);
	void compressGSC(GenServiceCurve *);
	void freeGSC(GenServiceCurve *);
	int getSC_y(ServiceCurve*, int);

        /* function implemented in hfsc_misc.c */
	int hfsc_panic(char *); 
        char *smalloc(unsigned);

#ifdef __cplusplus
}
#endif

#endif
