/*****************************************************************************
 *                                                                           *
 * Program:   paul                                                           *
 *            (P)rogramm zur (A)uswertung und (U)mformung von                *
 *            (L)aserbildern                                                 *
 * Modul:     contrast.c                                                     *
 *            enhance contrast by multiplying pixel values and brightness by *
 *            adding an offset to pixel values                               *
 * Author:    Andreas Tille                                                  *
 * Date:      18.05.1998                                                     *
 * Copyright: Andreas Tille, 1999; GNU Public License                        *
 *                                                                           *
 *****************************************************************************/

#include <math.h>
#include "paul.h" 

#define SCALE(a,b)     { register int d = a; \
                         if ( d < 0    ) b = 0; \
                         else if ( d > 0xFF ) b = 0xFF; \
                              else            b = (unsigned char) d; }

int SkaliereBilder(PAUL *p)
/* contrast:   multiply all pixels with "scale"
 * brightness: add to all pixels "offset"
 * --- Parameter: ---
 * PAUL *p                : list off images, options
 *                          used options:
 *                          scale  : faktor to change contrast
 *                          offset : shift to change brightness
 * --- Return: ---
 * int   SkaliereBilder() : RET_ERR or RET_OK
 */
{
  PICTURE       *bild;
  GList         *pl;
  char          *desc,
                *loss_off = _("%s of %g causes loss of information!");
  unsigned char *c, *fcp;
  double         scale;
  register int   offset;

  g_return_val_if_fail ( IS_PAUL(p), RET_ERR );
   
  if ( !NBILDER(p->piclist) ) return RET_OK;

  offset = p->opt->offset;
  if ( (scale  = p->opt->scale) > 0.9999 && scale < 1.0001 && !offset ) return RET_OK;
   
  if ( fabs(scale) < 1.0 || fabs(scale) > 4.0 )
    g_warning(loss_off, _("Contrast"), scale);
  if ( (scale > 0.0 && abs(offset) > 128) || abs(offset) > 256 )
    g_warning(loss_off, _("Brightness"), offset);

  for ( bild = BILD(pl = p->piclist); pl; bild = BILD(pl = pl->next) ) {
    for ( fcp = (c = bild->DATA) + bild->storepix*bild->size; c < fcp; c++ ) 
      SCALE( (int)(((double)*c) * (scale)) + offset, *c );

    desc = g_strdup_printf("%s: contrast factor *%g, brightness offset %i", 
                            ImgFileName(bild), scale, offset);
    ImgChunksUpdate(bild, TypKontrastBild, desc, APPKONTRAST, NEGATIV);
    FREE(desc);
  }
  return RET_OK;
}






