/* ----------------------------------------------- */
/* company : pentamedia
 * author  : elcomski 
 * file    : avicosc.c 
 * date    : 2000-08-20
 * modify  : 2002-11-11 by elcomski
 */
/* ----------------------------------------------- */
#if 0 /* if you want to test resetting cw, set to 1 */ 
#define USE_FIXED_KEY_CAS  
#endif
#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include "../../share/xptype.h"
#include "../../share/ifdef.h"
#include "../libif/pentapi.h"
#include "../libapp/avienv.h"
#include "../libapp/avienv1.h"
#include "../libapp/avifunc.h"




/*--------------------------------*/
/* Constant definitions */
/*--------------------------------*/
#define PENTANETT_VER "2.3.1"



/*--------------------------------*/
/* Variable definitions */
/*--------------------------------*/
char g_config_file[100] = "tp.conf";
char g_dev_name[100] = "pentanet0";
char g_dirname2[256];
str_trans_data g_trans_data;
str_pid_data g_pid_data;
str_ip_data g_dip_data;
str_ip_data g_sip_data;



/*--------------------------------*/
/* Function definitions */
/*--------------------------------*/
/*
 * Func : display_info
 * Context :
 */
void display_info( void )
{
	printf("\n---------------------------------\n");
	printf(" Pent@NET for Linux (Ver %s) \n", PENTANETT_VER);
	printf(" ----------------------------------\n\n");
}


/*
 * Func : status_card
 * Context :
 */
void status_card( int argc, char *argv[] )
{
    	int iret,opt,command;
	unsigned long lret;
	unsigned char bMacAddr[8];
	float fBPS;
	double dSignalq;
	
	command = 0;
	while((opt = getopt(argc, argv, "sd:")) != -1){
		switch(opt)
		{
			case 's':
				command = 1;
			break;
			
			case 'd':
				strcpy(g_dev_name,optarg);
			break;
			
			case '?':
			{
				printf("**ERROR** unknown option: %c\n",optopt);
				command = 0;
			}
			break;
		}
	}
	for(;optind < argc; optind++){
		printf("**ERROR** unknown argument: %s\n",argv[optind]);
		command = 0;
	}		

	if(!command) return;

	printf("[Driver/device info]\n");
	printf("[Device name: %s\n",g_dev_name );
	iret = sm_get_device_status( g_dev_name );
	if(iret < 0){
		if(iret == ERR_OPEN_SOCKET){
			printf("**ERROR** network interface open error\n");
		}else if(iret == ERR_NOT_DEVICE){
			printf("**ERROR** device not found\n");
		}else if(iret == ERR_NOT_DEVICE_OPEN){
			printf("**ERROR** device not open\n");
		}else{
			printf("**ERROR** unknown error code[%d]\n",iret);
		}
		return;
	}

   	if(iret > 0) printf("# Device status : Enable\n");
	else printf("# Device status : Disable \n");

    	lret = sm_get_device_version(g_dev_name);
   	printf("# Driver version : %x.%x.%x\n",(unsigned int)((lret>>16)&0xff),(unsigned int)((lret>>8)&0xff),(unsigned int)(lret&0xff));
	
	sm_get_mac_address(g_dev_name, bMacAddr);
	printf("# MAC address : %02x %02x %02x %02x %02x %02x\n", bMacAddr[0],bMacAddr[1],bMacAddr[2], bMacAddr[3],bMacAddr[4],bMacAddr[5]);
   

	printf("\n[Rx data info]\n");
	iret = sm_get_received_packets( g_dev_name );
	if( iret >= 0 ) printf("# Total Rx packets : %d\n", iret);

	lret = sm_get_down_speed( g_dev_name );
	fBPS = (float)(lret * 8 );
	fBPS = fBPS / (1024 * 1024);
	printf("# Rx data rate : %.3f[Mbps]\n", fBPS);

	
	printf("\n[Tuner info]\n");
	iret = sm_tuner_get_status( g_dev_name );
	if( iret ){
		printf("# LNB lock status : lock\n");
	}else if(iret == 0){
		printf("# LNB lock status : unlock\n");
	}
	
	iret = sm_get_bit_error_rate ( g_dev_name );
	if( iret > 0){
	       	printf("# Viterbi decoded BER : %e\n", (float)iret/1048576);
	}else if( iret == 0 ){
	       	printf("# Viterbi decoded BER : %d\n", iret);
	}else{
	       	printf("# Viterbi decoded BER : Not supported\n");
	}

	dSignalq = sm_get_signal_quality( g_dev_name );
	printf("# Signal to Noise Ratio: %f [dB]\n", dSignalq);	
    
	iret = sm_get_corrected_rs_error( g_dev_name );
	if( iret >= 0 ){
		printf("# Reed Solomon Corrected errors: %d\n", iret);	
	}else{
		printf("# Reed Solomon Corrected errors: Not supported\n");	
	}

	iret = sm_get_uncorrected_rs_error( g_dev_name );
	if( iret >= 0 ){
		printf("# Reed Solomon Uncorrected errors: %d\n", iret );	
	}else{
		printf("# Reed Solomon Uncorrected errors: Not supported\n");	
	}
}


/*
 * Func : get_more_info 
 * Context :
 */
void get_more_info(int argc, char *argv[])
{
	int opt;
	int command;
	int i,j;

	str_mac_data multi_mac_data;

	command = 0;
	while((opt = getopt(argc, argv, "md:")) != -1){
		switch(opt){
			case 'm':
				command = 1;
			break;

			case 'd':
				strcpy(g_dev_name,optarg);
			break;

			case '?':
			{
				printf("**ERROR** Unknown option: %c\n",optopt);
				command = 0;
			}
			break;
		}
	}

	for(;optind < argc; optind++){
		printf("**ERROR** Unknown argument: %s\n",argv[optind]);
		command = 0;
	}		

	if(!command) return;

	printf("[Device name: %s]\n",g_dev_name);

	sm_multi_get_mac_info( g_dev_name, &multi_mac_data );

	printf("[Multicast Information]\n");	

	if( multi_mac_data.filterflags == 1 ){
		printf("->promisc mode enabled\n" );	
	}else if( multi_mac_data.filterflags == 2){
		printf("->allmulti mode enabled\n" );	
	}else{
		if( !multi_mac_data.count){
			printf("->multicast MAC address does not exist\n" );	
			return;
		}else{	
			printf("# Total : %d\n", multi_mac_data.count );	
		}
		for( i = 0; i < multi_mac_data.count; i++ ){
			printf(" [%d]",i);	
			for( j = 0; j < 6; j++ ){
				printf("%02x ",multi_mac_data.mac[i][j]); 
			}
			printf("\n");
		}
	}

}


/*
 * Func : display_options
 * Context :
 */
void display_options( void )
{
	printf(" options \n");
	printf(" 	-a : run card \n");
	printf(" 	-r : retry tunning \n");
	printf(" 	-q : stop card \n");
	printf("        -f : config file \n");
	printf(" 	-d : device name \n");
	printf(" 	-s : display status \n");
	printf(" 	-h : dispaly options \n");
	printf(" \n");

	printf(" examples \n");
	printf(" 	pentanet -a \n");
	printf("        pentanet -a -f tp.conf \n");
	printf("        pentanet -a -d pentanet0 -f tp.conf \n");
	printf(" 	pentanet -r -d pentanet0 \n");
	printf(" 	pentanet -q \n");
	printf("\n");
}


/*
 * Func : tunning_card
 * Context :
 *	return 0 : unlock 
 *	return 1 : lock 
 */
int tunning_card( void )
{
	if( !set_tuner(g_trans_data) ){
		return 0;
	}

	/* set PID */
	set_pid_info( );
	set_filter_info( );

	return 1;
}


/*
 * Func : tunning_card_for_resetting_cw
 * Context : 
 * 	This function is used only when change control word 
 * 	with previous pid .
 * 	If this function return -1, this pid does not match 
 * 	with previous pid.
 * 	If you want to add new pid with control word,
 * 	you had better to call set_pid_info( ) function.
 * 	
 * 	
 *	return 0 : unlock 	
 *	return 1 : lock but fail to set PID 	
 *	return 2 : lock and success to set PID 	
 */
int tunning_card_for_resetting_cw( void )
{
	if( !set_tuner(g_trans_data)){
		return 0;
	}

	if( !reset_pid_info_as_cw( ) ){
		return 1;
	}
	set_filter_info( );

	return 2;
}


/*
 * Func : action_card
 * Context :
 */
void action_card(int argc, char *argv[])
{
   	int iret,opt,command;

	command = 0;
	while((opt = getopt(argc, argv, "ad:f:")) != -1){
		switch(opt){
			case 'a':
				command = 1;
			break;
			
			case 'f':
				strcpy(g_config_file,optarg);
			break;
			
			case 'd':
				strcpy(g_dev_name,optarg);
			break;
			
			case '?':
			{
				printf("**ERROR** unknown option: %c\n",optopt);
				command = 0;
			}
			break;
		}
	}

	for(;optind < argc; optind++){
		printf("**ERROR** unknown argument: %s\n",argv[optind]);
		command = 0;
	}	
	if(!command) return;	

	printf("[Device name: %s\n",g_dev_name );

	get_if_list();

	iret = sm_get_device_status( g_dev_name );
	if(iret < 0){
		if(iret == ERR_OPEN_SOCKET){
			printf("**ERROR** network interface open error\n");
		}else if(iret == ERR_NOT_DEVICE){
			printf("**ERROR** device not found\n");
		}else if(iret == ERR_NOT_DEVICE_OPEN){
			printf("**ERROR** device not open\n");
		}else{
			printf("**ERROR** unknown error code[%d]\n",iret);
		}
		return;
	}
	
    	InitTransInfo(g_dirname2);
	FreeTransInfo();

	/* trying to unlock */
	sm_tuner_stop_tunning( g_dev_name );

	/* initialize the device */
	iret = sm_init_device(g_dev_name);
	if(iret < 0){
		printf("**ERROR** device initialization error\n");
		return;
	}

	/* trying to lock and set PID and IP address */
	if(!tunning_card( )){
		printf("**ERROR** tuner lock fail\n");
		return;
	}


#if 0 /* test-only */
/* If you want to multicast-route for all or a multicast IP to ethernet device directly, set to 1 */
	sm_multi_route_device( g_dev_name, "eth0" );

caseI: /* allmulti */	
	sm_multi_ip_all( g_dev_name, TRUE );

caseII: /* a specific multicast IP */
	sm_multi_ip_clear( g_dev_name );
	sm_multi_ip_add( g_dev_name, 0xe0020201 ); /* IP: 224.2.2.1 */
	sm_multi_ip_add( g_dev_name, 0xe0020202 ); /* IP: 224.2.2.2 */
	sm_multi_ip_add( g_dev_name, 0xe0020203 ); /* IP: 224.2.2.3 */
#endif

	printf("\n\n[ -- Initialization is successful -- ]\n");
	
}


/*
 * Func : reaction_card
 * Context :
 */
void reaction_card(int argc, char *argv[])
{
	int iret,opt,command;

	command = 0;
	while((opt = getopt(argc, argv, "rd:f:")) != -1){
		switch(opt){
			case 'r':
				command = 1;
			break;

			case 'f':
				strcpy(g_config_file,optarg);
			break;

			case 'd':
				strcpy(g_dev_name,optarg);
			break;

			case '?':
			{
				printf("**ERROR** unknown option: %c\n",optopt);
				command = 0;
			}
			break;
		}
	}

	for(;optind < argc; optind++){
		printf("**ERROR** unknown argument: %s\n",argv[optind]);
		command = 0;
	}	
	if(!command) return;

	printf("[Device name: %s\n",g_dev_name );

	get_if_list();

	iret = sm_get_device_status( g_dev_name );
	if(iret < 0){
		if(iret == ERR_OPEN_SOCKET){
			printf("**ERROR** network interface open error\n");
		}else if(iret == ERR_NOT_DEVICE){
			printf("**ERROR** device not found\n");
		}else if(iret == ERR_NOT_DEVICE_OPEN){
			printf("**ERROR** device not open\n");
		}else{
			printf("**ERROR** unknown error code[%d]\n",iret);
		}
		return;
	}

    	InitTransInfo(g_dirname2);
	FreeTransInfo( );

	/* trying to unlock */
	sm_tuner_stop_tunning( g_dev_name );

	/* initialize the device */
	iret = sm_init_device(g_dev_name);
	if(iret < 0){
		printf("**ERROR** device initialization error\n");
		return;
	}

#ifdef USE_FIXED_KEY_CAS  
	/* trying to lock and set PID and IP address */
	iret = tunning_card_for_resetting_cw( );
	if( !iret ){
		printf("**ERROR** tuner lock fail\n");
		return;
	}else if( iret == 1 ){
		printf("**ERROR** tuner lock success but fail to set PID\n");
		return;
	}
#else
	/* trying to lock and set PID and IP address */
	if(!tunning_card( )){
		printf("**ERROR** tuner lock fail\n");
		return;
	}
#endif

	printf("\n\n[ -- Initialization is successful -- ]\n");

}


/*
 * Func : quit_card
 * Context :
 */
void quit_card(int argc, char *argv[])
{
	int iret,opt,command;
	command = 0;
	
	while((opt = getopt(argc, argv, "qd:")) != -1){
		switch(opt){
			case 'q':
				command = 1;
			break;
			
			case 'd':
				strcpy(g_dev_name,optarg);
			break;
			
			case '?':
			{
				printf("**ERROR** unknown option: %c\n",optopt);
				command = 0;
			}
			break;
		}
	}
	for(;optind < argc; optind++){
		printf("**ERROR** unknown argument: %s\n",argv[optind]);
		command = 0;
	}	
	if(!command) return;

	printf("[Device name: %s\n",g_dev_name );

	iret = sm_get_device_status( g_dev_name );
	if(iret < 0){
		if(iret == ERR_OPEN_SOCKET){
			printf("**ERROR** network interface open error\n");
		}else if(iret == ERR_NOT_DEVICE){
			printf("**ERROR** device not found\n");
		}else if(iret == ERR_NOT_DEVICE_OPEN){
			printf("**ERROR** device not open\n");
		}else{
			printf("**ERROR** unknown error code[%d]\n",iret);
		}
		return;
	}else{
		/* trying to unlock */
		sm_tuner_stop_tunning( g_dev_name );

		/* LNB power off */
	    	sm_lnb_set_power( g_dev_name, OFF );
	
		/* exit the device */
		sm_exit_device(g_dev_name);

		printf("\n\n[ -- Termination is successful -- ]\n");
	}
}


/*
 * Func : main
 * Context :
 */
int main( int argc, char *argv[] )
{
	char *pstr;
	
	display_info();
    	
	strcpy(g_dirname2,argv[0]);
	pstr = strrchr(g_dirname2,'/');
	if(pstr){
	       	pstr[1] = 0;
	}else{
	       	strcpy(g_dirname2,"./");
	}
	
	g_dirname2[0] = 0;
	if(argc <= 1){
		display_options( );
		action_card(argc,argv);
		return 0;
	}
	
	if(argv[1][0] != '-'){
		display_options( );
		return 0;
	}
	
	
	switch(argv[1][1])
	{
		case 'a':
			action_card(argc,argv);
		break;

		case 'r':
			reaction_card(argc,argv);
		break;

		case 'q':
			quit_card(argc,argv);
		break;

		case 's':
			status_card(argc,argv);
		break;

		case 'h':
			display_options();
		break;

		case 'm':
			get_more_info(argc,argv);
		break;

		default:
			display_options();
		return 0;
	}
	printf("\n");
	return 0;	
}
