/* ----------------------------------------------- */
/* company : pentamedia
 * author  : elcomski 
 * file    : tpdlg.c 
 * date    : 2000-03-20
 * modify  : 2001-12-13 by elcomski
 */
/* ----------------------------------------------- */
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <gtk/gtk.h>

#include "../../share/xptype.h"
#include "../../share/ifdef.h"
#include "../libif/pentapi.h"
#include "../libapp/avifunc.h"
#include "avicos.h"



/*--------------------------------*/
/* Variable definitions */
/*--------------------------------*/
char diseqc_list[20][20] = {
	"None",
	"Port1",
	"Port2",
	"Port3",
	"Port4",
	"Port5",
	"Port6",
	"Port7",
	"Port8",
	"Port9",
	"Port10",
	"Port11",
	"Port12",
	"Port13",
	"Port14",
	"Port15",
	"Port16",
	"endofdata"
};

char viterbi_list[20][20] = {
	"1/2",
	"2/3",
	"3/4",
	"5/6",
	"7/8",
	"Auto",
	"endofdata"
};

char lnbtype_list[10][20] = {
	"None",
	"9300",
	"9750",
	"10000",
	"10600",
	"10750",
	"11300",
	"Universal",
	"endofdata"
};

abool g_Answer = FALSE;

str_trans_data g_trans_info;
str_trans_data *g_ptp;

GtkWidget *diseqc_combo;
GtkWidget *band_combo;
GtkWidget *polar_combo;
GtkWidget *k22_combo;
GtkWidget *viterbi_combo;
GtkWidget *lnbtype_combo;
GtkWidget *diseqc_combo;
GtkWidget *autopid_check;
GtkWidget *satname_entry;
GtkWidget *tpname_entry;
GtkWidget *freq_entry;
GtkWidget *symbol_entry;
GtkWidget *pid_entry;
GtkWidget *pid_listbox;
GtkWidget *decimal_radio;
GtkWidget *g_sel_widget;

extern char diseqc_list[20][20];
extern char viterbi_list[20][20];
extern char lnbtype_list[10][20];
extern str_pid_data g_pid_data;



/*--------------------------------*/
/* Function definitions */
/*--------------------------------*/
/*
 * Func : ClosingDialog
 * Context :
 */
void ClosingDialog (GtkWidget *widget, gpointer data)
{
	gtk_grab_remove (GTK_WIDGET (widget));    
}


/*
 * Func : signal_yes
 * Context :
 */
void signal_yes(GtkWidget *widget, gpointer data)
{

	abool bstate;
	char *pstr;

	pstr = gtk_entry_get_text( GTK_ENTRY ( satname_entry));
	strcpy(g_trans_info.sat_name, pstr);
	
	pstr = gtk_entry_get_text( GTK_ENTRY ( tpname_entry));
	strcpy(g_trans_info.tp_name, pstr);

	pstr = gtk_entry_get_text( GTK_ENTRY ( freq_entry));
	g_trans_info.down_frequency = atof(pstr);

	pstr = gtk_entry_get_text( GTK_ENTRY (symbol_entry));
	g_trans_info.symbol_rate = atof(pstr);
    
	pstr = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO(polar_combo)->entry));
	if(strcmp(pstr,"VER") == 0)
		g_trans_info.en_lnb_polar = LNB_POL_VERTICAL;
	else 
		g_trans_info.en_lnb_polar = LNB_POL_HORIZONTAL;

	pstr = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO(band_combo)->entry));
	if(strcmp(pstr,"C") == 0)
		g_trans_info.en_lnb_band = BAND_C;
	else 
		g_trans_info.en_lnb_band = BAND_KU;

	pstr = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO(k22_combo)->entry));
	if(strcmp(pstr,"Off") == 0)
		g_trans_info.lnb_22khz_on_off = OFF;
	else 
		g_trans_info.lnb_22khz_on_off = ON;

	pstr = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO(viterbi_combo)->entry));
	if(strcmp(pstr,"1/2") == 0) 
		g_trans_info.en_viterbi = FEC_INNER_1_2;
	else if(strcmp(pstr,"2/3") == 0) 
		g_trans_info.en_viterbi = FEC_INNER_2_3;
	else if(strcmp(pstr,"3/4") == 0) 
		g_trans_info.en_viterbi = FEC_INNER_3_4;
	else if(strcmp(pstr,"5/6") == 0) 
		g_trans_info.en_viterbi = FEC_INNER_5_6;
	else if(strcmp(pstr,"7/8") == 0) 
		g_trans_info.en_viterbi = FEC_INNER_7_8;
	else 
		g_trans_info.en_viterbi = FEC_AUTOMATIC;

	pstr = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO(lnbtype_combo)->entry));
	if(strcmp(pstr,"None") == 0) 
		g_trans_info.en_lnb_type = LNB_NONE;
	else if(strcmp(pstr,"9300") == 0) 
		g_trans_info.en_lnb_type = LNB_9300;
	else if(strcmp(pstr,"9750") == 0)
		g_trans_info.en_lnb_type = LNB_9750;
	else if(strcmp(pstr,"10000") == 0)
		g_trans_info.en_lnb_type = LNB_10000;
	else if(strcmp(pstr,"10600") == 0)
		g_trans_info.en_lnb_type = LNB_10600;
	else if(strcmp(pstr,"10750") == 0)
		g_trans_info.en_lnb_type = LNB_10750;
	else if(strcmp(pstr,"11300") == 0)
		g_trans_info.en_lnb_type = LNB_11300;
	else 
		g_trans_info.en_lnb_type = LNB_UNIVERSAL;

	pstr = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO(diseqc_combo)->entry));
	if(strcmp(pstr,"Port1") == 0)
		g_trans_info.en_diseqc = DISEqC_Port1;
	else if(strcmp(pstr,"Port2") == 0)
		g_trans_info.en_diseqc = DISEqC_Port2;
	else if(strcmp(pstr,"Port3") == 0)
		g_trans_info.en_diseqc = DISEqC_Port3;
	else if(strcmp(pstr,"Port4") == 0)
		g_trans_info.en_diseqc = DISEqC_Port4;
	else if(strcmp(pstr,"Port5") == 0)
		g_trans_info.en_diseqc = DISEqC_Port5;
	else if(strcmp(pstr,"Port6") == 0)
		g_trans_info.en_diseqc = DISEqC_Port6;
	else if(strcmp(pstr,"Port7") == 0)
		g_trans_info.en_diseqc = DISEqC_Port7;
	else if(strcmp(pstr,"Port8") == 0)
		g_trans_info.en_diseqc = DISEqC_Port8;
	else if(strcmp(pstr,"Port9") == 0)
		g_trans_info.en_diseqc = DISEqC_Port9;
	else if(strcmp(pstr,"Port10") == 0)
		g_trans_info.en_diseqc = DISEqC_Port10;
	else if(strcmp(pstr,"Port11") == 0)
		g_trans_info.en_diseqc = DISEqC_Port11;
	else if(strcmp(pstr,"Port12") == 0)
		g_trans_info.en_diseqc = DISEqC_Port12;
	else if(strcmp(pstr,"Port13") == 0)
		g_trans_info.en_diseqc = DISEqC_Port13;
	else if(strcmp(pstr,"Port14") == 0)
		g_trans_info.en_diseqc = DISEqC_Port14;
	else if(strcmp(pstr,"Port15") == 0)
		g_trans_info.en_diseqc = DISEqC_Port15;
	else if(strcmp(pstr,"Port16") == 0)
		g_trans_info.en_diseqc = DISEqC_Port16;
	else 
		g_trans_info.en_diseqc = DISEqC_None;

	bstate = gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON(autopid_check));
	if(bstate == FALSE)
		g_trans_info.auto_pid = OFF;
	else 
		g_trans_info.auto_pid = ON;

	g_Answer = TRUE;
	memcpy(g_ptp, &g_trans_info, sizeof(g_trans_info));

#if 0
	printf("-----------------------------------\n");
	printf("sat name:%s\n",g_trans_info.sat_name);
	printf("tpname  :%s\n",g_trans_info.tp_name);
	printf("Freq    :%f\n",g_trans_info.down_frequency);
	printf("Symbol  :%f\n",g_trans_info.symbol_rate);
	printf("Polar   :%d\n",g_trans_info.en_lnb_polar);
	printf("Band    :%d\n",g_trans_info.en_lnb_band);
	printf("22K     :%d\n",g_trans_info.lnb_22khz_on_off);
	printf("Viterbi :%d\n",g_trans_info.en_viterbi);
	printf("LNB type:%d\n",g_trans_info.en_lnb_type);
	printf("DiSEqC  :%d\n",g_trans_info.en_diseqc);
	printf("AutoPid :%d\n",g_trans_info.auto_pid);
	for( i = 0 ; i < g_pid_data.count; i++){
		printf("Pid[%d] :%d\n",i,g_pid_data.pid[i]);
	}
	printf("-----------------------------------\n");
#endif

	if( set_tuner(g_trans_info) ){
		set_pid_info();
	}
	
	gtk_widget_destroy (GTK_WIDGET (data)); 
	
	refresh_status( );
}


/*
 * Func : signal_no
 * Context :
 */
void signal_no(GtkWidget *widget, gpointer data)
{
	memcpy(g_ptp, &g_trans_info, sizeof(g_trans_info));
    	g_Answer = FALSE;
    	gtk_widget_destroy (GTK_WIDGET (data));    
}


/*
 * Func : add_pid_event
 * Context :
 */
void add_pid_event( GtkWidget *widget, gpointer data)
{
	char *pstr;
	char sbuf[50];
	abool bState;
	int i,iPid;
	GtkWidget *item;

	bState = gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON(decimal_radio));
	pstr = gtk_entry_get_text (GTK_ENTRY (pid_entry));
	if(bState) iPid = atoi(pstr);
	else iPid = strtol(pstr,NULL,16); 

	if(g_pid_data.count >= 8) return;
	for(i=0; i<g_pid_data.count; i++) {
		if(iPid == g_pid_data.pid[i]) return;
	}

	if(bState) sprintf(sbuf,"%d",iPid);
	else sprintf(sbuf,"%x",iPid);

	item = gtk_list_item_new_with_label (sbuf);
	gtk_container_add (GTK_CONTAINER (pid_listbox), item);
	gtk_widget_show (item);

	g_pid_data.pid[g_pid_data.count] = iPid;
	g_pid_data.count++;
    
}

/*
 * Func : select_event
 * Context :
 */
void select_event(GtkList *list, GtkWidget *widget, gpointer ud)
{
	g_sel_widget = widget;    
}

/*
 * Func : unselect_event
 * Context :
 */
void unselect_event(GtkList *list, GtkWidget *widget, gpointer ud)
{
	g_sel_widget = NULL;
}


/*
 * Func : delete_pid_event
 * Context :
 */
void delete_pid_event( GtkWidget *widget, gpointer data)
{
	int i,j;
       
	if(g_sel_widget == NULL) return;
	i = gtk_list_child_position(GTK_LIST(pid_listbox),g_sel_widget);
    	gtk_list_clear_items (GTK_LIST(pid_listbox),i,i+1);
	g_pid_data.count--;
    	for(j=i; j<g_pid_data.count; j++)
    	{
	    g_pid_data.pid[j] = g_pid_data.pid[j+1];
    	}
}


/*
 * Func : delete_all_pid_event
 * Context :
 */
void delete_all_pid_event( GtkWidget *widget, gpointer data)
{
    
    	gtk_list_clear_items (GTK_LIST(pid_listbox),0,-1);
	g_pid_data.count = 0;
}


/*
 * Func : decimal_radio_event
 * Context :
 */
void decimal_radio_event( GtkWidget *widget, gpointer data)
{
	char sbuf[50];
	abool bState;
	int i;
	GtkWidget *item;

	gtk_list_clear_items (GTK_LIST(pid_listbox),0,-1);
	bState = gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON(decimal_radio));

	for(i=0; i<g_pid_data.count; i++) {
		if(bState) sprintf(sbuf,"%d",g_pid_data.pid[i]);
		else sprintf(sbuf,"%x",g_pid_data.pid[i]);

		item = gtk_list_item_new_with_label (sbuf);
		gtk_container_add (GTK_CONTAINER (pid_listbox), item);
		gtk_widget_show (item);
	} 
}


/*
 * Func : hex_radio_event
 * Context :
 */
void hex_radio_event( GtkWidget *widget, gpointer data)
{
	char sbuf[50];
	abool bState;
	int i;
	GtkWidget *item;

	gtk_list_clear_items (GTK_LIST(pid_listbox),0,-1);
	bState = gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON(decimal_radio));

	for(i=0; i<g_pid_data.count; i++){
		if(bState) sprintf(sbuf,"%d",g_pid_data.pid[i]);
		else sprintf(sbuf,"%x",g_pid_data.pid[i]);

		item = gtk_list_item_new_with_label (sbuf);
		gtk_container_add (GTK_CONTAINER (pid_listbox), item);
		gtk_widget_show (item);
	} 
}


/*
 * Func : draw_dialog
 * Context :
 */
void draw_dialog(str_trans_data tp)
{
	int i;
	int itemp;
	char *pstr;
	GtkWidget *dialog_window;
	GtkWidget *label;
	GtkWidget *button;
	GtkWidget *vbox;
	GtkWidget *entry;
	GtkWidget *table;
	GtkWidget *item;
	GtkWidget *frame;
	GtkWidget *listbox;
	GtkWidget *radio,*check;
	GtkWidget *scrolled_window;
	GSList *group = NULL;
	GList *cbitems;
	char sbuf[100];
	int xoptions, yoptions;

	xoptions = GTK_FILL | GTK_EXPAND;
	yoptions = GTK_FILL | GTK_EXPAND;

	/* Create a new window */
	dialog_window = gtk_dialog_new ();

	gtk_signal_connect(GTK_OBJECT(dialog_window), "destroy", GTK_SIGNAL_FUNC(ClosingDialog), &dialog_window);

	gtk_window_set_title(GTK_WINDOW(dialog_window), "Transponder infomation");

	gtk_container_border_width(GTK_CONTAINER(dialog_window),5);


	frame = gtk_frame_new (" Satellite Info ");
	gtk_box_pack_start( GTK_BOX (GTK_DIALOG (dialog_window)->vbox), frame, TRUE, TRUE, 0);
	gtk_widget_show (frame);

	table = gtk_table_new ( 8, 3, TRUE);
	gtk_container_set_border_width ( GTK_CONTAINER(table), 10);
	gtk_container_add( GTK_CONTAINER( frame), table);
	gtk_widget_show(table);


	/*
	 * Satellite Info
	 */
	label = gtk_label_new("Satellite");
	gtk_misc_set_alignment(GTK_MISC(label),.5,1);
	gtk_misc_set_padding(GTK_MISC(label), 10, 0);
	gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 0, 1); 
	gtk_widget_show(label);

	label = gtk_label_new("Transponder");
	gtk_misc_set_alignment(GTK_MISC(label),.5, 1);
	gtk_misc_set_padding(GTK_MISC(label), 10, 0);
	gtk_table_attach_defaults (GTK_TABLE (table), label, 1, 2, 0, 1); 
	gtk_widget_show(label);

	entry = gtk_entry_new_with_max_length (10);
	sprintf(sbuf,"%s",tp.sat_name); 
	gtk_entry_set_text (GTK_ENTRY (entry), sbuf);
	gtk_widget_set_usize( entry, 60, 20);
	gtk_table_attach (GTK_TABLE (table), entry, 0, 1, 1, 2, xoptions, yoptions, 10, 0);
	gtk_widget_show (entry);
	satname_entry = entry;

	entry = gtk_entry_new_with_max_length (10);
	sprintf(sbuf,"%s",tp.tp_name); 
	gtk_entry_set_text (GTK_ENTRY (entry), sbuf);
	gtk_table_attach (GTK_TABLE (table), entry, 1, 2, 1, 2, xoptions, yoptions, 10, 0);
	gtk_widget_set_usize( entry, 60, 20);
	gtk_widget_show (entry);
	tpname_entry = entry;


	/*
	 * Transponder Info
	 */
	label = gtk_label_new("Frequancy[MHz]");
	gtk_misc_set_alignment(GTK_MISC(label), .5, 1);
	gtk_misc_set_padding(GTK_MISC(label), 10, 0);
	gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 2, 3);
	gtk_widget_show(label);

	label = gtk_label_new("Symbol Rate[MSPS]");
	gtk_misc_set_alignment(GTK_MISC(label),.5,1);
	gtk_misc_set_padding(GTK_MISC(label), 10, 0);
	gtk_table_attach_defaults (GTK_TABLE (table), label, 1, 2, 2, 3);
	gtk_widget_show(label);

	entry = gtk_entry_new_with_max_length (10); 
	sprintf(sbuf,"%f",tp.down_frequency);
	gtk_entry_set_text (GTK_ENTRY (entry), sbuf);
	gtk_table_attach (GTK_TABLE (table), entry, 0, 1, 3, 4,
	xoptions, yoptions, 10, 0);
	gtk_widget_set_usize( entry, 60, 20);
	gtk_widget_show (entry);
	freq_entry = entry;

	entry = gtk_entry_new_with_max_length (10);
	sprintf(sbuf,"%f",tp.symbol_rate); 
	gtk_entry_set_text (GTK_ENTRY (entry), sbuf);
	gtk_table_attach (GTK_TABLE (table), entry, 1, 2, 3, 4,
	xoptions, yoptions, 10, 0);
	gtk_widget_set_usize( entry, 60, 20);
	gtk_widget_show (entry);
	symbol_entry = entry;

	/*
	 * Detail Info
	 */
	label = gtk_label_new("Bandwidth");
	gtk_misc_set_alignment(GTK_MISC(label),.5,1);
	gtk_misc_set_padding(GTK_MISC(label), 10, 0);
	gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 4, 5);
	gtk_widget_show(label);

	label = gtk_label_new("Polarization");
	gtk_misc_set_alignment(GTK_MISC(label),.5,1);
	gtk_misc_set_padding(GTK_MISC(label), 10, 0);
	gtk_table_attach_defaults (GTK_TABLE (table), label, 1, 2, 4, 5);
	gtk_widget_show(label);

	label = gtk_label_new("Viterbi Rate");
	gtk_misc_set_alignment(GTK_MISC(label),.5,1);
	gtk_misc_set_padding(GTK_MISC(label), 10, 0);
	gtk_table_attach_defaults (GTK_TABLE (table), label, 2, 3, 4, 5);
	gtk_widget_show(label);

	cbitems = NULL;
	cbitems = g_list_append (cbitems, "C");
	cbitems = g_list_append (cbitems, "KU");
	if(tp.en_lnb_band == BAND_C) pstr = "C";
	else pstr = "KU";

	band_combo = gtk_combo_new( );
	gtk_combo_set_popdown_strings (GTK_COMBO(band_combo), cbitems);
	gtk_entry_set_text(GTK_ENTRY (GTK_COMBO(band_combo)->entry),pstr);
	entry = GTK_WIDGET(GTK_COMBO (band_combo)->entry);
	gtk_entry_set_editable (GTK_ENTRY(entry), FALSE);
	gtk_table_attach (GTK_TABLE (table), band_combo, 0, 1, 5, 6, xoptions, yoptions, 10, 0);
	gtk_widget_set_usize( entry, 60, 20);
	gtk_widget_show (band_combo);

	cbitems = NULL;
	cbitems = g_list_append (cbitems, "VER");
	cbitems = g_list_append (cbitems, "HOR");
	if(tp.en_lnb_polar == LNB_POL_VERTICAL) pstr = "VER";
	else pstr = "HOR";

	polar_combo = gtk_combo_new ();
	gtk_combo_set_popdown_strings (GTK_COMBO(polar_combo), cbitems);
	gtk_entry_set_text (GTK_ENTRY (GTK_COMBO(polar_combo)->entry),pstr);
	entry = GTK_WIDGET (GTK_COMBO (polar_combo)->entry);
	gtk_entry_set_editable (GTK_ENTRY(entry), FALSE);
	gtk_table_attach (GTK_TABLE (table), polar_combo, 1, 2, 5, 6, xoptions, yoptions, 10, 0);
	gtk_widget_set_usize( entry, 60, 20);
	gtk_widget_show (polar_combo);

	cbitems = NULL;
	i = 0;
	do{
		cbitems = g_list_append (cbitems, viterbi_list[i]);
		i++;
	}while(strcmp(viterbi_list[i],"endofdata") != 0);

	viterbi_combo = gtk_combo_new( );
	gtk_combo_set_popdown_strings (GTK_COMBO(viterbi_combo), cbitems);
	itemp = 0;
	switch(tp.en_viterbi){
		case FEC_INNER_1_2:itemp = 0;break;
		case FEC_INNER_2_3:itemp = 1;break;
		case FEC_INNER_3_4:itemp = 2;break;
		case FEC_INNER_5_6:itemp = 3;break;
		case FEC_INNER_7_8:itemp = 4;break;
		case FEC_AUTOMATIC:itemp = 5;break;
	}
	gtk_entry_set_text (GTK_ENTRY (GTK_COMBO(viterbi_combo)->entry),viterbi_list[itemp]);
	entry = GTK_WIDGET (GTK_COMBO (viterbi_combo)->entry);
	gtk_entry_set_editable (GTK_ENTRY(entry), FALSE);
	gtk_table_attach (GTK_TABLE (table), viterbi_combo, 2, 3, 5, 6, xoptions, yoptions, 10, 0);
	gtk_widget_set_usize( entry, 60, 20);
	gtk_widget_show (viterbi_combo);

	/*
	 * Detail Info (II)
	 */
	label = gtk_label_new("22Khz tone");
	gtk_misc_set_alignment(GTK_MISC(label),.5,1);
	gtk_misc_set_padding(GTK_MISC(label), 10, 0);
	gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 6, 7);
	gtk_widget_show(label);

	label = gtk_label_new("DiSEqC");
	gtk_misc_set_alignment(GTK_MISC(label),.5,1);
	gtk_misc_set_padding(GTK_MISC(label), 10, 0);
	gtk_table_attach_defaults (GTK_TABLE (table), label, 1, 2, 6, 7);
	gtk_widget_show(label);

	label = gtk_label_new("LNB type");
	gtk_misc_set_alignment(GTK_MISC(label),.5,1);
	gtk_misc_set_padding(GTK_MISC(label), 10, 0);
	gtk_table_attach_defaults (GTK_TABLE (table), label, 2, 3, 6, 7);
	gtk_widget_show(label);

	cbitems = NULL;
	cbitems = g_list_append (cbitems, "Off");
	cbitems = g_list_append (cbitems, "On");
	if(tp.lnb_22khz_on_off == 0) pstr = "Off";
	else pstr = "On";

	k22_combo = gtk_combo_new( );
	gtk_combo_set_popdown_strings (GTK_COMBO(k22_combo), cbitems);
	gtk_entry_set_text (GTK_ENTRY (GTK_COMBO(k22_combo)->entry),pstr);
	entry = GTK_WIDGET (GTK_COMBO (k22_combo)->entry);
	gtk_entry_set_editable (GTK_ENTRY(entry), FALSE);
	gtk_table_attach (GTK_TABLE (table), k22_combo, 0, 1, 7, 8, xoptions, yoptions, 10, 0);
	gtk_widget_set_usize( entry, 60, 20);
	gtk_widget_show (k22_combo);

	cbitems = NULL;
	i = 0;
	do{
		cbitems = g_list_append (cbitems, diseqc_list[i]);
		i++;
	}while(strcmp(diseqc_list[i],"endofdata") != 0);

	diseqc_combo = gtk_combo_new( );
	gtk_combo_set_popdown_strings (GTK_COMBO(diseqc_combo), cbitems);
	itemp = 0;
	switch(tp.en_diseqc){
		case DISEqC_None:itemp = 0;break;
		case DISEqC_Port1:itemp = 1;break;
		case DISEqC_Port2:itemp = 2;break;
		case DISEqC_Port3:itemp = 3;break;
		case DISEqC_Port4:itemp = 4;break;
		case DISEqC_Port5:itemp = 5;break;
		case DISEqC_Port6:itemp = 6;break;
		case DISEqC_Port7:itemp = 7;break;
		case DISEqC_Port8:itemp = 8;break;
		case DISEqC_Port9:itemp = 9;break;
		case DISEqC_Port10:itemp = 10;break;
		case DISEqC_Port11:itemp = 11;break;
		case DISEqC_Port12:itemp = 12;break;
		case DISEqC_Port13:itemp = 13;break;
		case DISEqC_Port14:itemp = 14;break;
		case DISEqC_Port15:itemp = 15;break;
		case DISEqC_Port16:itemp = 16;break;
	}
	gtk_entry_set_text (GTK_ENTRY (GTK_COMBO(diseqc_combo)->entry),diseqc_list[itemp]);
	entry = GTK_WIDGET (GTK_COMBO (diseqc_combo)->entry);
	gtk_entry_set_editable (GTK_ENTRY(entry), FALSE);
	gtk_table_attach (GTK_TABLE (table), diseqc_combo, 1, 2, 7, 8, xoptions, yoptions, 10, 0);
	gtk_widget_set_usize( entry, 60, 20);
	gtk_widget_show (diseqc_combo);

	cbitems = NULL;
	i = 0;
	do{
		cbitems = g_list_append (cbitems, lnbtype_list[i]);
		i++;
	}while(strcmp(lnbtype_list[i],"endofdata") != 0);

	lnbtype_combo = gtk_combo_new( );
	gtk_combo_set_popdown_strings (GTK_COMBO(lnbtype_combo), cbitems);
	itemp = 0;
	switch(tp.en_lnb_type){
		case LNB_NONE:itemp = 0;break;
		case LNB_9300:itemp = 1;break;
		case LNB_9750:itemp = 2;break;
		case LNB_10000:itemp = 3;break;
		case LNB_10600:itemp = 4;break;
		case LNB_10750:itemp = 5;break;
		case LNB_11300:itemp = 6;break;
		case LNB_UNIVERSAL:itemp = 7;break;
	}
	gtk_entry_set_text (GTK_ENTRY (GTK_COMBO(lnbtype_combo)->entry),lnbtype_list[itemp]);
	entry = GTK_WIDGET (GTK_COMBO (lnbtype_combo)->entry);
	gtk_entry_set_editable (GTK_ENTRY(entry), FALSE);
	gtk_table_attach (GTK_TABLE (table), lnbtype_combo, 2, 3, 7, 8, xoptions, yoptions, 10, 0);
	gtk_widget_set_usize( entry, 60, 20);
	gtk_widget_show (lnbtype_combo);

	xoptions = GTK_FILL | GTK_EXPAND;
	yoptions = GTK_FILL | GTK_EXPAND;

	frame = gtk_frame_new (" PID Info ");
	gtk_box_pack_start( GTK_BOX (GTK_DIALOG (dialog_window)->vbox),
	frame, TRUE, TRUE, 0);
	gtk_widget_show (frame);

	table = gtk_table_new ( 3, 4, FALSE);
	gtk_container_set_border_width ( GTK_CONTAINER(table), 4);
	gtk_container_add( GTK_CONTAINER( frame), table);
	gtk_widget_show(table); 

	entry = gtk_entry_new_with_max_length (10); 
	gtk_entry_set_text (GTK_ENTRY (entry), "0");
	gtk_widget_set_usize( entry, 60, 20);
	gtk_table_attach (GTK_TABLE (table), entry, 0, 1, 0, 1, xoptions, yoptions, 10, 0);
	gtk_widget_set_usize( entry, 60, 20);
	gtk_widget_show (entry);
	pid_entry = entry;

	scrolled_window = gtk_scrolled_window_new(NULL,NULL);
	gtk_widget_set_usize (scrolled_window,80,60);
	gtk_table_attach (GTK_TABLE(table), scrolled_window,0,1,1,4, xoptions, yoptions, 10, 0);
	gtk_widget_show(scrolled_window);

	listbox = gtk_list_new ();
	gtk_list_set_selection_mode(GTK_LIST(listbox), GTK_SELECTION_SINGLE);

	for(i=0;i<g_pid_data.count;i++){
		sprintf(sbuf,"%d",g_pid_data.pid[i]);
		item = gtk_list_item_new_with_label (sbuf);
		gtk_container_add (GTK_CONTAINER (listbox), item);
		gtk_widget_show (item);
	}
	gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW(scrolled_window),
	listbox);
	gtk_signal_connect(GTK_OBJECT (listbox),"select-child", GTK_SIGNAL_FUNC (select_event), (gpointer)"select");

	gtk_signal_connect(GTK_OBJECT (listbox),"unselect-child", GTK_SIGNAL_FUNC (unselect_event), (gpointer)"unselect");

	gtk_widget_show (listbox);
	pid_listbox = listbox;


	vbox = gtk_vbox_new ( TRUE, 0);
	gtk_table_attach (GTK_TABLE (table), vbox, 1, 2, 0, 3, xoptions, yoptions, 2, 0);
	gtk_container_set_border_width (GTK_CONTAINER (vbox), 10);
	gtk_widget_show(vbox);

	button = gtk_button_new_with_label ("Add");
	gtk_signal_connect(GTK_OBJECT (button),"clicked", GTK_SIGNAL_FUNC (add_pid_event), (gpointer)"add");
	gtk_box_pack_start (GTK_BOX (vbox), button, FALSE, FALSE, 0);
	gtk_widget_set_usize( button, 60, 20);
	gtk_widget_show (button);

	button = gtk_button_new_with_label ("Delete");
	gtk_signal_connect(GTK_OBJECT (button),"clicked", GTK_SIGNAL_FUNC (delete_pid_event), (gpointer)"delete");
	gtk_box_pack_start (GTK_BOX (vbox), button, FALSE, FALSE, 0);
	gtk_widget_set_usize( button, 60, 20);
	gtk_widget_show (button);

	button = gtk_button_new_with_label ("Delete all");
	gtk_signal_connect(GTK_OBJECT (button),"clicked", GTK_SIGNAL_FUNC (delete_all_pid_event), (gpointer)"delete all");
	gtk_box_pack_start (GTK_BOX (vbox), button, FALSE, FALSE, 0);
	gtk_widget_set_usize( button, 60, 20);
	gtk_widget_show (button);

	frame = gtk_frame_new ("Option");
	gtk_table_attach (GTK_TABLE (table), frame, 2, 3, 0, 2, xoptions, yoptions, 0, 0);
	gtk_widget_show (frame);

	vbox = gtk_vbox_new ( TRUE, 0);
	gtk_container_add( GTK_CONTAINER( frame), vbox);
	gtk_container_set_border_width (GTK_CONTAINER (vbox), 0);
	gtk_widget_show(vbox);

	radio = gtk_radio_button_new_with_label (group, "Decimal");
	gtk_signal_connect (GTK_OBJECT (radio), "clicked", GTK_SIGNAL_FUNC (decimal_radio_event),(gpointer)"Decimal");
	group = gtk_radio_button_group (GTK_RADIO_BUTTON (radio));
	gtk_box_pack_start (GTK_BOX (vbox), radio, FALSE, FALSE, 0);
	gtk_widget_show (radio); 
	decimal_radio = radio;

	radio = gtk_radio_button_new_with_label (group, "Hex");
	gtk_signal_connect (GTK_OBJECT (button), "clicked", GTK_SIGNAL_FUNC (hex_radio_event),(gpointer)"Hex");
	group = gtk_radio_button_group (GTK_RADIO_BUTTON (radio));
	gtk_box_pack_start (GTK_BOX (vbox), radio, FALSE, FALSE, 0);
	gtk_widget_show (radio); 

	check = gtk_check_button_new_with_label ("Auto multicast PID");
	if(tp.auto_pid == 0)
		gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON(check),FALSE);
	else
		gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON(check),TRUE);

	gtk_table_attach (GTK_TABLE (table), check, 2, 3, 2, 3, xoptions, yoptions, 0, 0);
	gtk_widget_show (check);
	autopid_check = check;

	button = gtk_button_new_with_label("Yes");
	gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(signal_yes), dialog_window);
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX (GTK_DIALOG (dialog_window)->action_area), button, TRUE, TRUE, 0);
	gtk_widget_show (button);


	button = gtk_button_new_with_label ("No");
	gtk_signal_connect (GTK_OBJECT (button), "clicked", GTK_SIGNAL_FUNC (signal_no), dialog_window);
	GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog_window)->action_area), button, TRUE, TRUE, 0);
	gtk_widget_grab_default (button);
	gtk_widget_show (button);

	gtk_widget_show (dialog_window);
	gtk_grab_add (dialog_window);
    
}


/*
 * Func : satellite_dialog
 */
void satellite_dialog(str_trans_data *ptp)
{
	g_ptp = ptp;

	memcpy((void*)&g_trans_info, (void*)ptp, sizeof(g_trans_info)); 

	draw_dialog( g_trans_info );
}

