/* ----------------------------------------------- */
/* company : pentamedia
 * author  : elcomski 
 * file    : hwfpga.h 
 * date    : 2001-06-14
 * modify  : 2001-12-13 by elcomski 
 */
/* ----------------------------------------------- */
#ifndef _HWFPGA_H_
#define _HWFPGA_H_


/*-------------------------------*/
/* Enum definitions */
/*-------------------------------*/
typedef enum{
	RESET_DEC = 0x01,
	RESET_DMX = 0x02,
	RESET_CI = 0x04,
	RESET_ADAC = 0x08,
	RESET_VENC = 0x10,
	RESET_QPSK = 0x20
}reset_t;


/*-------------------------------*/
/* External Functions */
/*-------------------------------*/
extern void FpgaOpenDev( unsigned int pLinear1, unsigned int pLinear2 );
extern void FpgaInit( void );
extern unsigned int FpgaQueryAccess( void );
extern void FpgaDmxCashControl( unsigned int Flag );
extern void FpgaResetDevice( unsigned int FuncRst );
extern void FpgaIrqRegPage( unsigned int OnOff );

extern void FpgaDmxWrite( unsigned int addr, unsigned int data );
extern unsigned int FpgaDmxRead( unsigned int addr );
extern void FpgaEepromRead( unsigned int DevIndex, unsigned char *pData );
extern void FpgaEepromWrite( unsigned int DevIndex, unsigned char *pData );

extern void FpgaReadBPS( unsigned int *pBPS );
extern void FpgaWriteBPS( unsigned int * pBPS );

extern void FpgaIsrControl( unsigned int IsrService );
extern void FpgaLnbControl( unsigned int FuncLnb );

extern void DmxDelay( unsigned long delay );

#endif // _HWFPGA_H_
