/* ----------------------------------------------- */
/* company : pentamedia
 * author  : elcomski 
 * file    : pentadrv.c 
 * date    : 2000-03-15
 * modify  : 2001-12-13 by elcomski
 *
 */
/* ----------------------------------------------- */
#if 0 /* if you want to debug, set to 1 */
#define PENTADRV_DEBUG
#define PENTAPCI_DEBUG
#endif

#include <linux/config.h>
#include <linux/modversions.h> /* to avoid unresolved symbol */
#include <linux/module.h>
#include <linux/version.h>
#include <linux/kernel.h> 	
#include <linux/pci.h>
#include <linux/init.h>
#include <linux/netdevice.h>   /* struct device,other headers */
#include <linux/etherdevice.h> /* eth_type_trans */

#include "debug.h"
#include "version.h"
#include "pridef.h"
#include "pentasn.h"
#include "pentadrv.h"


/*-------------------------------*/
/* Function prototypes */
/*-------------------------------*/
static int __devinit PentaNet_init_one( struct pci_dev *pdev, const struct pci_device_id *ent );
static void __devexit PentaNet_remove_one( struct pci_dev *pdev);
#ifdef CONFIG_PM
#if LINUX_VERSION_CODE > KERNEL_VERSION(2,4,5)
static int PentaNet_suspend( struct pci_dev *pdev, u32 state );
static int PentaNet_resume( struct pci_dev *pdev );
#else
static void PentaNet_suspend( struct pci_dev *pdev );
static void PentaNet_resume( struct pci_dev *pdev );
#endif
#endif /* CONFIG_PM */


/*-------------------------------*/
/* Constant definitions */
/*-------------------------------*/
#define PENTANET_MIN_IO_SIZE 0x80


/*-------------------------------*/
/* Enum definitions */
/*-------------------------------*/
typedef enum{
	PCIBAR0 = 0,
	PCIBAR1,
	PCIBAR2,
	PCIBAR3,
	PCIBAR4,
	PCIBAR5
}pcibar_t;


/*-------------------------------*/
/* Structure definitions */
/*-------------------------------*/
static struct {
	const char *name;
}board_info[] __devinitdata = {
	{ "pentanet0" },
	{ "pentanet1" },
	{ "pentanet2" },
	{ "pentanet3" },
	{ "pentanet4" },
	{ "pentanet5" },
	{ "pentanet6" },
	{ "pentanet7" },
	{ "pentanet8" },
	{ "pentanet9" },
};

static int cards_found = 0;

static struct pci_device_id pentanet_pci_tbl[] __devinitdata = {
	{ PENTANET_VENDOR_ID, PENTANET_DEVICE_ID, PENTANET_SUBSYSTEM_VENDOR_ID, PENTANET_SUBSYSTEM_ID, 0, 0, 0 },
	{ 0, }
};
MODULE_DEVICE_TABLE ( pci,pentanet_pci_tbl );

static struct pci_driver pentanet_pci_driver = {
	name: PENTANET_MODNAME,
	id_table: pentanet_pci_tbl,
	probe: PentaNet_init_one,
	remove: PentaNet_remove_one,
#ifdef CONFIG_PM
	suspend: PentaNet_suspend,
	resume: PentaNet_resume,
#endif /* CONFIG_PM */
};
MODULE_AUTHOR("PentaMedia ");
MODULE_DESCRIPTION("Pent@NET Driver");
MODULE_LICENSE("GPL");


/*-------------------------------*/
/* Function definitions */
/*-------------------------------*/
/* 
 * Func : PentaNet_init_board  
 * Context :
 */
static int __devinit PentaNet_init_board( struct pci_dev *pdev, struct net_device **dev_out, void **mmio0_addr_out, void **mmio0_vaddr_out, void **mmio2_addr_out, void **mmio2_vaddr_out )
{
	struct net_device *dev;
	struct pentanet_private *tp;
	u32 mmio0_start,mmio0_end,mmio0_flags,mmio0_len;
	u32 mmio2_start,mmio2_end,mmio2_flags,mmio2_len;
	void *mmio0_addr,*mmio0_vaddr;
	void *mmio2_addr,*mmio2_vaddr;
	int rc;

	/* Inititalize variables */
	mmio0_addr = NULL;
	mmio0_vaddr = NULL;
	mmio2_addr = NULL;
	mmio2_vaddr = NULL;
	*mmio0_vaddr_out = NULL;
	*mmio2_vaddr_out = NULL;
	*dev_out = NULL;

	/* dev zeroed int init_etherdev */
	dev = init_etherdev ( NULL, sizeof(struct pentanet_private));

	if(dev == NULL){
		printk(KERN_ERR "unable to alloc new ethernet\n");
		printk(KERN_ERR "EXIT, returning -ENOMEM\n");
		return -ENOMEM;
	}
	memcpy(dev->name, board_info[cards_found].name, strlen(board_info[cards_found].name ) );

	SET_MODULE_OWNER(dev);
	tp = dev->priv;
	
	/* PCI base address register for memory access 
	 * to local,runtime and dma registers */
	mmio0_start = pci_resource_start(pdev,PCIBAR0);
	mmio0_end = pci_resource_end(pdev,PCIBAR0);
	mmio0_flags = pci_resource_flags(pdev,PCIBAR0);
	mmio0_len = pci_resource_len(pdev,PCIBAR0);

	/* PCI base address register for memory access 
	 * to local address space 0 */
	mmio2_start = pci_resource_start(pdev,PCIBAR2);
	mmio2_end = pci_resource_end(pdev,PCIBAR2);
	mmio2_flags = pci_resource_flags(pdev,PCIBAR2);
	mmio2_len = pci_resource_len(pdev,PCIBAR2);

	/* set this immediately, we need to know before
	 * we talk to the chip directly */
#ifdef PENTADRV_DEBUG
	dbgPrintk("MMIO0 region size:start 0x%X-> 0x%X,len:0x%02X\n", mmio0_start, mmio0_end, mmio0_len );
	dbgPrintk("MMIO2 region size:start 0x%X-> 0x%X,len:0x%02X\n", mmio2_start, mmio2_end, mmio2_len );
#endif
	
	/* make sure PCI base addr 0 is MMIO */
	if(!(mmio0_flags & IORESOURCE_MEM)){
		printk(KERN_ERR "region #0 not a MMIO resource, aborting\n");
		rc = -ENODEV;
		goto err_out;
	}
	
	/* make sure PCI base addr 2 is MMIO */
	if(!(mmio2_flags & IORESOURCE_MEM)){
		printk(KERN_ERR "region #2 not a MMIO resource, aborting\n");
		rc = -ENODEV;
		goto err_out;
	}

	/* check for weird/broken PCI region reporting */
	if((mmio0_len < PENTANET_MIN_IO_SIZE) || (mmio2_len < PENTANET_MIN_IO_SIZE)){
		printk(KERN_ERR "Invalid PCI region size, aborting\n");
		rc = -ENODEV;
		goto err_out;
	}

#if 0
	/* check_mem_region : physical address */
	if(check_mem_region(mmio0_start,mmio0_len)){
		printk(KERN_ERR "check mem region #0 not a MMIO resource, aborting\n");
		goto err_out;
	}

	if(check_mem_region(mmio2_start,mmio2_len)){
		printk(KERN_ERR "check mem region #2 not a MMIO resource, aborting\n");
		goto err_out;
	}
#endif
	
	/* make sure our MMIO0 region in PCI space is available */
	if(!request_mem_region( mmio0_start, mmio0_len, dev->name))
	{
		printk(KERN_ERR "no mem(mmio0) resource available, aborting\n");
		rc = -EBUSY;
		goto err_out_free_mmio;
	}

	/* make sure our MMIO2 region in PCI space is available */
	if(!request_mem_region( mmio2_start, mmio2_len, dev->name))
	{
		printk(KERN_ERR "no mem(mmio2) resource available, aborting\n");
		rc = -EBUSY;
		goto err_out_free_mmio;
	}

	/* enable device(incl. PCI PM wakeup), and bus-mastering */
	rc = pci_enable_device(pdev);
	if( rc )
		goto err_out_free_mmio;

	/* save physical address */
	mmio0_addr = (void *)mmio0_start;
	mmio2_addr = (void *)mmio2_start;
	
	/* ioremap MMIO0  region */
	mmio0_vaddr = ioremap (mmio0_start, mmio0_len);
	if(mmio0_vaddr == NULL){
		printk(KERN_ERR "cannot remap MMIO0, aborting\n");
		rc = -EIO;
		goto err_out_free_mmio;
	}

	/* ioremap MMIO2  region */
	mmio2_vaddr = ioremap (mmio2_start, mmio2_len);
	if(mmio2_vaddr == NULL){
		printk(KERN_ERR "cannot remap MMIO2, aborting\n");
		rc = -EIO;
		goto err_out_free_mmio;
	}
	
#ifdef PENTADRV_DEBUG /* MEMORY DEBUG */ 	
	dbgPrintk("virtual MMIO0 region start 0x%x\n",(unsigned int)mmio0_vaddr);
	dbgPrintk("virtual MMIO2 region start 0x%x\n",(unsigned int)mmio2_vaddr);
#endif
	/* save PCI(phy. and vir.) address */
	*mmio0_addr_out = mmio0_addr;
	*mmio0_vaddr_out = mmio0_vaddr;
	*mmio2_addr_out = mmio2_addr;
	*mmio2_vaddr_out = mmio2_vaddr;
	
	*dev_out = dev;
	
	return 0;

err_out_free_mmio:
	release_mem_region(mmio0_start,mmio0_len);
	release_mem_region(mmio2_start,mmio2_len);
err_out:
	unregister_netdev(dev);
	kfree(dev);
	printk(KERN_ERR "EXIT, returning %d\n",rc);
	return rc;
}


/* 
 * Func : PentaNet_init_one  
 * Context :
 * 	return 0 -> ok
 * 	return except 0 -> error
 */
static int __devinit PentaNet_init_one( struct pci_dev *pdev, const struct pci_device_id *ent )
{
	struct net_device *dev;
	struct pentanet_private *tp;
	void *mmio0_addr,*mmio2_addr;
	void *mmio0_vaddr,*mmio2_vaddr;
	static int retval = 0;
	
	/* Initialize variables */
	mmio0_vaddr = NULL;
	mmio2_vaddr = NULL;
	dev = NULL;
	
#ifdef PENTAPCI_DEBUG 
	dbgPrintk("[bus:0x%x,device:0x%x,function:0x%x]\n", pdev->bus->number, PCI_SLOT(pdev->devfn), PCI_FUNC(pdev->devfn) );
	dbgPrintk("[vender/device/subvendor/subdevice:0x%04x,0x%04x,0x%04x,0x%04x]\n", ent->vendor,ent->device, ent->subvendor,ent->subdevice);
#endif

	retval = PentaNet_init_board( pdev, &dev, &mmio0_addr, &mmio0_vaddr, &mmio2_addr, &mmio2_vaddr );
	if(retval < 0){
		printk(KERN_ERR "EXIT, returning %d\n",retval);
		return retval;
	}
	
	/* The PentaNet-specific entries in the device structure */
	dev->open = PentaNet_open;
	dev->stop = PentaNet_close;
	dev->set_config = PentaNet_config;
	dev->hard_start_xmit = PentaNet_start_xmit;
	dev->do_ioctl = PentaNet_ioctl;
	dev->get_stats = PentaNet_get_stats;
	dev->rebuild_header = PentaNet_rebuild_header;
	dev->set_multicast_list = PentaNet_set_rx_mode;
	dev->irq = pdev->irq;
	dev->base_addr = (unsigned long)mmio0_vaddr;
	dev->flags |= IFF_NOARP;     /* no ARP protocol */
	dev->flags |= IFF_MULTICAST; /* support multicast */

	/* tp set in PentaVal_init_board */
	//dbgPrintk("[+]Card Index=%d,%d\n",tp->index,g_index);

	/* tp set in PentaNet_init_board */
	tp = dev->priv;
	tp->pci_dev = pdev;
	tp->mmio0_addr = mmio0_addr;
	tp->mmio0_vaddr = mmio0_vaddr;
	tp->mmio2_addr = mmio2_addr;
	tp->mmio2_vaddr = mmio2_vaddr;
	tp->irq_line = dev->irq;

	spin_lock_init(&tp->lock);

	pdev->driver_data = dev;
	
	/* Initialize variables */
	g_index = cards_found;
	tp->index = g_index;
	tp->short_bh_count = 0;
	tp->bh_count = 0;
	tp->interrupt_count = 0;
	tp->timer_count = 0;
	tp->old_data = 0;
	tp->interrupt_status = 0;

	cards_found++;

	/* this driver infomation */
	printk( KERN_INFO "\nPentamedia Satellite Data Broadcast Receiver PCI Pent@NET(#%d)\n"  "-> www.pentamedia.com/english/products/penta-net.htm\n",cards_found);
	printk( KERN_INFO "%s: at 0x%x 0x%x IRQ %d\n",dev->name, (unsigned int)tp->mmio0_addr,(unsigned int)tp->mmio2_addr, (unsigned int)dev->irq);
	printk( KERN_INFO "%s: vendor 0x%x device 0x%x\n", dev->name, ent->vendor,ent->device);
	printk( KERN_INFO "%s: subsystem 0x%x subsystem vendor 0x%x\n", dev->name, ent->subvendor,ent->subdevice);
	printk( KERN_INFO "%s: ver %s release date %s\n", dev->name, PENTANET_VERSIONSTR, PENTANET_RELEASEDATE );
	
	return 0;
}
	

/* 
 * Func : PentaNet_remove_one  
 * Context :
 */
static void __devexit PentaNet_remove_one( struct pci_dev *pdev )
{
	struct net_device *dev = pdev->driver_data;
	struct pentanet_private *np = (struct pentanet_private*)(dev->priv);
	
	/* unregister network driver */
	unregister_netdev(dev);

	/* iounmap : release pci virtual address */
	if( pdev->device == PENTANET_DEVICE_ID ){
		iounmap(np->mmio0_vaddr);
		iounmap(np->mmio2_vaddr);
	}else{
		printk(KERN_ERR" not match with device\n");
	}
	
	/* release pci physical address */
	release_mem_region( pci_resource_start(pdev,PCIBAR0), pci_resource_len(pdev,PCIBAR0));
	release_mem_region( pci_resource_start(pdev,PCIBAR2), pci_resource_len(pdev,PCIBAR2));
	
	kfree(dev);
	
	pdev->driver_data = NULL;
}


#ifdef CONFIG_PM
/* 
 * Func : PentaNet_suspend  
 * Context :
 */
#if LINUX_VERSION_CODE > KERNEL_VERSION(2,4,5)
static int PentaNet_suspend( struct pci_dev *pdev , u32 state )
#else
static void PentaNet_suspend( struct pci_dev *pdev )
#endif
{
#if LINUX_VERSION_CODE > KERNEL_VERSION(2,4,5)
	struct net_device *dev = pci_get_drvdata(pdev);
#else
	struct net_device *dev = pdev->driver_data;
#endif
	struct pentanet_private *tp = (struct pentanet_private *)dev->priv;
	unsigned long flags;

#if LINUX_VERSION_CODE > KERNEL_VERSION(2,4,5)
	if( !netif_running(dev))
		return 0;
#endif
	netif_device_detach(dev);

	spin_lock_irqsave(&tp->lock,flags);

	/* disable interrupt, stop tx & rx. : not implemented */
	
	spin_unlock_irqrestore(&tp->lock,flags);

#if LINUX_VERSION_CODE > KERNEL_VERSION(2,4,5)
		return 0;
#endif
}

/* 
 * Func : PentaNet_resume  
 * Context :
 */
#if LINUX_VERSION_CODE > KERNEL_VERSION(2,4,5)
static int PentaNet_resume( struct pci_dev *pdev )
#else
static void PentaNet_resume( struct pci_dev *pdev )
#endif
{
#if LINUX_VERSION_CODE > KERNEL_VERSION(2,4,5)
	struct net_device *dev = pci_get_drvdata(pdev);
#else
	struct net_device *dev = pdev->driver_data;
#endif

#if LINUX_VERSION_CODE > KERNEL_VERSION(2,4,5)
		if( !netif_running(dev))
			return 0;
#endif
	
	netif_device_attach(dev);

#if LINUX_VERSION_CODE > KERNEL_VERSION(2,4,5)
		return 0;
#endif
}
#endif /* CONFIG_PM */ 


/* 
 * Func : PentaNet_init_module  
 */
static int __init PentaNet_init_module( void )
{
	return pci_module_init(&pentanet_pci_driver);
}
	

/* 
 * Func : PentaNet_cleanup_module  
 */
static void __exit PentaNet_cleanup_module( void )
{
	return pci_unregister_driver(&pentanet_pci_driver);
}

module_init( PentaNet_init_module );
module_exit( PentaNet_cleanup_module );
