/* ----------------------------------------------- */
/* company : pentamedia
 * author  : elcomski 
 * file    : hwpacket.h
 * date    : 2001-06-15
 * modify  : 2001-12-13 by elcomski
 */
/* ----------------------------------------------- */
#ifndef _HWPACKET_H_
#define _HWPACKET_H_


/*-------------------------------*/
/* Constant definitions */
/*-------------------------------*/
#define MAX_MULTI_CAST 16
#define MAX_DATA_PID   8

#define INTERNET_MODE 1
#define NETINFO_MODE  2


/*-------------------------------*/
/* Enum definitions */
/*-------------------------------*/
typedef enum{
	MFree,
	MWrite,
	MReady,
	MTransfer
}MSTATUS;


/*-------------------------------*/
/* Structure definitions */
/*-------------------------------*/
typedef struct _QBUF_CONTROL{
	MSTATUS Muse;			/* MFree */
	unsigned int Msize;		/* 4K : max size of buffer */
	unsigned int Moffset;  		/* 0 : current offset of buffer */
	unsigned char *Mbuffer;   	/* 4K : buffer pointer */
	unsigned char *Mheader;       	/* 14 : header buffer pointer */
} QBUF_CONTROL, *PQBUF_CONTROL;


/*-------------------------------*/
/* External Functions */
/*-------------------------------*/
extern void Time_Slice_Sleep( unsigned int Delay );
extern void HWP_InitPacket( void );
extern int HWP_SetMultiCast( unsigned char *pBuffer, unsigned int Size );
extern unsigned long HWP_GetPacketData( unsigned long rQ, PQBUF_CONTROL pPacket, unsigned long PacketMode );


#endif // _HWPACKET_H_
