/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996-2000 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    support@pftp.de
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifdef USE_POSIX_THREAD
#define _REENTRANT
#include <pthread.h>
#endif
#include <grp.h>
#include "main.h"

#ifndef setenv
int my_setenv(const char *, const char *, int);
#else
#define my_setenv setenv
#endif

extern void send_oob_error(int, char *);

#if !defined __RH_CYGLINT__
int init_user_id(int strnum)
{
   /*
    * Check if server is running with su privileges
    * and if so set new gid and uid.
    */
   if (!getuid()) {
      if (setgroups((size_t)1, (gid_t *)&((*(statstr+strnum))->pw_gid))) {
         if (slfp) fprintf(slfp, "** initgroups: %s\n", _PFTP_ERROR_ARRAY_);
         return 0;
      }
      if (setgid((gid_t)(*(statstr+strnum))->pw_gid)) {
         if (slfp) fprintf(slfp, "** setregid: %s\n", _PFTP_ERROR_ARRAY_);
         return 0;
      }
      if (setuid((uid_t)(*(statstr+strnum))->pw_uid)) {
         if (slfp) fprintf(slfp, "** setreuid: %s\n", _PFTP_ERROR_ARRAY_);
         return 0;
      }
   }
   return 1;
}
#endif

int init_user_env(int strnum)
{
   /*
    * Set some environment variables.
    */
   if (my_setenv(__HOMEDIR_ENV__, (*(statstr+strnum))->pw_dir, 1) < 0) return 0;
   if (my_setenv("PWD", (*(statstr+strnum))->pw_dir, 1) < 0) return 0;
   if (my_setenv("USER", (*(statstr+strnum))->pw_name, 1) < 0) return 0;
   if (my_setenv("LOGNAME", (*(statstr+strnum))->pw_name, 1) < 0) return 0;
   if (my_setenv("TMP", "/tmp", 1) < 0) return 0;
   if (my_setenv("TMPDIR", "/tmp", 1) < 0) return 0;
   return 1;
}

#ifndef setenv
int my_setenv(const char *var, const char *val, int over)
{
   extern char **environ;
   char **envi=environ;
   char str[SONAME];
   int len=0;
   
   sprintf(str, "%s=", var);
   len=strlen(str);
   for (envi=environ; *envi; envi++) {
      if (!strncmp(*envi, str, len)) {
         if (!over) return 0;
         strcat(str, val);
         if (!(*envi = (char *)calloc(strlen(str)+1, sizeof(char)))) return -1;
         strcpy(*envi, str);
         break;
      }
   }
   if (!*envi) {
      strcat(str, val);
      if (!(*envi = (char *)calloc(strlen(str)+1, sizeof(char)))) return -1;
      strcpy(*envi, str);
      *++envi=NULL;
   }
   return 0;
}
#endif
