# --------------------------------------------------------------------------- #
# $Id: plfiles.py,v 1.5 2004/01/07 13:19:11 weismann Exp $
# --------------------------------------------------------------------------- #

import string, os, re
import pllog
from pllshared import *

"""
	DESCRIPTION:

	This module contain methods and variables to be used when opening
	files for reading.

	METHODS:

	init:
		constructor setting initial path and home

	add_to_path:
		add a directory to the search path

	get_path:
		return search path as string

	get_path_list:
		return path as list of directories

	get_home:
		return home directory

	set_log:
		pass log object

	find_file:
		search the search path for a file. Return empty string if no
		file exist. Return the absolute filename otherwise.

	open_file:
		open the file, reporting any eventual exception to the log

	VARIABLES:

	path:
		The search path

	home:
		The home directory
"""

path = ""
home = ""

def set_path( p ):
	global path
	path = ""
	## NB! we don't allow '.' or '..' in the PATH - they are
	## expected to be expanded already  
	pattern = "^((/?[a-zA-Z0-9_-]|\.)+/?:?)+$" ## FIXME - this pattern is BAD
	if not re.search(pattern, p):
		raise RuntimeError, "Invalid PLL PATH : '%s'"%p
	add_to_path(p)

def set_home( h ):
	global home
	home = h

def add_to_path( p ):
	global path
	if path:
		path = path+':'+p
	else:
		path = p

def get_path():
	return path

def get_path_list():
	return path.split(':')

def get_home():
	return home

def find_file(file, include_cwd = 1):
	"""Search the pointless PATH in order to find the file. Return the full 
	path to the first location of file and in case it doesn't exists, the 
	empty string"""
	if include_cwd and os.path.isfile(file):
		pllog.debug("File found %s"%file)
		return file
	else: 
		fullpath = ""
		## now, we are ready to determine the full path to the file
		directories = string.split(path,':')
		for d in directories:
			## substitute '//' with '/'
			f = os.path.normpath(d+"/"+file)
			if os.path.isfile(f):
				fullpath = f
				pllog.debug("File found: %s"%fullpath)
				break
		if not fullpath:
			pllog.warn("File %s wasn't found (path: %s)"%(file,path))
		return fullpath

def open_file(filename):
	try:
		file = open(filename)
		return file
	except IOError, (errno, strerror):
		pllog.warn(gt("I/O error(%s): %s while trying to open %s") % \
					(errno, strerror, filename))
	except:
		pllog.warn(gt("Unexpected error opening file %s %s:\n") % \
					(filename, sys.exc_info()[0]))
	return None

# --------------------------------------------------------------------------- #
