# --------------------------------------------------------------------------- #
# $Id: a2pscode.py,v 1.4 2004/01/10 14:12:09 weismann Exp $
# --------------------------------------------------------------------------- #

from pllshared import *
import os
import re
import pllmodules 
import eps

pll = None

_minscale = 0.01
_maxscale = 10.0

def register():
	code = pll.add_command("code", _code, transform=1, vars=1)
	code.set_attrs({'scale':1.0})

def write_code_file(filename, content):
	f = open(filename, 'w')
	f.write(content)
	f.close()

def run_a2ps(filename, outfile):
	a2ps = pllmodules.find_program("a2ps")
	errormsg = ""
	if a2ps:
		failed = os.system("%s -T4 --column=1 --portrait --no-header --borders=no \
		--user-option=lp %s -o %s" % (a2ps, filename, outfile))
	else:
		errormsg = "Unable to find the a2ps program\n";
		failed = 1
	return not failed, errormsg

def _code(args, text, vars):

	scale = vars['scale']
	if not scale or scale < _minscale or scale > _maxscale:
		errmsg = "scale must be in the interval (%f,%f)" % (_minscale, _maxscale)
		raise PllCommandError(errmsg)

	filename = pll.get_tempfilename()
	psfile = filename+".ps"
	epsfile = filename+".eps"
	srcfile = filename+".src"
	pngfile = filename+".png"

	oldmd5 = pllmodules.md5_file(srcfile)
	write_code_file(srcfile, text)
	newmd5 = pllmodules.md5_file(srcfile)

	if oldmd5 != newmd5 or not os.path.isfile(pngfile):
		## content in srcfile has changed
		ok, error = run_a2ps(srcfile, psfile)
		if not ok:
			os.unlink(srcfile) # to purge cache
			errmsg = error
			errmsg += "Error running a2ps on '%s'.\nNo output produced\n" % srcfile
			raise PllCommandError(errmsg)

	ok, error = eps.run_ps2epsi(psfile, epsfile)
	if not ok:
		os.unlink(srcfile) # to purge cache
		errmsg = "Error running ps2epsi on '%s'.\n" % psfile
		errmsg += error
		raise PllCommandError(errmsg)

	ok, error = eps.eps2png(epsfile, pngfile, scale*pll.scale)
	if not ok:
		os.unlink(srcfile) # to purge cache
		errmsg = "Error converting ps '%s'.\n" % psfile
		errmsg += error
		raise PllCommandError(errmsg)

	return '=gaimage("%s")' % pngfile

# --------------------------------------------------------------------------- #

