/*
ClientForwardMail.cc

 #    !!!!! That is based in one server developed in our University. Non standard.
 #    PROTOCOL FOR CHANGE MESSAGE FORWARDING
 #
 #     Show, Add or EraseAll message forwarding. 
 #          
 #          200 MailUtil Server (c) H.Rulot Universitat de Valencia SPAIN.
 #          forward guest
 #          200 Password required.
 #          pass jkjkkk
 #          200 OK Forward utilities opened for guest.
 #          show
 #          300 guest@other.machine
 #          300 guest@my.home
 #          200 OK
 #          add guest@her.home
 #          200 Added guest@her.home forward address.
 #          eraseall
 #          200 All guest forwarding is now disabled.
 #          quit
 #          200 bye

*/

#include "ClientForwardMail.h"
extern Language *L;

ClientForwardMail::ClientForwardMail (const char *aserver, int aport, const char *auser, const char *apw)
  {
  xstrncpy (server, CMAXIPNAME, aserver);
  xstrncpy (user, CMAXBUFFER, auser);
  xstrncpy (pw, CMAXBUFFER, apw);
  forwardport = aport;
  }  

ClientForwardMail::~ClientForwardMail ()
  {
  }

bool ClientForwardMail::doSetForwards (StringList *SLForwards, TBuffer ErrorString)
  {
  char buffer[1024], basura[1024];
  int sock, cod;
  XSocket *socket;

  initStr (ErrorString);
  socket = new XSocket ();
  socket->ignore_pipe();
  sock = socket->do_client_inet (server, NULL, forwardport, 240);
  if (sock == -1) {xstrncpy (ErrorString, CMAXBUFFER, L->get (ERR_SERVERISDOWN)); return false;}
  socket->SetSock (sock);
  
  /*LEO LA LINEA DE BIENVENIDA*/
  /*    -1 by the possible buffer overflow resulting from the linefeed added below. */
  if (!socket->Gets (buffer, sizeof(buffer) -1)) {xstrncpy (ErrorString, CMAXBUFFER, "Socket error"); return false;}
  sscanf (buffer, "%d %s", &cod, basura);
  if (cod != 200) {xstrncpy (ErrorString, CMAXBUFFER, buffer); return false;}

  /*ENVIO USER (== forward in that protocol)*/
  sprintf (buffer, "forward %s\n", user);
  if (socket->Puts (buffer) == -1) {xstrncpy (ErrorString, CMAXBUFFER, "Socket error"); return false;}
  /*LEO LO RECIBIDO*/
  if (!socket->Gets (buffer, sizeof(buffer) -1)) {xstrncpy (ErrorString, CMAXBUFFER, "Socket error"); return false;}
  sscanf (buffer, "%d %s", &cod, basura);
  if (cod != 200) {xstrncpy (ErrorString, CMAXBUFFER, buffer); return false;}
  
  /*ENVIO PASS*/
  sprintf (buffer, "pass %s\n", pw);
  if (socket->Puts (buffer) == -1) {xstrncpy (ErrorString, CMAXBUFFER, "Socket error"); return false;}
  /*LEO LO RECIBIDO*/
  if (!socket->Gets (buffer, sizeof(buffer) -1)) {xstrncpy (ErrorString, CMAXBUFFER, "Socket error"); return false;}
  sscanf (buffer, "%d %s", &cod, basura);
  if (cod != 200) {xstrncpy (ErrorString, CMAXBUFFER, buffer); return false;}

  /*ADD THE FORWARDS*/
  for (int i = 0; i < SLForwards->Count (); ++i)
    {
    /*ENVIO PASS*/
    sprintf (buffer, "add %s\n", SLForwards->getString(i).cstr());
    if (socket->Puts (buffer) == -1) {xstrncpy (ErrorString, CMAXBUFFER, "Socket error"); return false;}
    /*LEO LO RECIBIDO*/
    if (!socket->Gets (buffer, sizeof(buffer) -1)) {xstrncpy (ErrorString, CMAXBUFFER, "Socket error"); return false;}
    sscanf (buffer, "%d %s", &cod, basura);
    if (cod != 200) {xstrncpy (ErrorString, CMAXBUFFER, buffer); return false;}
    }

  /*ENVIO QUIT*/
  sprintf (buffer, "quit\n");
  if (socket->Puts (buffer) == -1) {/*NOTHING*/}

  /*LEO LA LINEA DE QUIT*/
  if (!socket->Gets (buffer, sizeof(buffer) -1)) {/*NOTHING*/}

  delete socket;
    
  return true;
  }

bool ClientForwardMail::doClearForwards (TBuffer ErrorString)
  {
  char buffer[1024], basura[1024];
  int sock, cod;
  XSocket *socket;

  initStr (ErrorString);
  socket = new XSocket ();
  socket->ignore_pipe();
  sock = socket->do_client_inet (server, NULL, forwardport, 240);
  if (sock == -1) {xstrncpy (ErrorString, CMAXBUFFER, L->get (ERR_SERVERISDOWN)); return false;}
  socket->SetSock (sock);
  
  /*LEO LA LINEA DE BIENVENIDA*/
  /*    -1 by the possible buffer overflow resulting from the linefeed added below. */
  if (!socket->Gets (buffer, sizeof(buffer) -1)) {xstrncpy (ErrorString, CMAXBUFFER, "Socket error"); return false;}
  sscanf (buffer, "%d %s", &cod, basura);
  if (cod != 200) {xstrncpy (ErrorString, CMAXBUFFER, buffer); return false;}

  /*ENVIO USER (== forward in that protocol)*/
  sprintf (buffer, "forward %s\n", user);
  if (socket->Puts (buffer) == -1) {xstrncpy (ErrorString, CMAXBUFFER, "Socket error"); return false;}
  /*LEO LO RECIBIDO*/
  if (!socket->Gets (buffer, sizeof(buffer) -1)) {xstrncpy (ErrorString, CMAXBUFFER, "Socket error"); return false;}
  sscanf (buffer, "%d %s", &cod, basura);
  if (cod != 200) {xstrncpy (ErrorString, CMAXBUFFER, buffer); return false;}
  
  /*ENVIO PASS*/
  sprintf (buffer, "pass %s\n", pw);
  if (socket->Puts (buffer) == -1) {xstrncpy (ErrorString, CMAXBUFFER, "Socket error"); return false;}
  /*LEO LO RECIBIDO*/
  if (!socket->Gets (buffer, sizeof(buffer) -1)) {xstrncpy (ErrorString, CMAXBUFFER, "Socket error"); return false;}
  sscanf (buffer, "%d %s", &cod, basura);
  if (cod != 200) {xstrncpy (ErrorString, CMAXBUFFER, buffer); return false;}

  /*ENVIO ERASEALL*/
  sprintf (buffer, "eraseall\n");
  if (socket->Puts (buffer) == -1) {xstrncpy (ErrorString, CMAXBUFFER, "Socket error"); return false;}
  /*LEO LO RECIBIDO*/
  if (!socket->Gets (buffer, sizeof(buffer) -1)) {xstrncpy (ErrorString, CMAXBUFFER, "Socket error"); return false;}
  sscanf (buffer, "%d %s", &cod, basura);
  if (cod != 200) {xstrncpy (ErrorString, CMAXBUFFER, buffer); return false;}

  /*ENVIO QUIT*/
  sprintf (buffer, "quit\n");
  if (socket->Puts (buffer) == -1) {/*NOTHING*/}

  /*LEO LA LINEA DE QUIT*/
  if (!socket->Gets (buffer, sizeof(buffer) -1)) {/*NOTHING*/}

  delete socket;
    
  return true;
  }

bool ClientForwardMail::doGetForwards (StringList *SLForwards, TBuffer ErrorString)
  {
  char buffer[1024], basura[1024];
  int sock, cod;
  XSocket *socket;

  SLForwards->Clear();
  initStr (ErrorString);
  socket = new XSocket ();
  socket->ignore_pipe();
  sock = socket->do_client_inet (server, NULL, forwardport, 240);
  if (sock == -1) {xstrncpy (ErrorString, CMAXBUFFER, L->get (ERR_SERVERISDOWN)); return false;}
  socket->SetSock (sock);
  
  /*LEO LA LINEA DE BIENVENIDA*/
  /*    -1 by the possible buffer overflow resulting from the linefeed added below. */
  if (!socket->Gets (buffer, sizeof(buffer) -1)) {xstrncpy (ErrorString, CMAXBUFFER, "Socket error"); return false;}
  sscanf (buffer, "%d %s", &cod, basura);
  if (cod != 200) {xstrncpy (ErrorString, CMAXBUFFER, buffer); return false;}

  /*ENVIO USER (== forward in that protocol)*/
  sprintf (buffer, "forward %s\n", user);
  if (socket->Puts (buffer) == -1) {xstrncpy (ErrorString, CMAXBUFFER, "Socket error"); return false;}
  /*LEO LO RECIBIDO*/
  if (!socket->Gets (buffer, sizeof(buffer) -1)) {xstrncpy (ErrorString, CMAXBUFFER, "Socket error"); return false;}
  sscanf (buffer, "%d %s", &cod, basura);
  if (cod != 200) {xstrncpy (ErrorString, CMAXBUFFER, buffer); return false;}
  
  /*ENVIO PASS*/
  sprintf (buffer, "pass %s\n", pw);
  if (socket->Puts (buffer) == -1) {xstrncpy (ErrorString, CMAXBUFFER, "Socket error"); return false;}
  /*LEO LO RECIBIDO*/
  if (!socket->Gets (buffer, sizeof(buffer) -1)) {xstrncpy (ErrorString, CMAXBUFFER, "Socket error"); return false;}
  sscanf (buffer, "%d %s", &cod, basura);
  if (cod != 200) {xstrncpy (ErrorString, CMAXBUFFER, buffer); return false;}

  /*ENVIO SHOW*/
  sprintf (buffer, "show\n");
  if (socket->Puts (buffer) == -1) {xstrncpy (ErrorString, CMAXBUFFER, "Socket error"); return false;}
  
  /*LEO LO RECIBIDO*/
  cod = -1;
  while (cod != 200)
    {
    if (!socket->Gets (buffer, sizeof(buffer) -1)) {xstrncpy (ErrorString, CMAXBUFFER, "Socket error"); return false;}
    sscanf (buffer, "%d %s", &cod, basura);
    if      (cod == 200) {/*That is the last line. Without info.*/}
    else if (cod == 300) {SLForwards->Add(basura);}
    else {xstrncpy (ErrorString, CMAXBUFFER, buffer); return false;}
    }

  /*ENVIO QUIT*/
  sprintf (buffer, "quit\n");
  if (socket->Puts (buffer) == -1) {/*NOTHING*/}

  /*LEO LA LINEA DE QUIT*/
  if (!socket->Gets (buffer, sizeof(buffer) -1)) {/*NOTHING*/}

  delete socket;
    
  return true;
  }





