# session.rb:
# $Id: session.rb,v 1.8 2005/03/07 07:51:32 komatsu Exp $
#
# Copyright (C) 2005 Hiroyuki Komatsu <komatsu@taiyaki.org>
#     All rights reserved.
#     This is free software with ABSOLUTELY NO WARRANTY.
#
# You can redistribute it and/or modify it under the terms of 
# the GNU General Public License version 2.

class PrimeSession
  @@engine_cache = {}

  def initialize (name, engine_classes)
    @name           = name
    @language       = ""
    @engine_classes = engine_classes
    @composer       = initialize_composer()
    @engines        = initialize_engines(engine_classes)
    @conversions    = PrimeConversionList.new()
    @context        = nil
  end

  def initialize_engines (engine_classes)
    engines = engine_classes.map { | engine_class |
      if @@engine_cache.has_key?( engine_class ) then
        @@engine_cache[ engine_class ]
      else
        @@engine_cache[ engine_class ] = eval( engine_class.to_s ).new()
      end        
    }

    def engines.command (method, *args)
      self.map {|engine|
        engine.send(method, *args)
      }
    end

    return engines
  end

  def initialize_composer ()
    composer = SuikyoComposer.new()
    return composer
  end

  def session_get_env (variable)
    case variable
    when "language" then
      return @language
    else
      return nil
    end
  end

  def set_conversions (conversions)
    @conversions = conversions
  end

  def set_selection (index_no)
    @conversions.set_conversion_index(index_no)
    return @conversions[index_no]
  end
  def get_selection ()
    return @conversions.get_conversion()
  end

  def set_context (context)
    @context = context
  end
  def get_context ()
    return @context
  end

  ##
  ## Context methods
  ##
  def context_reset ()
    set_context("")
  end

  def context_set_previous_segment (segment)
    context_set_previous_word( segment.get_base() )
  end

  def context_set_previous_word (word)
    set_context(word)
  end
end
