/***************************************************************************
                          job_querydatabase.cpp  -  description
                             -------------------
    begin                : Wed May 23 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "job_querydatabase.h"

#include "job_disconnectfromdatabase.h"

#include "database.h"
#include "jobmanager.h"
#include "datadispatcher.h"
#include "gui.h"

// *** constructor for simple query ***
Job_QueryDatabase::Job_QueryDatabase(int type, int id)
  : querytype(type), queryID(id),
    byFilename(0), byArtist(0), byTitle(0), byAlbum(0), byComment(0) {}

// *** constructor for simple query ***
Job_QueryDatabase::Job_QueryDatabase(int type, QString data, QString data2 )
  : querytype(type), querydata(data), querydata2(data2),
    byFilename(0), byArtist(0), byTitle(0), byAlbum(0), byComment(0) {}

// *** constructor for more complex query ***
Job_QueryDatabase::Job_QueryDatabase(int type, QString data, bool _byFilename, bool _byArtist, bool _byTitle, bool _byAlbum, bool _byComment)
  : querytype(type), querydata(data),
    byFilename(_byFilename), byArtist(_byArtist), byTitle(_byTitle), byAlbum(_byAlbum), byComment(_byComment) {}


// ##############################################
// # do job
// ##############################################
void Job_QueryDatabase::run()
{
  int error;

  QList<TRACK> *list = 0;

  database->lock();
  switch(querytype) {
  case QUERY_BY_ARTIST:
    list = database->queryTracksByArtist(queryID);
    break;
  case QUERY_BY_ARTIST_ALBUM:
    list = database->queryTracksByArtistAlbum(querydata, querydata2);
    break;
  case QUERY_BY_ALBUM:
    list = database->queryTracksByAlbum(querydata, querydata2);
    break;
  case QUERY_BY_MEDIUM:
    list = database->queryTracksByMedium(queryID);
    break;
  case QUERY_BY_PLAYLIST:
    list = database->queryTracksByPlaylist(queryID);
    break;
  case QUERY_BY_PHRASE:
    list = database->queryTracksByPhrase(querydata, byFilename, byArtist, byTitle, byAlbum, byComment);
    break;
  }
  error = database->getError();
  database->unlock();
		
  if(!error) {
    app->lock();

    gui->getListing()->resetSorting();
    datadispatcher->eventNewTrackListing(list);

    app->unlock();
  }

  if(error == 1) {
    jobman->lock();
    jobman->addJob(new Job_DisconnectFromDatabase());
    jobman->unlock();
    }
  // error >1 are sql statement error, handled by a pop-up message.
  
  jobman->lock();
  jobman->jobDone(this);
  jobman->unlock();
  exit();
}

Job_QueryDatabase::~Job_QueryDatabase() {}
