package PSP::Output;

# Copyright (c) 2000, FundsXpress Financial Network, Inc.
# This library is free software released under the GNU Lesser General
# Public License, Version 2.1.  Please read the important licensing and
# disclaimer information included below.

# $Id: Output.pm,v 1.1 2000/11/30 09:19:42 muaddib Exp $

use strict;

=head1 NAME

 PSP::Output - an object which buffers or otherwise handles output.

=head1 SYNOPSIS

=head1 DESCRIPTION

Does output.  More later.

=cut

use overload ('.=' => \&put,
	      '=' => \&set,
	      '""' => \&get,
	      'cmp' => \&compare,
	      fallback => undef
	     );

=head1 METHODS

=head2 new

=head2 put

  instance
  () put (string)


DESCRIPTION:

=head2 get

  instance
  (string) get ()

DESCRIPTION:

=head2 set

  instance
  () set (string)

DESCRIPTION:

=head2 compare

  instance
  (integer) compare (string)

DESCRIPTION:

=cut

=head2 clear

  instance
  () clear ()

DESCRIPTION:

=cut

sub new {
  my ($proto,$string) = @_;
  $string ||= "";
  return bless \$string, ref($proto)||$proto;
}
sub put     { ${$_[0]} .= $_[1];         }
sub get     { return ${$_[0]};           }
sub compare { return ${$_[0]} cmp $_[1]; }
sub clear   { ${$_[0]} = "";             }

1;
__END__

=head1 BUGS

No known bugs, but this does not mean no bugs exist.

=head1 SEE ALSO

L<PSP::Page>

=head1 COPYRIGHT

 PSP - Perl Server Pages
 Copyright (c) 2000, FundsXpress Financial Network, Inc.

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later version.

 BECAUSE THIS LIBRARY IS LICENSED FREE OF CHARGE, THIS LIBRARY IS
 BEING PROVIDED "AS IS WITH ALL FAULTS," WITHOUT ANY WARRANTIES
 OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING, WITHOUT
 LIMITATION, ANY IMPLIED WARRANTIES OF TITLE, NONINFRINGEMENT,
 MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, AND THE
 ENTIRE RISK AS TO SATISFACTORY QUALITY, PERFORMANCE, ACCURACY,
 AND EFFORT IS WITH THE YOU.  See the GNU Lesser General Public
 License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA

=cut
