# -*- perl -*-
# Copyright (c) 2000, FundsXpress Financial Network, Inc.
# This library is free software released "AS IS WITH ALL FAULTS"
# and WITHOUT ANY WARRANTIES under the terms of the GNU Lesser
# General Public License, Version 2.1, a copy of which can be
# found in the "COPYING" file of this distribution.

# $Id: conf.t,v 1.3 2001/03/13 08:40:36 muaddie Exp $

use strict;
use Test;
use Data::Dumper;

BEGIN { plan tests => 12; }

require PSP::Conf;

BEGIN {
  ok ! defined $PSP::Conf::psp_loader; 
  ok ! defined $PSP::Conf::psp_stuck_seconds; 
}

use PSP::Conf;

BEGIN { 
  ok $PSP::Conf::psp_loader; 
  # !ok !$psp_loader;
}

use PSP::Conf qw(:all);

BEGIN {
  ok defined $psp_stuck_seconds;
  ok $psp_driver_log;
  ok defined $psp_do_auto_die;
  ok ! $psp_auto_die_fname;
  ok $psp_cfg_fname;
  ok $psp_loader;
  
  $psp_cfg_fname = "sample.conf";
  ok open CFG, ">>$psp_cfg_fname";
  ok print CFG <<'CFG';
# this is an example psp.conf.
$psp_stuck_seconds = 6969;
CFG
  ok close CFG;
}

use PSP::Conf qw(:all);

BEGIN {
  ok $psp_stuck_seconds eq 6969;

  undef $psp_loader;
  ok !$psp_loader;
}

use PSP::Conf qw(:all);

BEGIN {
  ok $psp_loader;
  #print Dumper($psp_loader);
  ok unlink $psp_cfg_fname;
}
