# -*- perl -*-
# Copyright (c) 2000, FundsXpress Financial Network, Inc.
# This library is free software released "AS IS WITH ALL FAULTS"
# and WITHOUT ANY WARRANTIES under the terms of the GNU Lesser
# General Public License, Version 2.1, a copy of which can be
# found in the "COPYING" file of this distribution.

# $Id: unload.t,v 1.3 2001/03/13 08:40:41 muaddie Exp $

use strict;
use Test;
use Data::Dumper;
use PSP::Loader;

my $fake_cgi = {};
bless $fake_cgi, 'CGI';

my ($loader,$pile,$page_name,$child);

my $n_iterations = 1;
my $n_tests = 17;
plan tests => $n_iterations * $n_tests;
for (my $n=0; $n<$n_iterations; $n++) {

ok $loader = PSP::Loader->new("FooPile","","piles");

ok $child = $loader->mount("hi");
ok $child->mount("subhi","aloha");
ok $child->mount("subhi2","ahoj");
ok $loader->auto_populate();

($pile,$page_name) = $loader->map_page($fake_cgi,"/erf");
ok ref($pile) eq "FooPile::erf";
ok $page_name eq "page__";
ok !$pile->free_internals();
ok $loader->unload()== 7;

($pile,$page_name) = $loader->map_page($fake_cgi,"/erf/howdy/doody");
ok ref($pile) eq "FooPile::erf";
ok $page_name eq "page__howdy__doody";
ok !$pile->free_internals();
ok $loader->unload() == 7;

($pile,$page_name) = $loader->map_page($fake_cgi,"/hi/ahoj/tookytooky");
ok ref($pile) eq "FooPile::subhi2";
ok $page_name eq "page__tookytooky";
ok !$pile->free_internals();
ok $loader->unload() == 7;

$loader->free();

} # iterations
