package PSP::Generic;

# Copyright (c) 2000, FundsXpress Financial Network, Inc.
# This library is free software released under the GNU Lesser General
# Public License, Version 2.1.  Please read the important licensing and
# disclaimer information included below.

# $Id: Generic.pm,v 1.1 2000/11/23 23:36:19 muaddib Exp $

use strict;

=head1 NAME

PSP::Generic - an empty instance of a PSP extension interface.

=head1 SYNOPSIS

 ...

=head1 DESCRIPTION

...

=cut

use Exporter;

@PSP::Generic::ISA = qw(Exporter);
@PSP::Generic::EXPORT_OK = qw();
$PSP::Generic::EXPORT_TAGS{all} = \@PSP::Generic::EXPORT_OK;

=head2 new

public
class
(PSP::Generic $this) new ()

DESCRIPTION:

This public class method creates a new Generic object.

=cut

sub new {
  my ($proto) = @_;

  my $this = {};
  bless $this, ref($proto)||$proto;

  return $this;  
}

1;
__END__

=head1 BUGS

No known bugs, but this does not mean no bugs exist.

=head1 SEE ALSO

L<PSP::Driver>

=head1 COPYRIGHT

 PSP - Perl Server Pages
 Copyright (c) 2000, FundsXpress Financial Network, Inc.

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later version.

 BECAUSE THIS LIBRARY IS LICENSED FREE OF CHARGE, THIS LIBRARY IS
 BEING PROVIDED "AS IS WITH ALL FAULTS," WITHOUT ANY WARRANTIES
 OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING, WITHOUT
 LIMITATION, ANY IMPLIED WARRANTIES OF TITLE, NONINFRINGEMENT,
 MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, AND THE
 ENTIRE RISK AS TO SATISFACTORY QUALITY, PERFORMANCE, ACCURACY,
 AND EFFORT IS WITH THE YOU.  See the GNU Lesser General Public
 License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA

=cut
