/* *************************************************************************
  Module:        lexcalls.c 
  Author:        Matt Simpson
                 Arlington, TX
                 matthewsimpson@home.com
  Date:          August, 2000
  Description:
                 Lexmark calls, with permission from David Lane of Lexmark.
                 Origionally appearing in his program:
                 cartutil.c,v 1.3 1998/10/20 15:47:38 dlane

                 Slightly modified for calling from GUI.

  Changes:

****************************************************************************
                 COPYRIGHT (C) 1999, 2000 Matt Simpson
                 GNU General Public License 
                 See lexgui.c for full notice.
****************************************************************************
                 The portions of this file extracted from
                 cartutil.c,v 1.3, 1998/10/20 15:47:38 dlane 
                 COPYRIGHT (c) 1998 Lexmark International, Inc.
                 with permission as appearing here to place under 
                 the GNU General Public License.
**************************************************************************** */
#include <stdio.h>
#include <gtk/gtk.h>
#include "lexgui.h"

extern FILE *fp;
extern gchar *output;

/* The length values are used because strlen is confused by NULLs. */
char *sniff =
"\xa5\x00\x10\x80\xa4\x5b\xa4\x5b\x10\xef\xa4\x5b\x11\xee\x00\xff\x13\xec\x2e";
int sniffLength = 19;
/* -------------------------------------------------------------------------
        myputs()
   ------------------------------------------------------------------------- */
/*
* Put a string to the output file and check for errors.
* I can't use 'fputs' because my strings contain NULLs.
*/
int myputs(char *s, int count, FILE *fp, char *prog, msgbox_struct *msgbox)
{
  char message[400];

  while (count--){
    fputc(*s++, fp);
  }
  fflush(fp);
  if (ferror(fp)){
    sprintf(message, "%s:\n Flush Error during output to device or file.", 
            prog);
    put_msg(msgbox, message, RED, 0);
    return(EOF);
  }
  else {
    return(0);
  }
} 
/* -------------------------------------------------------------------------
        park_cartridges()
   ------------------------------------------------------------------------- */
void park_cartridges(msgbox_struct *msgbox)
{
  char *park = "\xa5\x00\x05\x40\xe0\x0a\x01\x00";
  int parkLength = 8;
  char *prog = (char *) output;

  myputs(sniff, sniffLength, fp, prog, msgbox);
  myputs(park, parkLength, fp, prog, msgbox);
}
/* -------------------------------------------------------------------------
         print_menu() 
   ------------------------------------------------------------------------- */
void print_menu(msgbox_struct *msgbox)
{
  char *pmenu = "\xa5\x00\x05\x40\xe0\x5c\x81\x00";
  int pmenuLength = 8;
  char *prog = (char *) output;

  myputs(sniff, sniffLength, fp, prog, msgbox);
  myputs(pmenu, pmenuLength, fp, prog, msgbox);
}
/* -------------------------------------------------------------------------
         clean_nozzles() 
   ------------------------------------------------------------------------- */
void clean_nozzles(msgbox_struct *msgbox)
{
  char *clean = "\xa5\x00\x05\x40\xe0\x5c\x81\x80";
  int cleanLength = 8;
  char *prog = (char *) output;

  myputs(sniff, sniffLength, fp, prog, msgbox);
  myputs(clean, cleanLength, fp, prog, msgbox);
}
/* -------------------------------------------------------------------------
        reset_ink_gauge()
   ------------------------------------------------------------------------- */
void reset_ink_gauge(int ink, msgbox_struct *msgbox)
{
  char *reset[] = {
  "\xa5\x00\x04\x40\xe0\x09\x01",
  "\xa5\x00\x04\x40\xe0\x09\x02",
  "\xa5\x00\x04\x40\xe0\x09\x05"
  };
  int resetLength[] = {7, 7, 7};
  char *prog = (char *) output;
  myputs(sniff, sniffLength, fp, prog, msgbox);
  myputs(reset[ink], resetLength[ink], fp, prog, msgbox);  
}
/* -------------------------------------------------------------------------
        print_alignment()
   ------------------------------------------------------------------------- */
void print_alignment(msgbox_struct *msgbox)
{
  char *palign = "\xa5\x00\x05\x40\xe0\x5c\x81\x03";
  int palignLength = 8;  
  char *prog = (char *) output;

  myputs(sniff, sniffLength, fp, prog, msgbox);
  myputs(palign, palignLength, fp, prog, msgbox);
}
/* -------------------------------------------------------------------------
        send_alignment()
   ------------------------------------------------------------------------- */
void send_alignment(int selection[4], msgbox_struct *msgbox)
{
  int i;
  char align[][20] = {
  "\xa5\x00\x07\x40\xe0\xe7\x01\x08\x32\xff",
  "\xa5\x00\x07\x40\xe0\xe7\x01\x08\x33\xff",
  "\xa5\x00\x07\x40\xe0\xe7\x01\x08\x34\xff",
  "\xa5\x00\x07\x40\xe0\xe7\x01\x08\x35\xff"
  };
  int alignLength[] = {10, 10, 10, 10};
  char *prog = (char *) output;

  for(i = 0; i < 4; i++)
  {
    myputs(sniff, sniffLength, fp, prog, msgbox);
    align[i][alignLength[i] - 1] = selection[i];
    myputs(align[i], alignLength[i], fp, prog, msgbox);
  }
}
/* -------------------------------------------------------------------------
        moveto_install()
   ------------------------------------------------------------------------- */
void moveto_install(msgbox_struct *msgbox)
{
  char *install = "\xa5\x00\x05\x40\xe0\x0a\x1d\x70";
  int installLength = 8;
  char *prog = (char *) output;

  myputs(sniff, sniffLength, fp, prog, msgbox);
  myputs(install, installLength, fp, prog, msgbox);
}
/* -------------------------------------------------------------------------
        send_types()
   ------------------------------------------------------------------------- */
void send_types(int ltype, int rtype, msgbox_struct *msgbox)
{
  int headCode[][4] = {
    {0x07, 0x37, 0x0d, 0x3d},
    {0x08, 0x38}
  };
  char head[] = "\xa5\x00\x05\x40\xe0\x80\xff\xff";
  int headLength = 8;
  char *prog = (char *) output;

  head[6] = headCode[0][ltype];
  head[7] = headCode[1][rtype];
  myputs(sniff, sniffLength, fp, prog, msgbox);
  myputs(head, headLength, fp, prog, msgbox);
}
