dnl This macro defines the PYTHON_EMBED_{CFLAGS,LDFLAGS,LIBS} substitutions
dnl that should be used when embedding the python interpreter into a program.
dnl AM_INIT_PYTHON_EMBED
AC_DEFUN(AM_INIT_PYTHON_EMBED,
[AC_REQUIRE([AM_PATH_PYTHON])
AC_REQUIRE([AM_INIT_PYEXEC_MOD])

AC_MSG_CHECKING(for flags used to embed python interpreter)
changequote(,)dnl
py_makefile="`$PYTHON -c '
import sys
print \"%s/lib/python%s/config/Makefile\"%(sys.exec_prefix, sys.version[:3])'`"
changequote([,])dnl
if test ! -f "$py_makefile"; then
   AC_MSG_ERROR([*** Couldn't find the python config makefile.  Maybe you are
*** missing the development portion of the python installation])
fi

changequote(,)dnl
py_lib="`$PYTHON -c '
import sys
ver = sys.version[:3]
pre = sys.exec_prefix
print \"-L%s/lib/python%s/config\" % (pre, ver),
if ver == \"1.4\":
	print \"-lPython -lObjects -lParser\"
else:
	print \"-lpython\" + ver
'`"
changequote([,])dnl

py_ldflags=`sed -n -e 's/^LDFLAGS=\(.*\)/\1/p' $py_makefile`
py_linkforshared=`sed -n -e 's/^LINKFORSHARED=\(.*\)/\1/p' $py_makefile`

PYTHON_EMBED_LDFLAGS="$py_ldflags $py_linkforshared"

py_localmodlibs=`sed -n -e 's/^LOCALMODLIBS=\(.*\)/\1/p' $py_makefile`
py_basemodlibs=`sed -n -e 's/^BASEMODLIBS=\(.*\)/\1/p' $py_makefile`
py_other_libs=`sed -n -e 's/^LIBS=\(.*\)/\1/p' $py_makefile`

PYTHON_EMBED_LIBS="$py_lib $py_localmodlibs $py_basemodlibs $py_other_libs"

PYTHON_EMBED_CFLAGS="$PYTHON_INCLUDES"

AC_MSG_RESULT(done)

AC_SUBST(PYTHON_EMBED_CFLAGS)
AC_SUBST(PYTHON_EMBED_LDFLAGS)
AC_SUBST(PYTHON_EMBED_LIBS)
])

dnl creates a config.c file, which holds the builtin module initialisation
dnl table for python.  The first argument should be the output filename.
dnl The second argument gives the names of all the modules you want to build
dnl into the executable.
dnl AM_PYTHON_CREATE_CONFIG_C(CONFIG_C, MODULE ...)
AC_DEFUN(AM_PYTHON_CREATE_CONFIG_C,
[AC_REQUIRE([AM_INIT_PYTHON_EMBED])
AC_MSG_CHECKING(for config.c.in)
changequote(,)dnl
py_config_in="`$PYTHON -c '
import sys
print \"%s/lib/python%s/config/config.c.in\"%(sys.exec_prefix, sys.version[:3])'`"
changequote([,])dnl
if test ! -f "$py_config_in"; then
   AC_MSG_ERROR([*** Couldn't find the config.c.in file.  Maybe you are
*** missing the development portion of the python installation])
fi

py_cnf_decls=""
py_cnf_inits=""
py_nl='\
'
for mod in . $2; do
  if test "$mod" != .; then
    py_cnf_decls="${py_cnf_decls}extern void init$mod();$py_nl"
    py_cnf_inits="${py_cnf_inits}  {\"$mod\", init$mod},$py_nl"
  fi
done
sed -e "
  /MARKER 1/i$py_nl$py_cnf_decls
  /MARKER 2/i$py_nl$py_cnf_inits
" $py_config_in > $1
AC_MSG_RESULT(created $1)
])
