#include "allegro.h"
#include "booster.h"
#include "defs.h"

#define MAX_BOOSTER_SHADE 13

PixelList::PixelList( int ax, int ay, int l, PixelList * nx ) {
	x = ax;
	y = ay;
	next = nx;
	life = l;
}


int PixelList::Draw( BITMAP * work, int * shade, int offset ) {

	circlefill( work, x, y+offset, 1, shade[ life ] );
	life++;
	return life;

}


Booster::Booster() {

	shade = new int[ MAX_BOOSTER_SHADE ];
	blend_palette( shade, MAX_BOOSTER_SHADE*2/3, makecol(244,220,12), makecol(237,53,42) );
	blend_palette( shade+MAX_BOOSTER_SHADE*2/3, (MAX_BOOSTER_SHADE-MAX_BOOSTER_SHADE*2/3), makecol(237,53,42), makecol(83,6,0) );
	head = new PixelList(0,0,0,NULL);

}


void Booster::add( int x, int y) {

	PixelList * temp = new PixelList( x, y, 0, head->next );
	head->next = temp;

}


void Booster::Draw( BITMAP * work, int offset ) {

	PixelList * cur = head;
	while ( cur->next != NULL ) {
		if ( cur->next->Draw(work,shade,offset) >= MAX_BOOSTER_SHADE ) {
			PixelList * dump = cur->next;
			cur->next = cur->next->next;
			delete dump;
		} else cur = cur->next;
	}

}


Booster::~Booster() {
	delete shade;
	PixelList * cur = head;
	while ( cur != NULL ) {
		PixelList * dump = cur;
		cur = cur->next;
		delete dump;
	}

}
