/*
 *  contact-list.c
 *
 *  Created: 20011227
 *
 *  Copyright (c) 2001 by Tomasz Trojanowski
 *  All rights reserved
 *
 *  $Id: contact-list.c,v 1.46 2002/03/19 22:26:47 tomek Exp $
 *
 */

#ifdef __CONTACT_LIST_H
#include <config.h>
#endif

#ifndef _GNU_SOURCE
# define _GNU_SOURCE
#endif

#include <contact-list.h>

#include <intl.h>

/* Struktura zawierajaca nazwy i domylne szerokoci pl listy kontaktw. */
fields_list_item_type contact_list_items[] =
{
    { N_("ID"),            30 },
    { N_("Save as"),      140 },
    { N_("Last name"),     80 },
    { N_("First name"),    60 },
    { N_("Full name"),    160 },
    { N_("Organization"), 140 },
    { N_("Email"),        120 },
    { N_("Home phone"),   120 },
    { N_("Work phone"),   120 }
};

/* Funkcja zwracajca wskanik do acucha zawierajcego tekst zadanego pola struktury
   danych kontaktu. */
gchar *get_contact_field_value(contact_data *item, gint field_id)
{
    gchar *result;

    switch (field_id)
    {
        case IDCF_ID:
	    result = g_strdup_printf("%6d", item->id);
	    break;
        case IDCF_SAVE_AS:
	    result = g_strdup_printf("%s", item->save_as);
	    break;
        case IDCF_LAST_NAME:
	    result = g_strdup_printf("%s", item->last_name);
	    break;
        case IDCF_FIRST_NAME:
	    result = g_strdup_printf("%s", item->first_name);
	    break;
        case IDCF_FULL_NAME:
	    result = get_full_name(item);
	    break;
        case IDCF_FIRM:
	    result = g_strdup_printf("%s", item->firm_name);
	    break;
        case IDCF_EMAIL_1:
	    result = g_strdup_printf("%s", item->email[0].value);
	    break;
        case IDCF_PHONE_HOME:
	    result = get_full_phone(item, PHONE_TYPE_HOME);
	    break;
        case IDCF_PHONE_WORK:
	    result = get_full_phone(item, PHONE_TYPE_WORK);
	    break;
    }
    
    return result;
}
