/*
 *  phone-dialog.c       -
 *
 *  Created: 20020115
 *
 *  Copyright (c) 2001, 2002 by Tomasz Trojanowski
 *  All rights reserved
 *
 *  $Id: phone-dialog.c,v 1.16 2002/03/19 23:08:22 tomek Exp $
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <phone-dialog.h>

#include <intl.h>
#include <common.h>

/* Funkcja obsugujca wcinicie przycisku "OK" okienka dialogowego. */
static void ok_button_clicked(GtkButton *button, contact_data *data)
{
    gpointer entry;
    gboolean modified = FALSE;
    gchar *text;

    g_assert(data != NULL);
    
    /* Przepisywanie danych z elementw okna dialogowego do struktury danych kontaktu i
       sprawdzanie czy dane zostay zmodyfikowane, a jeeli tak - ustawianie flagi modified. */
    entry = gtk_object_get_data(GTK_OBJECT(data->sub_dialog), "country");
    text = gtk_entry_get_text(GTK_ENTRY(entry));
    if (strcmp(text, data->phone[data->phone_type[data->phone_pos]].country) != 0)
    {
        strcpy(data->phone[data->phone_type[data->phone_pos]].country, text);
	modified = TRUE;
    }
    
    entry = gtk_object_get_data(GTK_OBJECT(data->sub_dialog), "region");
    text = gtk_entry_get_text(GTK_ENTRY(entry));
    if (strcmp(text, data->phone[data->phone_type[data->phone_pos]].region) != 0)
    {
        strcpy(data->phone[data->phone_type[data->phone_pos]].region, text);
	modified = TRUE;
    }
    
    entry = gtk_object_get_data(GTK_OBJECT(data->sub_dialog), "number");
    text = gtk_entry_get_text(GTK_ENTRY(entry));
    if (strcmp(text, data->phone[data->phone_type[data->phone_pos]].number) != 0)
    {
        strcpy(data->phone[data->phone_type[data->phone_pos]].number, text);
	modified = TRUE;
    }
    
    /* Zamyka okienko dialogowe. */
    gtk_widget_destroy(data->sub_dialog);
    data->sub_dialog = NULL;

    if (modified)
    {
        /* Przepisanie penego adresu do pola tekstowego adresu. */
	create_full_phone(data, data->phone_pos);
    
        /* Przepisyanie flagi modified do flagi modified struktury danych
	   kontaktu. */
	data->phone[data->phone_type[data->phone_pos]].modified = TRUE;
	data->global_modified = TRUE;
    }
}

/* Funkcja tworzca okno dialogowe edycji telefonu.

   Struktura okna:
   
     GtkDialog (phone_dialog)
      +- GtkVBox (dialog_vbox)
      |   +- GtkFrame (frame)                                    "Szczegy"
      |       +- GtkFixed (fixed)
      |           +- GtkLabel                                    "Kod kraju"
      |           +- GtkEntry ("country")
      |           +- GtkLabel                             "Numer kierunkowy"
      |           +- GtkEntry ("region")
      |           +- GtkLabel                                "Numer tefeonu"
      |           +- GtkEntry ("number")
      +- GtkHBox (dialog_action_area)
          +- GtkHButtonBox (hbuttonbox)
	      +- GtkButton                                              "OK"
	      +- GtkButton                                          "Anuluj"

   Klucze zwizane z okienkiem edycji adresu:
   
     country - wskanik do pola edycji "Kod kraju"
     region  - wskanik do pola edycji "Numer kierunkowy"
     number  - wskanik do pola edycji "Numer telefonu"

*/
void create_phone_dialog(contact_data *data, guint phone_pos)
{
    GtkWidget *phone_dialog;
    GtkWidget *dialog_vbox;
    GtkWidget *frame;
    GtkWidget *fixed;
    GtkWidget *label;
    GtkWidget *entry;
    GtkWidget *dialog_action_area;
    GtkWidget *hbuttonbox;
    GtkWidget *button;

    /* Utworzenie okienka dialogowego. */
    phone_dialog = gtk_dialog_new();
    data->sub_dialog = phone_dialog;
    data->phone_pos = phone_pos;

    /* Przypisanie funkcji obsugi sygnaw do okienka dialogowego. */
    gtk_signal_connect(GTK_OBJECT(phone_dialog), "delete_event",
                       GTK_SIGNAL_FUNC(dialog_delete), phone_dialog);
    gtk_signal_connect(GTK_OBJECT(phone_dialog), "key_press_event",
                       GTK_SIGNAL_FUNC(dialog_key_press), phone_dialog);
    
    /* Ustalanie tytuu i rozmiarw okna. */
    gtk_window_set_title(GTK_WINDOW(phone_dialog), _("Phone"));
    gtk_widget_set_usize(GTK_WIDGET(phone_dialog), 256, 188);
    
        /* Obszar wntrza okna dialogowego. */
	dialog_vbox = GTK_DIALOG(phone_dialog)->vbox;
	gtk_widget_show(dialog_vbox);
	
	    /* Ramka "Szczegy". */
	    frame = gtk_frame_new(_("Details"));
	    gtk_widget_show(frame);
	    
	    gtk_box_pack_start(GTK_BOX(dialog_vbox), frame, TRUE, TRUE, 0);
	    
	    gtk_container_set_border_width(GTK_CONTAINER(frame), 6);
	    gtk_frame_set_label_align(GTK_FRAME(frame), 0.05, 0.5);
	    
	        /* Wnetrze ramki. */
		fixed = gtk_fixed_new();
		gtk_widget_show(fixed);
		
		gtk_container_add(GTK_CONTAINER(frame), fixed);
		
		    /* Etykieta "Kod kraju". */
		    label = gtk_label_new(_("Country prefix:"));
		    gtk_widget_show(label);
		    
		    gtk_fixed_put(GTK_FIXED(fixed), label, 8, 8);
		    gtk_widget_set_uposition(label, 8, 8);
		    gtk_widget_set_usize(label, 112, 24);
		    gtk_label_set_line_wrap(GTK_LABEL(label), TRUE);
		    
		    /* Pole edycji "Kod kraju". */
		    entry = gtk_entry_new_with_max_length(MAX_PHONE_COUNTRY);
		    gtk_widget_show(entry);
		    
		    gtk_object_set_data(GTK_OBJECT(phone_dialog), "country", entry);
		    
		    gtk_fixed_put(GTK_FIXED(fixed), entry, 128, 8);
		    gtk_widget_set_uposition(entry, 128, 8);
		    gtk_widget_set_usize(entry, 104, 24);
		    gtk_entry_set_text(GTK_ENTRY(entry),
		                       data->phone[data->phone_type[data->phone_pos]].country);
		    gtk_widget_grab_focus(entry);
		    
		    /* Etykieta "Numer kierunkowy". */
		    label = gtk_label_new(_("Region prefix:"));
		    gtk_widget_show(label);
		    
		    gtk_fixed_put(GTK_FIXED(fixed), label, 8, 40);
		    gtk_widget_set_uposition(label, 8, 40);
		    gtk_widget_set_usize(label, 112, 24);
		    gtk_label_set_line_wrap(GTK_LABEL(label), TRUE);
		    
		    /* Pole edycji "Numer kierunkowy". */
		    entry = gtk_entry_new_with_max_length(MAX_PHONE_REGION);
		    gtk_widget_show(entry);
		    
		    gtk_object_set_data(GTK_OBJECT(phone_dialog), "region", entry);
		    
		    gtk_fixed_put(GTK_FIXED(fixed), entry, 128, 40);
		    gtk_widget_set_uposition(entry, 128, 40);
		    gtk_widget_set_usize(entry, 104, 24);
		    gtk_entry_set_text(GTK_ENTRY(entry),
		                       data->phone[data->phone_type[data->phone_pos]].region);
		    
		    /* Etykieta "Numer telefonu". */
		    label = gtk_label_new(_("Phone number:"));
		    gtk_widget_show(label);
		    
		    gtk_fixed_put(GTK_FIXED(fixed), label, 8, 72);
		    gtk_widget_set_uposition(label, 8, 72);
		    gtk_widget_set_usize(label, 112, 24);
		    gtk_label_set_line_wrap(GTK_LABEL(label), TRUE);
		    
		    /* Pole edycji "Numer telefonu". */
		    entry = gtk_entry_new_with_max_length(MAX_PHONE_NUMBER);
		    gtk_widget_show(entry);
		    
		    gtk_object_set_data(GTK_OBJECT(phone_dialog), "number", entry);
		    
		    gtk_fixed_put(GTK_FIXED(fixed), entry, 128, 72);
		    gtk_widget_set_uposition(entry, 128, 72);
		    gtk_widget_set_usize(entry, 104, 24);
		    gtk_entry_set_text(GTK_ENTRY(entry),
		                       data->phone[data->phone_type[data->phone_pos]].number);
	
	/* Obszar przyciskw okienka dialogowego. */
	dialog_action_area = GTK_DIALOG(phone_dialog)->action_area;
	gtk_widget_show(dialog_action_area);
	
	gtk_container_set_border_width(GTK_CONTAINER(dialog_action_area), 10);
	
	    /* Listwa przyciskw. */
	    hbuttonbox = gtk_hbutton_box_new();
	    gtk_widget_show(hbuttonbox);
	    
	    gtk_box_pack_start(GTK_BOX(dialog_action_area), hbuttonbox, TRUE, TRUE, 0);
	    
	    gtk_button_box_set_layout(GTK_BUTTON_BOX(hbuttonbox), GTK_BUTTONBOX_END);
	    gtk_button_box_set_spacing(GTK_BUTTON_BOX(hbuttonbox), 10);
	    
	        /* Przycisk "OK". */
		button = gtk_button_new_with_label(_("OK"));
		gtk_widget_show(button);
		
		gtk_signal_connect(GTK_OBJECT(button), "clicked",
		                   GTK_SIGNAL_FUNC(ok_button_clicked), data);
		
		gtk_container_add(GTK_CONTAINER(hbuttonbox), button);
		
		GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
		gtk_widget_grab_default(button);
		
		/* Przycisk "Anuluj". */
		button = gtk_button_new_with_label(_("Cancel"));
		gtk_widget_show(button);
		
		gtk_signal_connect(GTK_OBJECT(button), "clicked",
		                   GTK_SIGNAL_FUNC(dialog_delete), phone_dialog);
		
		gtk_container_add(GTK_CONTAINER(hbuttonbox), button);
		
		GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
    
    /* Wywietlenie okienka dialogowego. */
    gtk_widget_show(phone_dialog);
    
    /* Ustalenie modalnoci okienka. */
    gtk_window_set_modal(GTK_WINDOW(phone_dialog), TRUE);
    gtk_window_set_transient_for(GTK_WINDOW(phone_dialog), GTK_WINDOW(data->contact_window));
}
