#!/bin/bash
#
# start_hsnc.sh
#
# Copyright 2003 IBM Corporation
# Author(s): Utz Bacher <utz.bacher@de.ibm.com>
#
# wrapper start script for ip_watcher.pl, also cleanup, when ip_watcher.pl
# gets killed

#
# what is the kernel version we are on ?
#
kernel_version=`uname -r`

if [ "${kernel_version:2:1}" \> 4 ]; then
	        kernel_version=2.6
else
	        kernel_version=2.4
fi


if [ X${1}X != XX ] && [ $kernel_version = 2.4 ] ; then
	if ! cat /proc/qeth | awk '{print $3}' | egrep "^$1$" > /dev/null; then
		echo interface $1 does not exist.
		exit
	fi
elif [ X${1}X != XX ] && [ $kernel_version = 2.6 ] ; then
	if ! ls /sys/class/net | grep "^$1$" > /dev/null; then
		echo interface $1 does not exist.
		exit
	fi
fi

ip_watcher.pl $*

echo ip_watcher.pl was terminated, cleaning up.

if [ X${1}X == XX ] ; then
	echo killing xcec-bridge
	killall xcec-bridge
fi

echo removing all parp entries from mc interfaces
if [ X${1}X == XX ] ; then
	cat /proc/qeth | egrep ' mc | mc+ ' | awk '{print $3}' | sed 's/$/\$/' > /tmp/ip_watcher.cleanup1
else
	echo ${1}$ > /tmp/ip_watcher.cleanup1
fi

qethconf rxip list | sed 's/rxip add/rxip del/' | egrep -f /tmp/ip_watcher.cleanup1 > /tmp/ip_watcher.cleanup2


while read line; do
	qethconf $line > /dev/null 2>&1
done < /tmp/ip_watcher.cleanup2
rm /tmp/ip_watcher.cleanup1
rm /tmp/ip_watcher.cleanup2

echo removing all routes from connector interfaces
cat /proc/qeth | egrep ' p.c | p+c | s.c | s+c ' | awk '{print $3}"$"' > /tmp/ip_watcher.cleanup1
route -n | egrep -f /tmp/ip_watcher.cleanup1 > /tmp/ip_watcher.cleanup2
while read line; do
	route del -net `echo $line | awk '{print $1 " netmask " $3 " dev " $8}'`
done < /tmp/ip_watcher.cleanup2
rm /tmp/ip_watcher.cleanup1
rm /tmp/ip_watcher.cleanup2
