// Copyright (C) 1999-2004
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __baseellipse_h__
#define __baseellipse_h__

#include "basemarker.h"

class BaseEllipse : public BaseMarker {
protected:
  Vector* radii;
  Matrix flip;            // non iis needs a flip in Y

  void calcPoints(double);
  virtual void updateHandles() {}

public:
  BaseEllipse(const BaseEllipse&);
  BaseEllipse(FrameBase* p, const Vector& ctr, double a,
	      const char* clr, int w, const char* f, const char* t, 
	      unsigned short prop, const char* c, const List<Tag>& tag);
  virtual ~BaseEllipse();

  virtual Marker* dup() =0;
  void updateCoords(const Matrix&);
  int isIn(const Vector&);

  virtual void list(ostream&, CoordSystem, SkyFrame, SkyFormat, char) =0;
  virtual void listCiao(ostream&, CoordSystem, SkyFrame, SkyFormat, char) {}
  virtual void listSAOimage(ostream&,CoordSystem,SkyFrame,SkyFormat,char) =0;
  virtual void listPros(ostream&, CoordSystem, SkyFrame, SkyFormat, char) =0;
};

#endif


