/* Copyright (C) 1999-2004
 * Smithsonian Astrophysical Observatory, Cambridge, MA, USA
 * For conditions of distribution and use, see copyright notice in "copyright"
 */

%option noyywrap
%option caseless
%option never-interactive
%option c++

%{
  #include <stdio.h>
  #include <stdlib.h>
  #include <string.h>

  #include "util.h"
  #include "ds9parser.H"

  extern mkFlexLexer* mklexx;
  extern int mksign;
%}

%x DISCARD

D   [0-9]
E   [Ee][+-]?{D}+

/* rules */

%%

<DISCARD>[\n]	{ // special case-- #\n
		  BEGIN INITIAL;
		  yyless(0);             // put back the terminator
		  strcpy(mklval.str,""); // feed a blank string
		  return STRING;
		}

<DISCARD>[^\n]* {  // Discard reset of line
		  BEGIN INITIAL;
		  strncpy(mklval.str,yytext,256);
		  return STRING;
		}

amplifier		{return AMPLIFIER_;}
ann[u][l][u][s]		{return ANNULUS_;}
arcmin			{return ARCMIN_;}
arcsec			{return ARCSEC_;}
arrow			{return ARROW_;}
b1950			{return B1950_;}
background		{return BACKGROUND_;}
box			{return BOX_;}
boxcircle		{return BOXCIRCLE_;}
cir[c][l][e]		{return CIRCLE_;}
color			{return COLOR_;}
compass			{return COMPASS_;}
cross			{return CROSS_;}
debug			{return DEBUG_;}
degrees			{return DEGREES_;}
delete			{return DELETE_;}
detector		{return DETECTOR_;}
diamond			{return DIAMOND_;}
edit			{return EDIT_;}
ell[i][p][s][e]		{return ELLIPSE_;}
ecliptic		{return ECLIPTIC_;}
false			{return FALSE_;}
fie[l][d]		{return FIELD_;}
fixed			{return FIXED_;}
fk4			{return FK4_;}
fk5			{return FK5_;}
font			{return FONT_;}
galactic		{return GALACTIC_;}
global			{return GLOBAL_;}
highlite		{return HIGHLITE_;}
icrs			{return ICRS_;}
ignore			{return IGNORE_;}
include			{return INCLUDE_;}
image			{return IMAGE_;}
j2000			{return J2000_;}
lin[e]			{return LINE_;}
linear			{return LINEAR_;}
move			{return MOVE_;}
n			{return N_;}
no			{return NO_;}
off			{return OFF_;}
on			{return ON_;}
pan[d][a]		{return PANDA_;}
physical		{return PHYSICAL_;}
pie			{return PIE_;}
pixels			{return PIXELS_;}
poi[n][t]		{return POINT_;}
pol[y][g][o][n]		{return POLYGON_;}
projection		{return PROJECTION_;}
rotate			{return ROTATE_;}
rotbox			{return ROTBOX_;}
ruler			{return RULER_;}
select			{return SELECT_;}
source			{return SOURCE_;}
tag			{return TAG_;}
text			{return TEXT_;}
textangle		{return TEXTANGLE_;}
tile			{return TILE_;}
true			{return TRUE_;}
version			{return VERSION_;}
wcs		{return WCS_;}
wcsa		{return WCSA_;}
wcsb		{return WCSB_;}
wcsc		{return WCSC_;}
wcsd		{return WCSD_;}
wcse		{return WCSE_;}
wcsf		{return WCSF_;}
wcsg		{return WCSG_;}
wcsh		{return WCSH_;}
wcsi		{return WCSI_;}
wcsj		{return WCSJ_;}
wcsk		{return WCSK_;}
wcsl		{return WCSL_;}
wcsm		{return WCSM_;}
wcsn		{return WCSN_;}
wcso		{return WCSO_;}
wcsp		{return WCSP_;}
wcsq		{return WCSQ_;}
wcsr		{return WCSR_;}
wcss		{return WCSS_;}
wcst		{return WCST_;}
wcsu		{return WCSU_;}
wcsv		{return WCSV_;}
wcsw		{return WCSW_;}
wcsx		{return WCSX_;}
wcsy		{return WCSY_;}
wcsz		{return WCSZ_;}
width			{return WIDTH_;}
x			{return X_;}
y			{return Y_;}
yes			{return YES_;}

[+-]?{D}+	{ // Integer
		  mklval.integer = atoi(yytext);
		  mksign = (yytext[0]!='-') ? 1 : -1;
		  return INT;
		}

[+-]?{D}+"."?({E})? |
[+-]?{D}*"."{D}+({E})? { // Real Number
		  mklval.real = atof(yytext);
		  return REAL;
		}

[+-]?{D}+"."?d |
[+-]?{D}*"."{D}+d { // degrees
		  yytext[yyleng-1] = '\0';
		  mklval.real = atof(yytext);
		  return DEGREE;
		}	

[+-]?{D}+"."?r |
[+-]?{D}*"."{D}+r { // radians
		  yytext[yyleng-1] = '\0';
		  mklval.real = atof(yytext);
		  return RADIAN;
		}

[+-]?{D}+"."?p |
[+-]?{D}*"."{D}+p { // physical coords
		  yytext[yyleng-1] = '\0';
		  mklval.real = atof(yytext);
		  return PHYCOORD;
		}

[+-]?{D}+"."?i |
[+-]?{D}*"."{D}+i { // image coords
		  yytext[yyleng-1] = '\0';
		  mklval.real = atof(yytext);
		  return IMGCOORD;
		}

{D}+"."?' |
{D}*"."{D}+'	{ // minutes of arc
		  yytext[yyleng-1] = '\0';
		  mklval.real = atof(yytext);
		  return ARCMINUTE;
		}	

{D}+"."?\" |
{D}*"."{D}+\"	{ // seconds of arc
		  yytext[yyleng-1] = '\0';
		  mklval.real = atof(yytext);
		  return ARCSECOND;
		}

[+-]?{D}+h	{ // hours
		  yytext[yyleng-1] = '\0';
		  mklval.integer = atoi(yytext);
		  mksign = (yytext[0]!='-') ? 1 : -1;
		  return HOUR;
		}	

{D}+m		{ // minutes
		  yytext[yyleng-1] = '\0';
		  mklval.integer = atoi(yytext);
		  return MINUTE;
		}	

{D}+"."?s |
{D}*"."{D}+s	{ // seconds
		  yytext[yyleng-1] = '\0';
		  mklval.real = atof(yytext);
		  return SECOND;
		}

[+-]?{D}+:{D}+:{D}+"."? |
[+-]?{D}+:{D}+:{D}*"."{D}+ { // Sexagesimal
		  strncpy(mklval.str,yytext,256);
		  return SEXSTR;
		}	

\"[^\"\n]*\" | 
\'[^\'\n]*\'	{ // Quoted String
		  strncpy(mklval.str,yytext+1,yyleng-2); // skip the " " 
	          mklval.str[yyleng-2] = '\0'; // Remove the '"' 
		  return STRING;
		}

\{[^\}\n]*\} 	{ // Quoted String
		  strncpy(mklval.str,yytext+1,yyleng-2); // skip the '{'
	          mklval.str[yyleng-2] = '\0'; // Remove the '}'
		  return STRING;
		}

[0-9A-Za-z]+	{ // General String
		  strncpy(mklval.str,yytext,256);
		  return STRING;
		}

[ \t]+		{ // White Spaces
		} 

\n		{ // linefeed
		  return '\n';
		}

\\n		{ // fake line feed
		  return '\n';
		}

.		{ // Else, return the char
		  return yytext[0];
		}

%%

void mkDiscard(int doit)
{
  if (mklexx)
    mklexx->begin(DISCARD, doit);
}

void mkFlexLexer::begin(int which, int doit)
{
  BEGIN which;
  if (doit)
    yyless(0);
}
