// Copyright (C) 1999-2004
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#include "frametrue8.h"
#include "colorscaletrue8.h"
#include "fitsimage.h"
#include "nan.h"
#include "ps.h"
#include "util.h"

// Tk Canvas Widget Function Declarations

int FrameTrueColor8CreateProc(Tcl_Interp*, Tk_Canvas, Tk_Item*, int, Tcl_Obj *const []);

// FrameTrueColor8 Specs

static Tk_CustomOption tagsOption = {
  Tk_CanvasTagsParseProc, Tk_CanvasTagsPrintProc, NULL
};

static Tk_ConfigSpec frameTrueColor8Specs[] = {

  {TK_CONFIG_STRING, "-command", NULL, NULL, "frame",
   Tk_Offset(WidgetOptions, cmdName), TK_CONFIG_OPTION_SPECIFIED, NULL},
  {TK_CONFIG_INT, "-x", NULL, NULL, "1",
   Tk_Offset(WidgetOptions, x), TK_CONFIG_OPTION_SPECIFIED, NULL},
  {TK_CONFIG_INT, "-y", NULL, NULL, "1",
   Tk_Offset(WidgetOptions, y), TK_CONFIG_OPTION_SPECIFIED, NULL},
  {TK_CONFIG_INT, "-width", NULL, NULL, "512",
   Tk_Offset(WidgetOptions, width), TK_CONFIG_OPTION_SPECIFIED, NULL},
  {TK_CONFIG_INT, "-height", NULL, NULL, "512",
   Tk_Offset(WidgetOptions, height), TK_CONFIG_OPTION_SPECIFIED, NULL},
  {TK_CONFIG_ANCHOR, "-anchor", NULL, NULL, "nw",
   Tk_Offset(WidgetOptions, anchor), 0, NULL},
  {TK_CONFIG_CUSTOM, "-tags", NULL, NULL, NULL,
   0, TK_CONFIG_NULL_OK, &tagsOption},

  {TK_CONFIG_END, NULL, NULL, NULL, NULL, 0, 0, NULL},
};

// Tk Static Structure

static Tk_ItemType frameTrueColor8Type = {
  "frametruecolor8",           // name
  sizeof(WidgetOptions),        // item size
  FrameTrueColor8CreateProc,   // configProc
  frameTrueColor8Specs,        // configSpecs
  WidgetConfigProc,             // configProc
  WidgetCoordProc,              // coordProc
  WidgetDeleteProc,             // deleteProc
  WidgetDisplayProc,            // displayProc
  0,                            // alwaysRedraw
  WidgetPointProc,              // pointProc
  WidgetAreaProc,               // areaProc
  WidgetPostscriptProc,         // postscriptProc
  WidgetScaleProc,              // scaleProc
  WidgetTranslateProc,          // translateProc
  (Tk_ItemIndexProc*)NULL,      // indexProc
  WidgetICursorProc,            // icursorProc
  (Tk_ItemSelectionProc*)NULL,  // selectionProc
  (Tk_ItemInsertProc*)NULL,     // insertProc
  (Tk_ItemDCharsProc*)NULL,     // dCharsProc
  (Tk_ItemType*)NULL            // nextPtr
};

// Non-Member Functions

int FrameTrueColor8_Init(Tcl_Interp* interp)
{
  Tk_CreateItemType(&frameTrueColor8Type);
  return TCL_OK;
}

int FrameTrueColor8CreateProc(Tcl_Interp* interp, Tk_Canvas canvas, 
			      Tk_Item* item, int argc, Tcl_Obj *const argv[])
{
  FrameTrueColor8* frame = new FrameTrueColor8(interp, canvas, item);

  // and set default configuration

  if (frame->configure(argc, (const char**)argv, 0) != TCL_OK) {
    delete frame;
    Tcl_AppendResult(interp, " error occured while creating frame.", NULL);
    return TCL_ERROR;
  }

  return TCL_OK;
}

// FrameTrueColor8 Member Functions

FrameTrueColor8::FrameTrueColor8(Tcl_Interp* i, Tk_Canvas c, Tk_Item* item)
  : FrameTrueColor(i, c, item)
{
  configSpecs = frameTrueColor8Specs;  // frame configure options
}

FrameTrueColor8::~FrameTrueColor8()
{
  // we must do this at this level, because updateColorScale is called
  unloadAllFits();
}

void FrameTrueColor8::encodeTrueColor(XColor* src, char* dest)
{
  int rs,gs,bs;
  unsigned char rm = decodeMask((unsigned char) visual->red_mask, &rs);
  unsigned char gm = decodeMask((unsigned char)visual->green_mask, &gs);
  unsigned char bm = decodeMask((unsigned char)visual->blue_mask, &bs);

  *dest = 
    ((((unsigned char)src->blue)  & bm) >> bs) | 
    ((((unsigned char)src->green) & gm) >> gs) | 
    ((((unsigned char)src->red)   & rm) >> rs);
}

void FrameTrueColor8::updateColorScale()
{
  // we need colors before we can construct a scale

  if (!indexCells || !colorCells)
    return;

  // since we need to know about bytes per pixel and byte order, 
  // we may need to wait til we have an XImage available and try again

  if (!baseXImage)
    return;

  encodeTrueColor(bgColor,bgTrueColor_);
  encodeTrueColor(nanColor,nanTrueColor_);

  if (colorScale)
    delete colorScale;

  switch (currentScale->colorScaleType()) {
  case FrScale::LINEARSCALE:
    colorScale =
      new LinearScaleTrueColor8(colorCount, indexCells, colorCells, colorCount,
				visual->red_mask, visual->green_mask, 
				visual->blue_mask);
    break;
  case FrScale::LOGSCALE:
    colorScale =
      new LogScaleTrueColor8(SCALESIZE, indexCells, colorCells, colorCount,
			     visual->red_mask, visual->green_mask, 
			     visual->blue_mask);
    break;
  case FrScale::SQUAREDSCALE:
    colorScale =
      new SquaredScaleTrueColor8(SCALESIZE, indexCells, colorCells, colorCount,
				 visual->red_mask, visual->green_mask,
				 visual->blue_mask);
    break;
  case FrScale::SQRTSCALE:
    colorScale = 
      new SqrtScaleTrueColor8(SCALESIZE, indexCells, colorCells, colorCount,
			      visual->red_mask, visual->green_mask, 
			      visual->blue_mask);
    break;
  case FrScale::IISSCALE:
    colorScale =
      new IISScaleTrueColor8(indexCells, colorCells, colorCount,
    			     visual->red_mask, visual->green_mask, 
    			     visual->blue_mask);
    break;
  case FrScale::HISTEQUSCALE:
    calcHistEqu();
    colorScale =
      new HistEquScaleTrueColor8(SCALESIZE, indexCells, colorCells, colorCount,
				 currentScale->histequ(), HISTEQUSIZE,
				 visual->red_mask, 
				 visual->green_mask, 
				 visual->blue_mask);
    break;
  }
}


