// Copyright (C) 1999-2004
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __polygon_h__
#define __polygon_h__

#include "marker.h"
#include "list.h"

class Polygon : public Marker {
private:
  List<Vertex> vertex;
  Matrix flip;

  void render(Drawable, const Matrix&, double, RenderMode);
  void moveVertex(const Vector&, int);
  void recalcCenter();

public:
  Polygon(const Polygon&);
  Polygon(FrameBase* p, const Vector& ctr, const Vector& bb, 
	  const char* clr, int w, const char* f, 
	  const char* t, unsigned short prop, const char* c,
	  const List<Tag>& tag);
  Polygon(FrameBase* p, const List<Vertex>& v,
	  const char* clr, int w, const char* f,
	  const char* t, unsigned short prop, const char* c,
	  const List<Tag>& tag);

  Marker* dup() {return new Polygon(*this);}
  void updateBBox();
  void updateCoords(const Matrix&);

  void edit(const Vector&, int);
  void rotate(const Vector&, int);
  void ps(int);
  int isIn(const Vector& v);
  int isPolygon() {return 1;}

  void createVertex(int, const Vector&);
  void deleteVertex(int);
  int getSegment(const Vector&);
  void reset(const Vector&);

  void list(ostream&, CoordSystem, SkyFrame, SkyFormat, char);
  void listCiao(ostream&, CoordSystem, SkyFrame, SkyFormat, char);
  void listSAOtng(ostream&, CoordSystem, SkyFrame, SkyFormat, char);
  void listSAOimage(ostream&, CoordSystem, SkyFrame, SkyFormat, char);
  void listPros(ostream&, CoordSystem, SkyFrame, SkyFormat, char);
};

#endif
