// Copyright (C) 1999-2004
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __projection_h__
#define __projection_h__

#include "marker.h"

class Projection : public Marker {
 public:
  enum Method {SUM,AVERAGE};

 private:
  Vector p1;
  Vector p2;
  double width;
  Method method;
  CoordSystem system;
  SkyFrame skyframe;

  void render(Drawable, const Matrix&, double, RenderMode);
  void update();

 public:
  Projection(const Projection&);
  Projection(FrameBase* parent, const Vector& ctr, const Vector& p, double w,
	     const char* mvcb, const char* delcb,
	     const char* clr, int w, const char* f, 
	     const char* t, unsigned short prop, const char* c,
	     const List<Tag>& tag);

  Marker* dup() {return new Projection(*this);}
  void updateBBox();
  void updateCoords(const Matrix&);

  void move(const Vector&);
  void moveTo(const Vector&);
  void edit(const Vector&, int);

  void rotateBegin() {}
  void rotate(const Vector& v, int h) {}
  void rotateEnd() {}

  void ps(int);
  int isIn(const Vector&);
  Vector getCenter() {return p1;}

  const Vector& getP1() {return p1;}
  const Vector& getP2() {return p2;}
  void set(const Vector&, const Vector&, double, int);
  void setPoints(const Vector&, const Vector&);
  void setWidth(double);
  double getWidth() {return width;}
  int getMethod() {return method;}

  CoordSystem getSystem() {return system;}
  SkyFrame getSkyFrame() {return skyframe;}
  void setSystem(CoordSystem sys, SkyFrame sky) 
    {system = sys; skyframe = sky;}

  void list(ostream&, CoordSystem, SkyFrame, SkyFormat, char);
};

#endif
