INSERT INTO vars (name, value, description, type, category) VALUES ('default_commentstatus', '0', 'Default commentstatus when creating a new story. Possible values are 0 for Enabled, -1 for Disabled, and 1 for Read-Only.', 'num', 'Stories, Comments');

UPDATE box SET content = 'my $pollqid = shift @ARGS;\r\nmy $preview = 0;\r\n\r\nmy ($pollqid, $action) = $S->get_qid_to_show();\r\n$preview = 1 if ($action eq \'preview\');\r\nreturn \'\' if ($pollqid == 0);\r\n\r\n# if this is an attached poll, don\'t display if the story is hidden, unless\r\n# the current user can view all polls. also make sure the current user has\r\n# permission to view stories in this section\r\nif (my $sid = $S->get_sid_from_qid($pollqid)) {\r\n	return \'\'\r\n		if (($S->_check_story_mode($sid) == -1) && !$S->have_perm(\'list_polls\'))\r\n		|| (!$S->have_section_perm(\'norm_read_stories\', $S->_get_story_section($sid)));\r\n}\r\n\r\nmy $poll_hash = $S->get_poll_hash( $pollqid, $action );\r\n\r\n# first get the poll form all set up except for the answers\r\nmy $poll_form = qq|\r\n	<!-- begin poll form -->\r\n	<FORM ACTION="%%rootdir%%/" METHOD="POST">\r\n    <INPUT TYPE="hidden" NAME="op" VALUE="view_poll">\r\n    <INPUT TYPE="hidden" NAME="qid" VALUE="$poll_hash->{\'qid\'}">\r\n    <INPUT type="hidden" name="ispoll" value="1">|;\r\n\r\n$poll_form .= "<b>$poll_hash->{\'question\'}</b><br>";\r\n\r\n# here is where all the answer fields get filled in\r\nmy $answer_array = $S->get_poll_answers($poll_hash->{\'qid\'}, $action);\r\n\r\n# now check if they have already voted or haven\'t logged in\r\nmy $row;\r\nif ( $S->_can_vote($poll_hash->{\'qid\'}) ) {\r\n    foreach $row ( @{$answer_array} ) {	\r\n        $poll_form .= qq|\r\n   	        <INPUT TYPE="radio" NAME="aid" VALUE="$row->{\'aid\'}"> $row->{\'answer\'}<BR>|;\r\n   	}\r\n} else {\r\n    my $total_votes = $poll_hash->{\'voters\'};\r\n\r\n    if($total_votes == 0) {\r\n        $total_votes = 1;  # so we don\'t get a divide by 0 error\r\n    }\r\n\r\n	$poll_form .= qq|\r\n		<TABLE BORDER=0 CELLPADDING=2 CELLSPACING=0>|;\r\n\r\n	foreach $row ( @{$answer_array} ) {\r\n		my $percent = int($row->{\'votes\'} / $total_votes * 100);\r\n		$poll_form .= qq|\r\n			<TR>\r\n				<TD valign="top">%%norm_font%%%%dot%%%%norm_font_end%%</TD>\r\n				<TD valign="top">%%norm_font%%$row->{\'answer\'}%%norm_font_end%%</TD>\r\n				<TD valign="top">%%norm_font%% $percent% %%norm_font_end%%</TD>\r\n			</TR>|;\r\n   	}\r\n	$poll_form .= qq|\r\n		</TABLE>|;\r\n		\r\n}\r\n\r\n# get the # of comments\r\nmy $comment_num = $S->poll_comment_num($poll_hash->{\'qid\'});\r\n   \r\n# only show the vote button if they havn\'t voted\r\nif ( $S->_can_vote($poll_hash->{\'qid\'}) && ! $preview ) {\r\n	$poll_form .= qq|<BR><INPUT TYPE="submit" name="vote" VALUE="Vote">|;\r\n}\r\n\r\n\r\n# now finish up the form\r\nmy $op = $S->{CGI}->param(\'op\');\r\nmy $comm_disp = ($op ne \'displaystory\') ? \r\n	qq{\r\n	<TD>%%norm_font%%Votes: <b>$poll_hash->{\'voters\'}</b>%%norm_font_end%%</TD>\r\n	<TD ALIGN="center" WIDTH=15>%%norm_font%%|%%norm_font_end%%</TD>\r\n	<TD ALIGN="right">%%norm_font%% Comments: <b>$comment_num</b>%%norm_font_end%%</TD></TR>\r\n	} : \r\n	qq{\r\n	<TD COLSPAN="3" ALIGN="center">%%norm_font%%Votes: <b>$poll_hash->{\'voters\'}</b>%%norm_font_end%%</TD>\r\n	};\r\n\r\n$poll_form .= qq{\r\n	</FORM>\r\n	<!-- end poll form -->\r\n	<P>\r\n	%%norm_font%%\r\n    <TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0 ALIGN="center">\r\n	<TR>\r\n		$comm_disp\r\n	<TR> };\r\n\r\nif( $preview ) {\r\n    $poll_form .= qq{\r\n	<TD>%%norm_font%%Results%%norm_font_end%%</TD>\r\n	<TD ALIGN="center" WIDTH=15>%%norm_font%%|%%norm_font_end%%</TD>\r\n    <TD ALIGN="right">%%norm_font%% Other Polls%%norm_font_end%%</TD></TR>\r\n	};\r\n\r\n} else {\r\n    $poll_form .= qq{\r\n	<TD>%%norm_font%%<a href="%%rootdir%%/poll/$poll_hash->{\'qid\'}">Results</a>%%norm_font_end%%</TD>\r\n	<TD ALIGN="center" WIDTH=15>%%norm_font%%|%%norm_font_end%%</TD>\r\n    <TD ALIGN="right">%%norm_font%% <a href="%%rootdir%%/?op=search;type=polls;search=Search">Other Polls</a>%%norm_font_end%%</TD></TR>\r\n	};\r\n}\r\n\r\n$poll_form .= qq{\r\n	</TABLE>\r\n	%%norm_font_end%%\r\n	<!-- end poll content -->};\r\n\r\n## don\'t forget to tell them its a poll preview if it is\r\nif( $preview ) {\r\n	$title = "Poll Preview";\r\n}\r\n\r\nif ($poll_form) {\r\n	return {content => qq{%%norm_font%%$poll_form%%norm_font_end%%}, title => $title};\r\n} else {\r\n	return \'\';\r\n}\r\n' WHERE boxid = 'poll_box';
