//----------------------------------------------------------------------------
//
//  This file is part of seq24.
//
//  seq24 is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  seq24 is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with seq24; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//-----------------------------------------------------------------------------

#include "options.h"
#include <sstream>


const int c_status = 0;
const int c_status_inv =1;
const int c_d1 = 2;
const int c_d2 = 3;
const int c_d3 = 4;


options::options( Gtk::Window &parent, perform *a_p ):
    Gtk::Dialog( "Options", parent, true, true )
{
    m_perf = a_p;
    
    HBox *hbox = manage( new HBox());
    get_vbox()->pack_start( *hbox, false, false );
    
    get_action_area()->set_border_width( 2 );
    hbox->set_border_width( 6 );
    
    m_button_ok = manage( new Button( " Ok " ) );
    get_action_area()->pack_end( *m_button_ok, false, false );
    m_button_ok->signal_clicked().connect( slot(*this, &options::hide ));
    

    
    m_notebook = manage( new Notebook() );
    hbox->pack_start( *m_notebook );
    
    int buses = m_perf->get_master_midi_bus( )->get_num_out_buses();
    
    VBox *vbox = manage( new VBox( ));
    m_notebook->pages().push_back(  Notebook_Helpers::TabElem( *vbox, "MIDI Clock"));

    CheckButton *check;
    
    for ( int i=0; i<buses; i++ ){
        
        check = manage( new CheckButton(  m_perf->get_master_midi_bus( )->get_midi_bus_name( i ), 0 ));
        check->signal_toggled().connect( bind(slot(*this,&options::clock_callback), i, check ));
        check->set_active( m_perf->get_master_midi_bus( )->get_clock( i ));
        
        vbox->pack_start( *check, false, false );
    }
    
    
    VBox *vbox2 = manage( new VBox());
    vbox2->set_border_width(4);
    m_notebook->pages().push_back(  Notebook_Helpers::TabElem( *vbox2, "Jack Sync"));

    Gtk::Tooltips *tooltips = manage( new Tooltips( ) );

    check = manage( new CheckButton( "Jack Transport"));
    check->set_active( global_with_jack_transport );
    tooltips->set_tip( *check, "Enable sync with JACK Transport." );
    check->signal_toggled().connect( bind(slot(*this,&options::transport_callback),
                                          e_jack_transport, check ));
    vbox2->pack_start( *check, false, false );

    check = manage( new CheckButton( "Transport Master"));
    check->set_active( global_with_jack_master );
    tooltips->set_tip( *check, "Seq24 will attempt to serve as JACK Master." );
    check->signal_toggled().connect( bind(slot(*this,&options::transport_callback),
                                          e_jack_master, check ));

    vbox2->pack_start( *check, false, false );
    
    check = manage( new CheckButton( "Master Conditional"));
    check->set_active(global_with_jack_master_cond);
    tooltips->set_tip( *check, "Seq24 will fail to be master if there is already a master set." );
    check->signal_toggled().connect( bind(slot(*this,&options::transport_callback),
                                          e_jack_master_cond, check ));

    vbox2->pack_start( *check, false, false );

      
    Gtk::RadioButton *rb_live = manage( new RadioButton( "Live Mode"));
    tooltips->set_tip( *rb_live, "Playback will be in live mode.  Use this to allow muting and unmuting of loops." );
    
    Gtk::RadioButton *rb_perform = manage( new RadioButton( "Song Mode"));
    tooltips->set_tip( *rb_perform, "Playback will use the song editors data." );

    Gtk::RadioButton::Group group = rb_live->get_group();
    rb_perform->set_group(group);
    
    if ( global_jack_start_mode ) {
        rb_perform->set_active( true );
    }
    else
    {
        rb_live->set_active( true );
    }
    
    rb_perform->signal_toggled().connect( bind(slot(*this,&options::transport_callback),
                                               e_jack_start_mode_song, rb_perform ));

    vbox2->pack_start( *rb_live, false, false );
    vbox2->pack_start( *rb_perform, false, false );
    

    /* show everything */
    show_all_children();
}

	

void
options::clock_callback( int a_bus, CheckButton *a_button )
{
    bool clocking = a_button->get_active( );
    m_perf->get_master_midi_bus( )->set_clock( a_bus, clocking );
}


void
options::transport_callback( button a_type, CheckButton *check )
{
    switch ( a_type ){
        
        case e_jack_transport:
        {
            global_with_jack_transport = check->get_active();
        }
        break;

        case e_jack_master:
        {
            global_with_jack_master = check->get_active();
        }
        break;

        case e_jack_master_cond:
        {
            global_with_jack_master_cond = check->get_active();
        }
        break;

        case e_jack_start_mode_song:
        {
            printf( "toggle %d\n" ,  check->get_active() );
            global_jack_start_mode =  check->get_active();
        }
        break;
        
        default:
            break;
    }
}
