/***************************************************************************
                          tracker.h  -  description
                             -------------------
    begin                : Wed Sep 27 2000
    copyright            : (C) 2000 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TRACKER_H
#define TRACKER_H
#include <gtk--/widget.h>
#include <gtk--/window.h>
#include "editor.h"
#include "interface_font_draw.h"

/**GTK-- Tracker Class
  *@author Juan Sebastian Linietsky
  */


class Tracker : public Gtk::Widget {
private:

	// Widget Colormap and Font Information

	Gdk_Pixmap *c_window; //current_drawing_window

	enum Tracker_Colormap {

		Col_BackGround,
		Col_ForeGround,
		Col_Cursor,
		Col_Row_Hilite_Minor,
		Col_Row_Hilite_Major,
		Col_BackGround_Selected,
		Col_Row_Hilite_Selected,
		Col_ForeGround_Selected,
		Col_SepChannels,
		Col_SepNewChannels,
		Col_Mask,
		Col_ForeGround_Inactive,
		Tracker_max_Colors
	};

	static int Tracker_Colors[];

	Gdk_Color colors[Tracker_max_Colors];
	Gdk_GC bgcol, fgcol, cursorcol, sepcol, sepcolnew, hlmajcol, hlmincol, bgselcol, fgselcol, hlselcol, misc_gc, maskcol, fgcolinact;
	void allocate_colormap ();

	Gdk_Font font;
	Interface_Font_Draw font_draw;

	int old_width;
	int old_height;
	//Tracker Stuff

	// Functions to Draw Stuff to screen

	void adjust_editor();
	void print_single_row(int rowofs);
	void print_rows();
	void print_number(int rowofs,bool hilite_number);
	void print_cursor();
	void print_top();
	void print_no_tracks();

	bool backing_store;
	void adjust_screen();
	void redraw_screen();
	
public:

	Pattern_Editor editor;

	Gdk_Window window;
	void realize_impl();
	gint do_expose_event(GdkEventExpose* p0);
	void draw_impl(GdkRectangle* p0);
	void update_playing_row();

	Tracker();
	void link_to_song(Song *songptr);
	~Tracker();
};

#endif
