/***************************************************************************
                          loader_it.h  -  description
                             -------------------
    begin                : Tue Feb 20 2001
    copyright            : (C) 2001 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LOADER_IT_H
#define LOADER_IT_H

#include "song.h"

enum {

	LOADER_LOAD_SUCCESS,
	LOADER_ERROR_LOADER_IN_USE,
	LOADER_ERROR_CANNOT_OPEN_FILE,
	LOADER_ERROR_FILE_ERROR,
	LOADER_ERROR_FILE_FORMAT_NOT_RECOGNIZED,
	LOADER_ERROR_HEADER_CORRUPT
};


/**
  *@author Juan Linietsky
  */

#define ITENVCNT 25
#define ITNOTECNT 120

class Loader_IT {

	File_Reader file_read;

	struct IT_Header {
		char    identifier[5]; // 4 bytes;
		char	songname[27]; // 26 bytes
		Uint8	blank01[2];
		Uint16	ordnum;
		Uint16	insnum;
		Uint16	smpnum;
		Uint16	patnum;
		Uint16	cwt;		/* Created with tracker (y.xx = 0x0yxx) */
		Uint16	cmwt;		/* Compatible with tracker ver > than val. */
		Uint16	flags;
		Uint16	special;	/* bit 0 set = song message attached */
		Uint8	globvol;
		Uint8	mixvol;		/* mixing volume [ignored] */
		Uint8	initspeed;
		Uint8	inittempo;
		Uint8	pansep;		/* panning separation between channels */
		Uint8	zerobyte;
		Uint16	msglength;
		Uint32	msgoffset;
		Uint8	blank02[4];
		Uint8	pantable[64];
		Uint8	voltable[64];
	
	};

	struct IT_Sample {
		char	header[5];
		char	filename[13];
		Uint8	zerobyte;
		Uint8	globvol;
		Uint8	flag;
		Uint8	volume;
		Uint8	panning;
		char	sampname[29];
		Uint8	convert;	/* sample conversion flag */
		Uint32	length;
		Uint32	loopbeg;
		Uint32	loopend;
		Uint32	c5spd;
		Uint32	susbegin;
		Uint32	susend;
		Uint32	sampoffset;
		Uint8	vibspeed;
		Uint8	vibdepth;
		Uint8	vibrate;
		Uint8	vibwave;	/* 0=sine, 1=rampdown, 2=square, 3=random (speed ignored) */

		/* pointer to sampledata! */

		void *sample_data;
	};

	struct IT_Instrument {
		char	header[5];
		Uint32	size;			/* (dword) Instrument size */
		char	filename[13];	/* (char) Instrument filename */
		Uint8	zerobyte;		/* (byte) Instrument type (always 0) */
		Uint8	volflg;
		Uint8	volpts;
		Uint8	volbeg;			/* (byte) Volume loop start (node) */
		Uint8	volend;			/* (byte) Volume loop end (node) */
		Uint8	volsusbeg;		/* (byte) Volume sustain begin (node) */
		Uint8	volsusend;		/* (byte) Volume Sustain end (node) */
		Uint8	panflg;
		Uint8	panpts;
		Uint8	panbeg;			/* (byte) channel loop start (node) */
		Uint8	panend;			/* (byte) channel loop end (node) */
		Uint8	pansusbeg;		/* (byte) channel sustain begin (node) */
		Uint8	pansusend;		/* (byte) channel Sustain end (node) */
		Uint8	pitflg;
		Uint8	pitpts;
		Uint8	pitbeg;			/* (byte) pitch loop start (node) */
		Uint8	pitend;			/* (byte) pitch loop end (node) */
		Uint8	pitsusbeg;		/* (byte) pitch sustain begin (node) */
		Uint8	pitsusend;		/* (byte) pitch Sustain end (node) */
		Uint16	blank;
		Uint8	globvol;
		Uint8	chanpan;
		Uint16	fadeout;		/* Envelope end / NNA volume fadeout */
		Uint8	dnc;			/* Duplicate note check */
		Uint8	dca;			/* Duplicate check action */
		Uint8	dct;			/* Duplicate check type */
		Uint8	nna;			/* New Note Action [0,1,2,3] */
                Uint8	IFC;
		Uint8	IFR;
		Uint8	midichan;
		Uint8	midiprog;
		Uint16	midibank;

		Uint16	trkvers;		/* tracker version used to save [files only] */
		Uint8	ppsep;			/* Pitch-pan Separation */
		Uint8	ppcenter;		/* Pitch-pan Center */
		Uint8	rvolvar;		/* random volume varations */
		Uint8	rpanvar;		/* random panning varations */
		Uint16	numsmp;			/* Number of samples in instrument [files only] */
		char	name[27];		/* Instrument name */
		Uint8	blank01[4];
		Uint16	samptable[ITNOTECNT];/* sample for each note [note / samp pairs] */
		Uint8	volenv[200];	     /* volume envelope (IT 1.x stuff) */
		Uint8	oldvoltick[ITENVCNT];/* volume tick position (IT 1.x stuff) */
		Uint8	volnode[ITENVCNT];   /* amplitude of volume nodes */
		Uint16	voltick[ITENVCNT];   /* tick value of volume nodes */
		Uint8	pannode[ITENVCNT];   /* panenv - node points */
		Uint16	pantick[ITENVCNT];   /* tick value of panning nodes */
		Uint8	pitnode[ITENVCNT];   /* pitchenv - node points */
		Uint16	pittick[ITENVCNT];   /* tick value of pitch nodes */

	};

	

	struct IT_Note {
	
		Uint8 note,ins,volpan,cmd,inf;
	};

	static const char * IT_Version[];


	IT_Header header;
	IT_Sample **sample;
	IT_Instrument **instrument;
	Pattern **pattern;
	int sample_count;
	int instrument_count;
	int pattern_count;

	/* IT sample decompression helper functions */

        Uint32 *source_buffer; 	/* source buffer */
	Uint32 *source_position; 		/* actual reading position */
	Uint8 source_remaining_bits;		/* bits remaining in read dword */

	Uint32 read_n_bits_from_IT_compressed_block(Uint8 p_bits_to_read);
	int read_IT_compressed_block ();
	void free_IT_compressed_block ();
	int load_sample_8bits_IT_compressed(void *p_dest_buffer,int p_buffsize);
	int load_sample_16bits_IT_compressed(void *p_dest_buffer,int p_buffsize);

	/* end of IT sample decompression functions */
	int load_samples();
	int load_sampledata();
	int load_instruments();
	int load_patterns();

	void clear_structs(bool p_clear_shared_data);

	//overrided virtual functions
	int load_header();
	int load_body();
	int transfer_data_to_song();
	int end_load();
	//giving up! error loading
	int give_up_and_clear_structs(int p_reason);

	Song *song;
public:

	int import_it(const char *p_filename);
	void link_to_song(Song* p_song) {song=p_song;};
	
	Loader_IT();
	~Loader_IT();
};

#endif
