/***************************************************************************
                          midi_file_export.cpp  -  description
                             -------------------
    begin                : Tue Jan 1 2002
    copyright            : (C) 2002 by red
    email                : red@server
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "midi_file_export.h"

Midi_File_Export::Midi_File_Export(){

	midiout.AddDevice(&mididevice);
	player.set_midiout(&midiout);
}

void Midi_File_Export::export_midi(Song *p_song,string p_filename) {

	int count=0;
	bool exit=false;
	player.set_song(p_song);
	mididevice.open_file(p_filename);
	
	mididevice.set_current_time_offset(count);
	player.reset();
	player.play(Player::PLAY_SONG);					

	do {
		
		player.update_timer(count);			
		count++;
		mididevice.set_current_time_offset(count);
	        exit=player.finished_playing();
	
	} while(!exit);
	
	player.stop();
	mididevice.close_file();
}

Midi_File_Export::~Midi_File_Export(){



}
