/***************************************************************************
                          track.cpp  -  description
                             -------------------
    begin                : Wed Sep 27 2000
    copyright            : (C) 2000 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "track.h"

Track::Track(Pattern_Data *p_pattern_data) {

	pattern_data=p_pattern_data;

	int i;
	
	pattern.resize(pattern_data->size());

        for (i=0;i<pattern_data->size();i++) {		

		pattern[i] = new Pattern;
	}

	columns=1;

	adjust_pattern_data();
}


void Track::add_column() {

	columns++;
	adjust_pattern_data();
}

void Track::delete_column() {

	if (columns==0 ) return;
        columns--;
	adjust_pattern_data();
}
void Track::set_width(int p_width) {

	if (p_width<=0) return;

	columns=p_width;
	adjust_pattern_data();
}

int Track::get_width() {

 	return columns;
}
void Track::adjust_pattern_data() {

	unsigned int i;

        for (i=0;i<pattern_data->size();i++) {		

		pattern[i]->set_width(columns);
		pattern[i]->set_length((*pattern_data)[i].rowlength);

	}

}

Pattern* Track::get_pattern(int p_pattern) {

	if ((p_pattern<0) || (p_pattern>=pattern.size())) {

		ERROR("Request for invalid pattern!" << p_pattern);
		return pattern[0];
	}

	return pattern[p_pattern];
}
Track::~Track(){

	int i;

	for(i=0;i<pattern.size();i++) delete pattern[i];
}

