/***************************************************************************
                          player_data.h  -  description
                             -------------------
    begin                : Sun Sep 16 2001
    copyright            : (C) 2001 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PLAYER_DATA_H
#define PLAYER_DATA_H


#include "song.h"

/**
  *@author Juan Sebastian Linietsky
  */

struct Player_Data {

	Song *song;

	struct Play_Position {

		int order;
		int pattern;
		int row;

	} position;

	struct Play_Parameters {

		int tempo;
		int rpq;
		double real_increment;
		double next_row_msecs;
                long msecs_elapsed;
		int processing_offset;

		void calculate_real_increment() {

			real_increment=60000.0/((double)rpq*(double)tempo); // calculates how many rows will be read in a minute
		}

		Play_Parameters() {

			tempo=150;
			rpq=4;
			msecs_elapsed=0;
			calculate_real_increment();
			next_row_msecs=0;
		}

	} variables;

	struct Player_Mode {

//		int latency; // latency of the player in milliseconds
		char mode;
		int queue_preprocess_latency;

	} parameters;

	struct Tmp_Data {

		int event_delay;
		int row_delay;

	} tmp;

	int get_pitch_from_note(char p_note_diff,int p_bender_sens);

	Player_Data();
	~Player_Data();
};

#endif
