/***************************************************************************
    smb4kauthinfo.h  -  This class provides a container for the 
    authentication data that is passed and taken by the password reader.
                             -------------------
    begin                : Sa Feb 28 2004
    copyright            : (C) 2004 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SMB4KAUTHINFO_H
#define SMB4KAUTHINFO_H

// Qt includes
#include <qstring.h>

/**
 * This class provides a container for the authentication info that
 * is passed and taken by the password reader.
 * @author Alexander Reinholdt
 */

 
class Smb4KAuthInfo
{
  public:
    /**
     * The constructor.
     *
     * @param workgroup The workgroup of the share the auth info is for.
     *
     * @param hosts     The host's name
     *
     * @param share     The share's name
     *
     * @param user      The username that's used for authentication. Default is QString::null.
     *
     * @param password  The password that's used for authentication. Default is QString::null.
     */
    Smb4KAuthInfo( const QString &workgroup, const QString &host, const QString &share, const QString &user = QString::null, const QString &password = QString::null );
    /**
     * The empty constructor.
     */
    Smb4KAuthInfo() {}
    /**
     * The copy constructor.
     */
    Smb4KAuthInfo( const Smb4KAuthInfo &info );
    /**
     * The destructor
     */
    ~Smb4KAuthInfo();
    /**
     * Returns the name of the workgroup.
     */
    QString workgroup() const { return m_workgroup; }
    /**
     * Returns the name of the workgroup.
     */
    QString host() const { return m_host; }
    /**
     * Returns the name of the share.
     */
    QString share() const { return m_share; }
    /**
     * Returns the user's name.
     */
    QString user() const { return m_user; }
    /**
     * Returns the password like the user provided it. This might cause 
     * problems with shell commands, so only use this if you want to 
     * store the password or for the askpass dialog.
     */
    QString password() const { return m_password; }
    /**
     * Sets the user name.
     */
    void setUser( const QString &user );
    /**
     * Sets the password.
     */
    void setPassword( const QString &passwd );
    /**
     * Sets the share name.
     */
    void setShare( const QString &share );
    
  private:
    /**
     * The workgroup object.
     */
    QString m_workgroup;
    /**
     * The host object.
     */
    QString m_host;
    /**
     * The share object.
     */
    QString m_share;
    /**
     * The user name for this share.
     */
    QString m_user;
    /**
     * The password object for this share.
     */
    QString m_password;
    
};

#endif
