/***************************************************************************
    smb4kappearance.h  -  description
                             -------------------
    begin                : Di Okt 28 2003
    copyright            : (C) 2003 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SMB4KAPPEARANCEOPTIONS_H
#define SMB4KAPPEARANCEOPTIONS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qwidget.h>
#include <qradiobutton.h>
#include <qcheckbox.h>

class Smb4KAppearanceOptions : public QWidget
{
  Q_OBJECT
  
  friend class Smb4KOptionsDlg;
  
  public:
    /**
     * The constructor
     */
    Smb4KAppearanceOptions( QWidget *parent = 0, const char *name = 0 );
    /**
     * The destructor
     */
    ~Smb4KAppearanceOptions();

  private:
    /**
     * The checkbox for the appearance of the share view.
     */
    QCheckBox *m_shareview;
    /**
     * Checkbox for the description of the share.
     */
    QCheckBox *m_description;
    /**
     * This checkbox determines, whether externally mounted shares
     * are to be displayed.
     */
    QCheckBox *m_external;
    /**
     * Show hidden shares.
     */
    QCheckBox *m_showHidden;
    /**
     * Show IPC shares.
     */
    QCheckBox *m_showIPC;
    /**
     * Show ADMIN shares.
     */
    QCheckBox *m_showAdmin;
    /**
     * Show type of share.
     */
    QCheckBox *m_showType;
    /**
     * Show comment of share.
     */
    QCheckBox *m_showComment;
    /**
     * Show printer shares.
     */
    QCheckBox *m_showPrinter;
    /**
     * Show the IP address of the host.
     */
    QCheckBox *m_showIP;
  
};
#endif
