/* SNAC
 * Copyright (C) 1999 the Free Software Foundation
 * Authors : Matias Mutchinick          
 *         
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */



#include <gnome.h>
#include "ag_defs.h"
#include "hstack.h"
#include "ag_text.h"
#include "ag_status.h"
#include "errorstring.h"


extern GtkWidget  *input_text;
extern AgError     errState;


/* input_text, errState */


/*
 * ag_input_text_rewrite_char
 * @pos:     position on the text
 * rewrites the character at @pos with out the cursor,
 * but it does write the error hilight if needed.
 * sets the text point to @pos.
 */
void
ag_input_text_rewrite_char(gint pos)
{
	gchar *c;
	
	c = gtk_editable_get_chars(GTK_EDITABLE(input_text),pos,pos+1);
	
	gtk_text_set_point(GTK_TEXT(input_text),pos);
	gtk_text_forward_delete(GTK_TEXT(input_text),1);
	
	/* Error hilighted text, is rewritten hilighted */
	if(errState.state != 0 &&
	   pos >= errState.start && 
	   pos < errState.end)
		ag_text_insert_error(GTK_TEXT(input_text),c,1);
	else 
		ag_text_insert(GTK_TEXT(input_text),c,1);
	
	g_free(c);
	gtk_text_set_point(GTK_TEXT(input_text),pos);
}




/*
 * ag_input_text_rewrite_cursor
 * rewrites the character at pos, with the cursor
 * over it, it also sets the text point to pos.
 */
void
ag_input_text_rewrite_cursor(gint pos)
{
	gchar *c;
	
	c = gtk_editable_get_chars(GTK_EDITABLE(input_text),pos,pos+1);
	
	gtk_text_set_point(GTK_TEXT(input_text),pos);
	gtk_text_forward_delete(GTK_TEXT(input_text),1);
	ag_text_insert_cursor(GTK_TEXT(input_text),c);
	
	g_free(c);    
	
	/* Now, we set the new input_text insertion point */
	gtk_text_set_point(GTK_TEXT(input_text),pos);
}



/*
 * ag_cursor_move_forward
 * moves the cursor one character ahead.
 */
void
ag_cursor_move_forward()
{
	gint   pos;
	gint   expr_len; 
	
	pos = gtk_text_get_point(GTK_TEXT(input_text));
	expr_len = gtk_text_get_length(GTK_TEXT(input_text))-1;
	
	if (pos < expr_len) {
		ag_input_text_rewrite_char(pos);		
		ag_input_text_rewrite_cursor(pos+1);
	}
}




/*
 * ag_cursor_move_backward
 * moves the cursor one character back.
 */
void
ag_cursor_move_backward()
{
	gint   pos;
	gint   expr_len; 	

	pos = gtk_text_get_point(GTK_TEXT(input_text));
	expr_len = gtk_text_get_length(GTK_TEXT(input_text));
	
	if (pos > 0) {
		if (pos < expr_len) ag_input_text_rewrite_char(pos);
		ag_input_text_rewrite_cursor(pos-1);
	}
}

