/* Somaplayer - Copyright (C) 2003-5 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifndef ADMIN_H
#define ADMIN_H

#define ADMIN_PORT 12421
#define ADMIN_LISTEN 5

#define SOCKET_UNIX 0
#define SOCKET_TCP 1

struct admin_funcs
{
  char *text;
  void (*func) (char *, int);
};

admin_data *admin_parameter (char *);
int admin_start (void);

/* funcs */
void admin_next (char *, int);
void admin_prev (char *, int);
void admin_pause (char *, int);
void admin_quit (char *, int);
void admin_set_volume (char *, int);
void admin_get_volume (char *, int);
void admin_set_balance (char *, int);
void admin_get_balance (char *, int);
void admin_this (char *, int);
void admin_get_playlist (char *, int);
void admin_add_playlist (char *, int);
void admin_del_playlist (char *, int);
void admin_move_playlist (char *, int);
void admin_play_playlist (char *, int);

#endif

/* EOF */
