/* Somaplayer - Copyright (C) 2003-5 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#ifdef ENABLE_LAME

#include "../player.h"
#include "../audio.h"
#include "../output.h"
#include "../other.h"
#include "../output/lame/lame.h"
#include "../output/lame/fconfig.h"
#include "graphic.h"

void
on_lame_new_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  GtkWidget *dialog;
  GtkWidget *box;
  GtkWidget *table;
  GtkWidget *stock;
  GtkWidget *label;

  GtkWidget *rate;
  GtkAdjustment *quality_adj;
  GtkWidget *quality;
  GtkWidget *bitrate;
  GtkWidget *channels;
  GtkWidget *lowpass;
  GtkWidget *highpass;
  GtkWidget *file;

  audio *tmp;

  int ret;

  dialog =
    gtk_dialog_new_with_buttons (_("SomaPlayer - mp3 configuration"),
				 GTK_WINDOW (winmain),
				 GTK_DIALOG_MODAL |
				 GTK_DIALOG_DESTROY_WITH_PARENT,
				 GTK_STOCK_OPEN, 100,
				 GTK_STOCK_SAVE, 200,
				 GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
				 GTK_STOCK_OK, GTK_RESPONSE_OK, NULL);

  box = gtk_hbox_new (FALSE, 8);
  gtk_container_set_border_width (GTK_CONTAINER (box), 8);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), box, FALSE, FALSE,
		      0);

  stock =
    gtk_image_new_from_stock (GTK_STOCK_DIALOG_QUESTION,
			      GTK_ICON_SIZE_DIALOG);
  gtk_box_pack_start (GTK_BOX (box), stock, FALSE, FALSE, 0);

  table = gtk_table_new (0, 0, FALSE);
  gtk_table_set_row_spacings (GTK_TABLE (table), 4);
  gtk_table_set_col_spacings (GTK_TABLE (table), 4);
  gtk_box_pack_start (GTK_BOX (box), table, TRUE, TRUE, 0);

  label = gtk_label_new_with_mnemonic (_("Rate:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 0, 1);
  rate = gtk_entry_new ();
  gtk_table_attach_defaults (GTK_TABLE (table), rate, 1, 2, 0, 1);

  label = gtk_label_new_with_mnemonic (_("Quality:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 1, 2);
  quality_adj = (GtkAdjustment *) gtk_adjustment_new (8, 1, 10, 1, 1, 1);
  quality = gtk_spin_button_new (GTK_ADJUSTMENT (quality_adj), 1, 0);
  gtk_table_attach_defaults (GTK_TABLE (table), quality, 1, 2, 1, 2);

  label = gtk_label_new_with_mnemonic (_("Bitrate:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 2, 3);
  bitrate = gtk_entry_new ();
  gtk_table_attach_defaults (GTK_TABLE (table), bitrate, 1, 2, 2, 3);

  label = gtk_label_new_with_mnemonic (_("Channels:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 3, 4);
  channels = gtk_combo_box_new_text ();
  gtk_combo_box_append_text (GTK_COMBO_BOX (channels), "MONO");
  gtk_combo_box_append_text (GTK_COMBO_BOX (channels), "STEREO");
  gtk_table_attach_defaults (GTK_TABLE (table), channels, 1, 2, 3, 4);

  label = gtk_label_new_with_mnemonic (_("LowPass:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 4, 5);
  lowpass = gtk_entry_new ();
  gtk_table_attach_defaults (GTK_TABLE (table), lowpass, 1, 2, 4, 5);

  label = gtk_label_new_with_mnemonic (_("HighPass:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 5, 6);
  highpass = gtk_entry_new ();
  gtk_table_attach_defaults (GTK_TABLE (table), highpass, 1, 2, 5, 6);

  label = gtk_label_new_with_mnemonic (_("File Output:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 6, 7);
  file = gtk_entry_new ();
  gtk_table_attach_defaults (GTK_TABLE (table), file, 1, 2, 6, 7);

  gtk_entry_set_text (GTK_ENTRY (rate), "44100");
  gtk_entry_set_text (GTK_ENTRY (bitrate), "96");
  gtk_combo_box_set_active (GTK_COMBO_BOX (channels), 1);
  gtk_entry_set_text (GTK_ENTRY (lowpass), "0");
  gtk_entry_set_text (GTK_ENTRY (highpass), "0");
  gtk_entry_set_text (GTK_ENTRY (file), _("output.mp3"));

  gtk_widget_show_all (box);

  while (1)
    {

      ret = gtk_dialog_run (GTK_DIALOG (dialog));

      /* Oky... */
      if (ret == GTK_RESPONSE_OK)
	{
	  audio_data_lame *l;

	  if (!strlen (gtk_entry_get_text (GTK_ENTRY (file))))
	    {
	      dialog_msg (_("No file?"));
	      continue;
	    }

	  if (!(l = (audio_data_lame *) malloc (sizeof (audio_data_lame))))
	    fatal (_("Error: memory."));

	  l->rate = atoi (gtk_entry_get_text (GTK_ENTRY (rate)));
	  l->quality =
	    (int) gtk_spin_button_get_value (GTK_SPIN_BUTTON (quality));
	  l->bitrate = atoi (gtk_entry_get_text (GTK_ENTRY (bitrate)));

	  if (!gtk_combo_box_get_active (GTK_COMBO_BOX (channels)))
	    l->channels = 1;
	  else
	    l->channels = 2;

	  l->lowpass = atoi (gtk_entry_get_text (GTK_ENTRY (lowpass)));
	  l->highpass = atoi (gtk_entry_get_text (GTK_ENTRY (highpass)));
	  if (!(l->file = strdup (gtk_entry_get_text (GTK_ENTRY (file)))))
	    fatal (_("Error: memory."));

	  if (!(tmp = (audio *) malloc (sizeof (audio))))
	    fatal (_("Error: memory."));

	  tmp->audio_type = USE_LAME;

	  tmp->realtime = 0;

	  tmp->open = lame_start;
	  tmp->write = lame_pre_write;
	  tmp->close = lame_pre_close;
	  tmp->update = NULL;
	  tmp->check = NULL;
	  tmp->info = lame_info;
	  tmp->data = (void *) l;
	  tmp->next = NULL;
	  tmp->status = OUTPUT_DONE;
	  tmp->audio_dev = NULL;

	  tmp->stop = 0;

	  if (pthread_cond_init (&tmp->cond, NULL))
	    fatal (_("Error: Cond init."));
	  if (pthread_mutex_init (&tmp->mutex, NULL))
	    fatal (_("Error: Mutex init."));
	  if (pthread_create (&tmp->th, NULL, output_thread, tmp))
	    fatal (_("Thread error."));

	  if (play->ao_rate && play->ao_channels && play->ao_bitrate)
	    {
	      if (tmp->
		  open (tmp, play->ao_rate, play->ao_channels,
			play->ao_bitrate))
		{
		  free (tmp->audio_dev);
		  free (tmp);
		}
	      else
		{

		  tmp->info (tmp);

		  output_lock ();

		  tmp->next = play->output;
		  play->output = tmp;

		  output_unlock ();

		  output_list_add (tmp, PREPEND);
		}
	    }
	  else
	    {
	      output_lock ();

	      tmp->next = play->output;
	      play->output = tmp;

	      output_unlock ();

	      output_list_add (tmp, PREPEND);
	    }
	  break;
	}

      /* Open button */
      else if (ret == 100)
	{
	  audio_data_lame *data;

	  char s[1024];
	  char *fl;

	  snprintf (s, 1024, "%s %s - Open mp3 config file...", NAME,
		    VERSION);

	  if ((fl =
	       file_chooser (s, GTK_SELECTION_SINGLE,
			     GTK_FILE_CHOOSER_ACTION_OPEN)))
	    {

	      if (!
		  (data =
		   (audio_data_lame *) malloc (sizeof (audio_data_lame))))
		fatal ("Error: memory.");

	      /* Parse the file and update the item */
	      if (!lame_read_config (fl, data))
		{
		  snprintf (s, 1024, "%d", data->rate);
		  gtk_entry_set_text (GTK_ENTRY (rate), s);

		  snprintf (s, 1024, "%d", data->bitrate);
		  gtk_entry_set_text (GTK_ENTRY (bitrate), s);

		  gtk_spin_button_set_value (GTK_SPIN_BUTTON (quality),
					     (gdouble) data->quality);

		  snprintf (s, 1024, "%d", data->lowpass);
		  gtk_entry_set_text (GTK_ENTRY (lowpass), s);

		  snprintf (s, 1024, "%d", data->highpass);
		  gtk_entry_set_text (GTK_ENTRY (highpass), s);

		  switch (data->channels)
		    {
		    case 1:
		      gtk_combo_box_set_active (GTK_COMBO_BOX (channels), 0);
		      break;
		    case 2:
		      gtk_combo_box_set_active (GTK_COMBO_BOX (channels), 1);
		      break;
		    default:
		      gtk_combo_box_set_active (GTK_COMBO_BOX (channels), 0);
		    }

		  gtk_entry_set_text (GTK_ENTRY (file), data->file);

		  free (data->file);
		}

	      free (fl);

	      free (data);
	    }
	}

      /* Save button */
      else if (ret == 200)
	{
	  char s[1024];
	  char *save;

	  snprintf (s, 1024, "%s %s - Save mp3 config file", NAME, VERSION);

	  if ((save =
	       file_chooser (s, GTK_SELECTION_SINGLE,
			     GTK_FILE_CHOOSER_ACTION_SAVE)))
	    {
	      FILE *fl;

	      if (dialog_test_file (save))
		{
		  free (file);
		  continue;
		}

	      if (!(fl = fopen (save, "w")))
		{
		  msg_error ("I can't open %s", save);
		  free (file);
		  continue;
		}

	      fprintf (fl, "rate = %d\n",
		       atoi (gtk_entry_get_text (GTK_ENTRY (rate))));
	      fprintf (fl, "quality = %d\n",
		       (int)
		       gtk_spin_button_get_value (GTK_SPIN_BUTTON (quality)));
	      fprintf (fl, "bitrate = %d\n",
		       atoi (gtk_entry_get_text (GTK_ENTRY (bitrate))));
	      fprintf (fl, "channels = %d\n",
		       gtk_combo_box_get_active (GTK_COMBO_BOX (channels)) +
		       1);
	      fprintf (fl, "lowpass = %d\n",
		       atoi (gtk_entry_get_text (GTK_ENTRY (lowpass))));
	      fprintf (fl, "highpass = %d\n",
		       atoi (gtk_entry_get_text (GTK_ENTRY (highpass))));
	      fprintf (fl, "file = \"%s\"\n",
		       gtk_entry_get_text (GTK_ENTRY (file)));

	      fclose (fl);

	      dialog_msg (_("Mp3 config saved!"));
	    }
	}

      /* Cancel button */
      else
	{
	  break;
	}

    }

  gtk_widget_destroy (dialog);
}

#endif

/* EOF */
