# $Id: 1-2-x_1-3-0.py,v 1.3 2002/05/09 11:32:56 fresh Exp $
from Products.UpdateSupport.updatesupport import _updateall,_log
from Products.Squishdot.Utility import addDTML, addPythonScript
from Products.Squishdot.Squishfile import Squishfile
from StringIO import StringIO
from string import join
import sys

def do_update(self):
    """ Do the update """
    # rename old showError
    try:
        self.manage_renameObject('showError', 'old_showError')
        thestring = _log('','Renamed showError to old_showError')
    except:
        thestring = _log('','Failed to rename showError to old_showError:\nType:%s'%(sys.exc_type,))

    # add new showError    
    try:
        firstbit = self.old_showError.raw[0:22]
        if firstbit=='<dtml-var site_header>':
            addDTML(self,'showError','Show Error','demo/showError')
        else:
            addDTML(self,'showError','Show Error','showError')     
        thestring = _log(thestring,'Added new showError')
    except:
        thestring = _log(thestring,'Failed to add new showError:\nType:%s'%(sys.exc_type,))

    # add validatePosting script
    try:
        addPythonScript(self,'validatePosting','validatePosting')     
        thestring = _log(thestring,'Added validatePosting')
    except:
        thestring = _log(thestring,'Failed to add validatePosting:\nType:%s'%(sys.exc_type,))

    # fix file attachments
    updated = []
    for posting in self.data.values():
        oldfile = posting.file
        if oldfile!='' and hasattr(oldfile,'_name'):
            s=StringIO(oldfile._file)
            s.filename=oldfile._name
            newfile = Squishfile(s)
            posting.file = newfile
            setattr(posting,newfile.file_name(),newfile)
            updated.append(posting.id)

    thestring = _log(thestring,'Updated the following files:\n%s'%join(updated,'\n'))

    return thestring


def updateall(self):
    return _updateall(self,do_update, metatypes=['Squishdot Site'])




