/*
 * Copyright (c) 2003, 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _ST_BROWSER_TAB_H
#define _ST_BROWSER_TAB_H

#include <gtk/gtk.h>
#include "st-handler.h"
#include "st-thread.h"
#include "st-category-view.h"
#include "st-stream-view.h"

#define ST_TYPE_BROWSER_TAB			(st_browser_tab_get_type())
#define ST_BROWSER_TAB(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), ST_TYPE_BROWSER_TAB, STBrowserTab))
#define ST_BROWSER_TAB_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), ST_TYPE_BROWSER_TAB, STBrowserTabClass))
#define ST_IS_BROWSER_TAB(obj)			(G_TYPE_CHECK_INSTANCE_TYPE((obj), ST_TYPE_BROWSER_TAB))
#define ST_IS_BROWSER_TAB_CLASS(klass)		(G_TYPE_CHECK_CLASS_TYPE((klass), ST_TYPE_BROWSER_TAB))
#define ST_BROWSER_TAB_GET_CLASS(obj)		(G_TYPE_INSTANCE_GET_CLASS((obj), ST_TYPE_BROWSER_TAB, STBrowserTabClass))

typedef struct _STBrowserTabPrivate STBrowserTabPrivate;

typedef struct
{
  GtkHPaned			paned;
  
  STBrowserTabPrivate		*priv;

  STHandler			*handler;

  gboolean			running;

  STCategoryView		*category_view;
  STStreamView			*stream_view;

  GtkWidget			*label;
} STBrowserTab;

typedef enum
{
  ST_BROWSER_TAB_STREAM_TASK_TUNE_IN,
  ST_BROWSER_TAB_STREAM_TASK_RECORD,
  ST_BROWSER_TAB_STREAM_TASK_BROWSE,
  ST_BROWSER_TAB_STREAM_TASK_ADD_BOOKMARKS
} STBrowserTabStreamTaskType;

typedef struct
{
  STBrowserTab			*tab;
  STBrowserTabStreamTaskType	type;
  GSList			*streams;
  GSList			*running_reffed_streams;
  STThread			*thread;
} STBrowserTabStreamTask;

typedef struct
{
  GtkHPanedClass		parent_class;

  /* signals */
  void (*stream_task_added) (STBrowserTab *tab, STBrowserTabStreamTask *task);
  void (*stream_task_removed) (STBrowserTab *tab, STBrowserTabStreamTask *task);
} STBrowserTabClass;

GType		st_browser_tab_get_type		(void);
GtkWidget	*st_browser_tab_new		(STHandler	*handler);

void		st_browser_tab_update_sensitivity (STBrowserTab	*tab);

gboolean	st_browser_tab_can_reload	(STBrowserTab	*tab);
void		st_browser_tab_reload		(STBrowserTab	*tab);
void		st_browser_tab_update		(STBrowserTab	*tab);
gboolean	st_browser_tab_can_stop		(STBrowserTab	*tab);
void		st_browser_tab_stop		(STBrowserTab	*tab);
gboolean	st_browser_tab_can_visit_homepage	(STBrowserTab	*tab);
void		st_browser_tab_visit_homepage		(STBrowserTab	*tab);
gboolean	st_browser_tab_can_present_preferences	(STBrowserTab	*tab);
void		st_browser_tab_present_preferences	(STBrowserTab	*tab);
gboolean	st_browser_tab_can_run_stream_task	(STBrowserTab	*tab,
							 STBrowserTabStreamTaskType type);
void		st_browser_tab_run_stream_task		(STBrowserTab	*tab,
							 STBrowserTabStreamTaskType type);

#endif /* _ST_BROWSER_TAB_H */
