/* meminfo.c, copyright Neven Lovric <nlovric@linux.hr> */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <limits.h>
#include <string.h>
#include <stdlib.h>
#include <sys/mman.h>
#include "meminfo.h"

unsigned long freemem(int fd)
{
   unsigned long mem, swap;
   char buf[1024];

   if (lseek(fd, 0, SEEK_SET) != 0)
      return(UINT_MAX);
   if (read(fd, buf, 1024) == -1)
      return(UINT_MAX);
   if (sscanf(buf, "%*s%*s%*s%*s%*s%*s%*s%*s%*s%lu%*s%*s%*s%*s%*s%*s%lu", &mem, &swap) != 2)
      return(UINT_MAX);
   return(mem + swap);
}
