/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import java.util.Hashtable;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleObject;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.accessibility.gtk.ATK;
import org.eclipse.swt.internal.accessibility.gtk.AtkActionIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkComponentIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkHypertextIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkObjectClass;
import org.eclipse.swt.internal.accessibility.gtk.AtkObjectFactoryClass;
import org.eclipse.swt.internal.accessibility.gtk.AtkSelectionIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkTextIface;
import org.eclipse.swt.internal.accessibility.gtk.GInterfaceInfo;
import org.eclipse.swt.internal.accessibility.gtk.GObjectClass;
import org.eclipse.swt.internal.accessibility.gtk.GTypeInfo;
import org.eclipse.swt.internal.accessibility.gtk.GTypeQuery;
import org.eclipse.swt.internal.gtk.LONG;
import org.eclipse.swt.internal.gtk.OS;

class AccessibleFactory {
    int handle;
    int objectParentType;
    int widgetTypeName;
    Callback atkObjectFactoryCB_create_accessible;
    Callback gTypeInfo_base_init_factory;
    Hashtable accessibles = new Hashtable(9);
    static final Hashtable Types = new Hashtable(9);
    static final Hashtable Factories = new Hashtable(9);
    static final int DefaultParentType = ATK.g_type_from_name((byte[])Converter.wcsToMbcs(null, "GtkAccessible", true));
    static final byte[] FACTORY_PARENTTYPENAME = Converter.wcsToMbcs(null, "AtkObjectFactory", true);
    static final byte[] SWT_TYPE_PREFIX = Converter.wcsToMbcs(null, "SWT", false);
    static final byte[] CHILD_TYPENAME = Converter.wcsToMbcs(null, "Child", false);
    static final byte[] FACTORY_TYPENAME = Converter.wcsToMbcs(null, "SWTFactory", true);
    static final int[] actionRoles = new int[]{44, 46, 30, 12, 43, 45};
    static final int[] hypertextRoles = new int[]{30};
    static final int[] selectionRoles = new int[]{33, 60, 24, 35};
    static final int[] textRoles = new int[]{46, 30, 41, 42};
    static final Callback AtkActionCB_get_keybinding;
    static final Callback AtkActionCB_get_name;
    static final Callback AtkComponentCB_get_extents;
    static final Callback AtkComponentCB_get_position;
    static final Callback AtkComponentCB_get_size;
    static final Callback AtkComponentCB_ref_accessible_at_point;
    static final Callback AtkHypertextCB_get_link;
    static final Callback AtkHypertextCB_get_n_links;
    static final Callback AtkHypertextCB_get_link_index;
    static final Callback AtkObjectCB_get_description;
    static final Callback AtkObjectCB_get_index_in_parent;
    static final Callback AtkObjectCB_get_n_children;
    static final Callback AtkObjectCB_get_name;
    static final Callback AtkObjectCB_get_parent;
    static final Callback AtkObjectCB_get_role;
    static final Callback AtkObjectCB_ref_child;
    static final Callback AtkObjectCB_ref_state_set;
    static final Callback AtkSelectionCB_is_child_selected;
    static final Callback AtkSelectionCB_ref_selection;
    static final Callback AtkTextCB_get_caret_offset;
    static final Callback AtkTextCB_get_n_selections;
    static final Callback AtkTextCB_get_selection;
    static final Callback AtkTextCB_get_text;
    static final Callback AtkTextCB_get_text_after_offset;
    static final Callback AtkTextCB_get_text_at_offset;
    static final Callback AtkTextCB_get_text_before_offset;
    static final Callback AtkTextCB_get_character_at_offset;
    static final Callback AtkTextCB_get_character_count;
    static final Callback GObjectClass_finalize;
    static final Callback InitActionIfaceCB;
    static final Callback InitComponentIfaceCB;
    static final Callback InitHypertextIfaceCB;
    static final Callback GTypeInfo_base_init_type;
    static final Callback InitSelectionIfaceCB;
    static final Callback InitTextIfaceCB;
    static int ObjectIfaceDefinition;
    static final int ActionIfaceDefinition;
    static final int ComponentIfaceDefinition;
    static final int HypertextIfaceDefinition;
    static final int SelectionIfaceDefinition;
    static final int TextIfaceDefinition;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkActionCB_get_keybinding = new Callback(clazz, "atkAction_get_keybinding", 2);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkActionCB_get_name = new Callback(clazz2, "atkAction_get_name", 2);
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkComponentCB_get_extents = new Callback(clazz3, "atkComponent_get_extents", 6);
        Class<?> clazz4 = class$0;
        if (clazz4 == null) {
            try {
                clazz4 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkComponentCB_get_position = new Callback(clazz4, "atkComponent_get_position", 4);
        Class<?> clazz5 = class$0;
        if (clazz5 == null) {
            try {
                clazz5 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkComponentCB_get_size = new Callback(clazz5, "atkComponent_get_size", 4);
        Class<?> clazz6 = class$0;
        if (clazz6 == null) {
            try {
                clazz6 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkComponentCB_ref_accessible_at_point = new Callback(clazz6, "atkComponent_ref_accessible_at_point", 4);
        Class<?> clazz7 = class$0;
        if (clazz7 == null) {
            try {
                clazz7 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkHypertextCB_get_link = new Callback(clazz7, "atkHypertext_get_link", 2);
        Class<?> clazz8 = class$0;
        if (clazz8 == null) {
            try {
                clazz8 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkHypertextCB_get_n_links = new Callback(clazz8, "atkHypertext_get_n_links", 1);
        Class<?> clazz9 = class$0;
        if (clazz9 == null) {
            try {
                clazz9 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkHypertextCB_get_link_index = new Callback(clazz9, "atkHypertext_get_link_index", 2);
        Class<?> clazz10 = class$0;
        if (clazz10 == null) {
            try {
                clazz10 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkObjectCB_get_name = new Callback(clazz10, "atkObject_get_name", 1);
        Class<?> clazz11 = class$0;
        if (clazz11 == null) {
            try {
                clazz11 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkObjectCB_get_description = new Callback(clazz11, "atkObject_get_description", 1);
        Class<?> clazz12 = class$0;
        if (clazz12 == null) {
            try {
                clazz12 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkObjectCB_get_n_children = new Callback(clazz12, "atkObject_get_n_children", 1);
        Class<?> clazz13 = class$0;
        if (clazz13 == null) {
            try {
                clazz13 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkObjectCB_get_role = new Callback(clazz13, "atkObject_get_role", 1);
        Class<?> clazz14 = class$0;
        if (clazz14 == null) {
            try {
                clazz14 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkObjectCB_get_parent = new Callback(clazz14, "atkObject_get_parent", 1);
        Class<?> clazz15 = class$0;
        if (clazz15 == null) {
            try {
                clazz15 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkObjectCB_ref_state_set = new Callback(clazz15, "atkObject_ref_state_set", 1);
        Class<?> clazz16 = class$0;
        if (clazz16 == null) {
            try {
                clazz16 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkObjectCB_get_index_in_parent = new Callback(clazz16, "atkObject_get_index_in_parent", 1);
        Class<?> clazz17 = class$0;
        if (clazz17 == null) {
            try {
                clazz17 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkObjectCB_ref_child = new Callback(clazz17, "atkObject_ref_child", 2);
        Class<?> clazz18 = class$0;
        if (clazz18 == null) {
            try {
                clazz18 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkSelectionCB_is_child_selected = new Callback(clazz18, "atkSelection_is_child_selected", 2);
        Class<?> clazz19 = class$0;
        if (clazz19 == null) {
            try {
                clazz19 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkSelectionCB_ref_selection = new Callback(clazz19, "atkSelection_ref_selection", 2);
        Class<?> clazz20 = class$0;
        if (clazz20 == null) {
            try {
                clazz20 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkTextCB_get_caret_offset = new Callback(clazz20, "atkText_get_caret_offset", 1);
        Class<?> clazz21 = class$0;
        if (clazz21 == null) {
            try {
                clazz21 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkTextCB_get_n_selections = new Callback(clazz21, "atkText_get_n_selections", 1);
        Class<?> clazz22 = class$0;
        if (clazz22 == null) {
            try {
                clazz22 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkTextCB_get_selection = new Callback(clazz22, "atkText_get_selection", 4);
        Class<?> clazz23 = class$0;
        if (clazz23 == null) {
            try {
                clazz23 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkTextCB_get_text = new Callback(clazz23, "atkText_get_text", 3);
        Class<?> clazz24 = class$0;
        if (clazz24 == null) {
            try {
                clazz24 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkTextCB_get_text_after_offset = new Callback(clazz24, "atkText_get_text_after_offset", 5);
        Class<?> clazz25 = class$0;
        if (clazz25 == null) {
            try {
                clazz25 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkTextCB_get_text_at_offset = new Callback(clazz25, "atkText_get_text_at_offset", 5);
        Class<?> clazz26 = class$0;
        if (clazz26 == null) {
            try {
                clazz26 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkTextCB_get_text_before_offset = new Callback(clazz26, "atkText_get_text_before_offset", 5);
        Class<?> clazz27 = class$0;
        if (clazz27 == null) {
            try {
                clazz27 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkTextCB_get_character_at_offset = new Callback(clazz27, "atkText_get_character_at_offset", 2);
        Class<?> clazz28 = class$0;
        if (clazz28 == null) {
            try {
                clazz28 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AtkTextCB_get_character_count = new Callback(clazz28, "atkText_get_character_count", 1);
        Class<?> clazz29 = class$0;
        if (clazz29 == null) {
            try {
                clazz29 = class$0 = Class.forName("org.eclipse.swt.accessibility.AccessibleObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        GObjectClass_finalize = new Callback(clazz29, "gObjectClass_finalize", 1);
        Class<?> clazz30 = class$1;
        if (clazz30 == null) {
            try {
                clazz30 = class$1 = Class.forName("org.eclipse.swt.accessibility.AccessibleFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        GTypeInfo_base_init_type = new Callback(clazz30, "gTypeInfo_base_init_type", 1);
        Class<?> clazz31 = class$1;
        if (clazz31 == null) {
            try {
                clazz31 = class$1 = Class.forName("org.eclipse.swt.accessibility.AccessibleFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        InitActionIfaceCB = new Callback(clazz31, "initActionIfaceCB", 1);
        GInterfaceInfo interfaceInfo = new GInterfaceInfo();
        interfaceInfo.interface_init = InitActionIfaceCB.getAddress();
        ActionIfaceDefinition = OS.g_malloc((int)GInterfaceInfo.sizeof);
        ATK.memmove((int)ActionIfaceDefinition, (GInterfaceInfo)interfaceInfo, (int)GInterfaceInfo.sizeof);
        Class<?> clazz32 = class$1;
        if (clazz32 == null) {
            try {
                clazz32 = class$1 = Class.forName("org.eclipse.swt.accessibility.AccessibleFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        InitComponentIfaceCB = new Callback(clazz32, "initComponentIfaceCB", 1);
        interfaceInfo = new GInterfaceInfo();
        interfaceInfo.interface_init = InitComponentIfaceCB.getAddress();
        ComponentIfaceDefinition = OS.g_malloc((int)GInterfaceInfo.sizeof);
        ATK.memmove((int)ComponentIfaceDefinition, (GInterfaceInfo)interfaceInfo, (int)GInterfaceInfo.sizeof);
        Class<?> clazz33 = class$1;
        if (clazz33 == null) {
            try {
                clazz33 = class$1 = Class.forName("org.eclipse.swt.accessibility.AccessibleFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        InitHypertextIfaceCB = new Callback(clazz33, "initHypertextIfaceCB", 1);
        interfaceInfo = new GInterfaceInfo();
        interfaceInfo.interface_init = InitHypertextIfaceCB.getAddress();
        HypertextIfaceDefinition = OS.g_malloc((int)GInterfaceInfo.sizeof);
        ATK.memmove((int)HypertextIfaceDefinition, (GInterfaceInfo)interfaceInfo, (int)GInterfaceInfo.sizeof);
        Class<?> clazz34 = class$1;
        if (clazz34 == null) {
            try {
                clazz34 = class$1 = Class.forName("org.eclipse.swt.accessibility.AccessibleFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        InitSelectionIfaceCB = new Callback(clazz34, "initSelectionIfaceCB", 1);
        interfaceInfo = new GInterfaceInfo();
        interfaceInfo.interface_init = InitSelectionIfaceCB.getAddress();
        SelectionIfaceDefinition = OS.g_malloc((int)GInterfaceInfo.sizeof);
        ATK.memmove((int)SelectionIfaceDefinition, (GInterfaceInfo)interfaceInfo, (int)GInterfaceInfo.sizeof);
        Class<?> clazz35 = class$1;
        if (clazz35 == null) {
            try {
                clazz35 = class$1 = Class.forName("org.eclipse.swt.accessibility.AccessibleFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        InitTextIfaceCB = new Callback(clazz35, "initTextIfaceCB", 1);
        interfaceInfo = new GInterfaceInfo();
        interfaceInfo.interface_init = InitTextIfaceCB.getAddress();
        TextIfaceDefinition = OS.g_malloc((int)GInterfaceInfo.sizeof);
        ATK.memmove((int)TextIfaceDefinition, (GInterfaceInfo)interfaceInfo, (int)GInterfaceInfo.sizeof);
    }

    private AccessibleFactory(int widgetType) {
        if (DefaultParentType == 0) {
            return;
        }
        this.widgetTypeName = ATK.g_type_name((int)widgetType);
        int widgetTypeNameLength = OS.strlen((int)this.widgetTypeName) + 1;
        byte[] buffer = new byte[widgetTypeNameLength];
        OS.memmove((byte[])buffer, (int)this.widgetTypeName, (int)widgetTypeNameLength);
        byte[] factoryName = new byte[FACTORY_TYPENAME.length + widgetTypeNameLength];
        System.arraycopy(FACTORY_TYPENAME, 0, factoryName, 0, FACTORY_TYPENAME.length);
        System.arraycopy(buffer, 0, factoryName, FACTORY_TYPENAME.length, widgetTypeNameLength);
        if (ATK.g_type_from_name((byte[])factoryName) == 0) {
            int registry = ATK.atk_get_default_registry();
            int previousFactory = ATK.atk_registry_get_factory((int)registry, (int)widgetType);
            this.objectParentType = ATK.atk_object_factory_get_accessible_type((int)previousFactory);
            if (this.objectParentType == 0) {
                this.objectParentType = DefaultParentType;
            }
            int factoryParentType = ATK.g_type_from_name((byte[])FACTORY_PARENTTYPENAME);
            this.gTypeInfo_base_init_factory = new Callback(this, "gTypeInfo_base_init_factory", 1);
            GTypeInfo typeInfo = new GTypeInfo();
            typeInfo.base_init = this.gTypeInfo_base_init_factory.getAddress();
            typeInfo.class_size = (short)ATK.AtkObjectFactoryClass_sizeof();
            typeInfo.instance_size = (short)ATK.AtkObjectFactory_sizeof();
            this.handle = OS.g_malloc((int)GTypeInfo.sizeof);
            ATK.memmove((int)this.handle, (GTypeInfo)typeInfo, (int)GTypeInfo.sizeof);
            int swtFactory = ATK.g_type_register_static((int)factoryParentType, (byte[])factoryName, (int)this.handle, (int)0);
            ATK.atk_registry_set_factory_type((int)registry, (int)widgetType, (int)swtFactory);
        }
    }

    void addAccessible(Accessible accessible) {
        int controlHandle = accessible.getControlHandle();
        this.accessibles.put(new LONG(controlHandle), accessible);
    }

    int atkObjectFactory_create_accessible(int widget) {
        AccessibleObject object;
        Accessible accessible = (Accessible)this.accessibles.get(new LONG(widget));
        if (accessible == null) {
            int result = ATK.g_object_new((int)this.objectParentType, (int)0);
            ATK.atk_object_initialize((int)result, (int)widget);
            return result;
        }
        int typeNameLength = OS.strlen((int)this.widgetTypeName);
        byte[] buffer = new byte[typeNameLength];
        OS.memmove((byte[])buffer, (int)this.widgetTypeName, (int)typeNameLength);
        int type = AccessibleFactory.getType(buffer, accessible, this.objectParentType, -1);
        accessible.accessibleObject = object = new AccessibleObject(type, widget, accessible, this.objectParentType, false);
        return object.handle;
    }

    static int getChildType(Accessible accessible, int childIndex) {
        return AccessibleFactory.getType(CHILD_TYPENAME, accessible, DefaultParentType, childIndex);
    }

    static int getDefaultParentType() {
        return DefaultParentType;
    }

    static int getType(byte[] widgetTypeName, Accessible accessible, int parentType, int childId) {
        AccessibleControlEvent event = new AccessibleControlEvent(accessible);
        event.childID = childId;
        AccessibleControlListener[] listeners = accessible.getControlListeners();
        int i = 0;
        while (i < listeners.length) {
            listeners[i].getRole(event);
            ++i;
        }
        boolean action = false;
        boolean hypertext = false;
        boolean selection = false;
        boolean text = false;
        if (event.detail != 0) {
            int i2 = 0;
            while (i2 < actionRoles.length) {
                if (event.detail == actionRoles[i2]) {
                    action = true;
                    break;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < hypertextRoles.length) {
                if (event.detail == hypertextRoles[i2]) {
                    hypertext = true;
                    break;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < selectionRoles.length) {
                if (event.detail == selectionRoles[i2]) {
                    selection = true;
                    break;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < textRoles.length) {
                if (event.detail == textRoles[i2]) {
                    text = true;
                    break;
                }
                ++i2;
            }
        } else {
            text = true;
            selection = true;
            hypertext = true;
            action = true;
        }
        String swtTypeName = new String(SWT_TYPE_PREFIX);
        swtTypeName = String.valueOf(swtTypeName) + new String(widgetTypeName);
        if (action) {
            swtTypeName = String.valueOf(swtTypeName) + "Action";
        }
        if (hypertext) {
            swtTypeName = String.valueOf(swtTypeName) + "Hypertext";
        }
        if (selection) {
            swtTypeName = String.valueOf(swtTypeName) + "Selection";
        }
        if (text) {
            swtTypeName = String.valueOf(swtTypeName) + "Text";
        }
        int type = 0;
        LONG typeInt = (LONG)Types.get(swtTypeName);
        if (typeInt != null) {
            type = typeInt.value;
        } else {
            int queryPtr = OS.g_malloc((int)GTypeQuery.sizeof);
            ATK.g_type_query((int)parentType, (int)queryPtr);
            GTypeQuery query = new GTypeQuery();
            ATK.memmove((GTypeQuery)query, (int)queryPtr, (int)GTypeQuery.sizeof);
            OS.g_free((int)queryPtr);
            GTypeInfo typeInfo = new GTypeInfo();
            typeInfo.base_init = GTypeInfo_base_init_type.getAddress();
            typeInfo.class_size = (short)query.class_size;
            typeInfo.instance_size = (short)query.instance_size;
            ObjectIfaceDefinition = OS.g_malloc((int)GTypeInfo.sizeof);
            ATK.memmove((int)ObjectIfaceDefinition, (GTypeInfo)typeInfo, (int)GTypeInfo.sizeof);
            byte[] nameBytes = new byte[swtTypeName.length() + 1];
            System.arraycopy(swtTypeName.getBytes(), 0, nameBytes, 0, swtTypeName.length());
            type = ATK.g_type_register_static((int)parentType, (byte[])nameBytes, (int)ObjectIfaceDefinition, (int)0);
            ATK.g_type_add_interface_static((int)type, (int)AccessibleObject.ATK_COMPONENT_TYPE, (int)ComponentIfaceDefinition);
            if (action) {
                ATK.g_type_add_interface_static((int)type, (int)AccessibleObject.ATK_ACTION_TYPE, (int)ActionIfaceDefinition);
            }
            if (hypertext) {
                ATK.g_type_add_interface_static((int)type, (int)AccessibleObject.ATK_HYPERTEXT_TYPE, (int)HypertextIfaceDefinition);
            }
            if (selection) {
                ATK.g_type_add_interface_static((int)type, (int)AccessibleObject.ATK_SELECTION_TYPE, (int)SelectionIfaceDefinition);
            }
            if (text) {
                ATK.g_type_add_interface_static((int)type, (int)AccessibleObject.ATK_TEXT_TYPE, (int)TextIfaceDefinition);
            }
            Types.put(swtTypeName, new LONG(type));
        }
        return type;
    }

    int gTypeInfo_base_init_factory(int klass) {
        int atkObjectFactoryClass = ATK.ATK_OBJECT_FACTORY_CLASS((int)klass);
        AtkObjectFactoryClass objectFactoryClassStruct = new AtkObjectFactoryClass();
        ATK.memmove((AtkObjectFactoryClass)objectFactoryClassStruct, (int)atkObjectFactoryClass);
        this.atkObjectFactoryCB_create_accessible = new Callback(this, "atkObjectFactory_create_accessible", 1);
        objectFactoryClassStruct.create_accessible = this.atkObjectFactoryCB_create_accessible.getAddress();
        ATK.memmove((int)atkObjectFactoryClass, (AtkObjectFactoryClass)objectFactoryClassStruct);
        return 0;
    }

    static int gTypeInfo_base_init_type(int klass) {
        AtkObjectClass objectClass = new AtkObjectClass();
        ATK.memmove((AtkObjectClass)objectClass, (int)klass);
        objectClass.get_name = AtkObjectCB_get_name.getAddress();
        objectClass.get_description = AtkObjectCB_get_description.getAddress();
        objectClass.get_n_children = AtkObjectCB_get_n_children.getAddress();
        objectClass.get_role = AtkObjectCB_get_role.getAddress();
        objectClass.get_parent = AtkObjectCB_get_parent.getAddress();
        objectClass.ref_state_set = AtkObjectCB_ref_state_set.getAddress();
        objectClass.get_index_in_parent = AtkObjectCB_get_index_in_parent.getAddress();
        objectClass.ref_child = AtkObjectCB_ref_child.getAddress();
        int gObjectClass = ATK.G_OBJECT_CLASS((int)klass);
        GObjectClass objectClassStruct = new GObjectClass();
        ATK.memmove((GObjectClass)objectClassStruct, (int)gObjectClass);
        objectClassStruct.finalize = GObjectClass_finalize.getAddress();
        ATK.memmove((int)gObjectClass, (GObjectClass)objectClassStruct);
        ATK.memmove((int)klass, (AtkObjectClass)objectClass);
        return 0;
    }

    static int initActionIfaceCB(int iface) {
        AtkActionIface actionIface = new AtkActionIface();
        ATK.memmove((AtkActionIface)actionIface, (int)iface);
        actionIface.get_keybinding = AtkActionCB_get_keybinding.getAddress();
        actionIface.get_name = AtkActionCB_get_name.getAddress();
        ATK.memmove((int)iface, (AtkActionIface)actionIface);
        return 0;
    }

    static int initComponentIfaceCB(int iface) {
        AtkComponentIface componentIface = new AtkComponentIface();
        ATK.memmove((AtkComponentIface)componentIface, (int)iface);
        componentIface.get_extents = AtkComponentCB_get_extents.getAddress();
        componentIface.get_position = AtkComponentCB_get_position.getAddress();
        componentIface.get_size = AtkComponentCB_get_size.getAddress();
        componentIface.ref_accessible_at_point = AtkComponentCB_ref_accessible_at_point.getAddress();
        ATK.memmove((int)iface, (AtkComponentIface)componentIface);
        return 0;
    }

    static int initHypertextIfaceCB(int iface) {
        AtkHypertextIface hypertextIface = new AtkHypertextIface();
        ATK.memmove((AtkHypertextIface)hypertextIface, (int)iface);
        hypertextIface.get_link = AtkHypertextCB_get_link.getAddress();
        hypertextIface.get_link_index = AtkHypertextCB_get_link_index.getAddress();
        hypertextIface.get_n_links = AtkHypertextCB_get_n_links.getAddress();
        ATK.memmove((int)iface, (AtkHypertextIface)hypertextIface);
        return 0;
    }

    static int initSelectionIfaceCB(int iface) {
        AtkSelectionIface selectionIface = new AtkSelectionIface();
        ATK.memmove((AtkSelectionIface)selectionIface, (int)iface);
        selectionIface.is_child_selected = AtkSelectionCB_is_child_selected.getAddress();
        selectionIface.ref_selection = AtkSelectionCB_ref_selection.getAddress();
        ATK.memmove((int)iface, (AtkSelectionIface)selectionIface);
        return 0;
    }

    static int initTextIfaceCB(int iface) {
        AtkTextIface textInterface = new AtkTextIface();
        ATK.memmove((AtkTextIface)textInterface, (int)iface);
        textInterface.get_caret_offset = AtkTextCB_get_caret_offset.getAddress();
        textInterface.get_character_at_offset = AtkTextCB_get_character_at_offset.getAddress();
        textInterface.get_character_count = AtkTextCB_get_character_count.getAddress();
        textInterface.get_n_selections = AtkTextCB_get_n_selections.getAddress();
        textInterface.get_selection = AtkTextCB_get_selection.getAddress();
        textInterface.get_text = AtkTextCB_get_text.getAddress();
        textInterface.get_text_after_offset = AtkTextCB_get_text_after_offset.getAddress();
        textInterface.get_text_at_offset = AtkTextCB_get_text_at_offset.getAddress();
        textInterface.get_text_before_offset = AtkTextCB_get_text_before_offset.getAddress();
        ATK.memmove((int)iface, (AtkTextIface)textInterface);
        return 0;
    }

    static void registerAccessible(Accessible accessible) {
        int controlHandle = accessible.getControlHandle();
        int widgetType = ATK.G_TYPE_FROM_INSTANCE((int)controlHandle);
        AccessibleFactory factory = (AccessibleFactory)Factories.get(new LONG(widgetType));
        if (factory == null) {
            factory = new AccessibleFactory(widgetType);
            Factories.put(new LONG(widgetType), factory);
        }
        factory.addAccessible(accessible);
    }

    void removeAccessible(Accessible accessible) {
        this.accessibles.remove(new LONG(accessible.getControlHandle()));
    }

    static void unregisterAccessible(Accessible accessible) {
        int controlHandle = accessible.getControlHandle();
        int widgetType = ATK.G_TYPE_FROM_INSTANCE((int)controlHandle);
        AccessibleFactory factory = (AccessibleFactory)Factories.get(new LONG(widgetType));
        if (factory != null) {
            factory.removeAccessible(accessible);
        }
    }
}

