/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;

public class TableCursor
extends Canvas {
    Table table;
    TableItem row = null;
    TableColumn column = null;
    Listener tableListener;
    Listener resizeListener;
    Listener disposeItemListener;
    Listener disposeColumnListener;
    static final int BACKGROUND = 27;
    static final int FOREGROUND = 26;

    public TableCursor(Table parent, int style) {
        super(parent, style);
        ScrollBar vBar;
        this.table = parent;
        this.setBackground(null);
        this.setForeground(null);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        TableCursor.this.dispose(event);
                        break;
                    }
                    case 15: 
                    case 16: {
                        TableCursor.this.redraw();
                        break;
                    }
                    case 1: {
                        TableCursor.this.keyDown(event);
                        break;
                    }
                    case 9: {
                        TableCursor.this.paint(event);
                        break;
                    }
                    case 31: {
                        TableCursor.this.traverse(event);
                    }
                }
            }
        };
        int[] events = new int[]{12, 15, 16, 1, 9, 31};
        int i = 0;
        while (i < events.length) {
            this.addListener(events[i], listener);
            ++i;
        }
        this.tableListener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 3: {
                        TableCursor.this.tableMouseDown(event);
                        break;
                    }
                    case 15: {
                        TableCursor.this.tableFocusIn(event);
                    }
                }
            }
        };
        this.table.addListener(15, this.tableListener);
        this.table.addListener(3, this.tableListener);
        this.disposeItemListener = new Listener(){

            public void handleEvent(Event event) {
                TableCursor.this.row = null;
                TableCursor.this.column = null;
                TableCursor.this.resize();
            }
        };
        this.disposeColumnListener = new Listener(){

            public void handleEvent(Event event) {
                TableCursor.this.row = null;
                TableCursor.this.column = null;
                TableCursor.this.resize();
            }
        };
        this.resizeListener = new Listener(){

            public void handleEvent(Event event) {
                TableCursor.this.resize();
            }
        };
        ScrollBar hBar = this.table.getHorizontalBar();
        if (hBar != null) {
            hBar.addListener(13, this.resizeListener);
        }
        if ((vBar = this.table.getVerticalBar()) != null) {
            vBar.addListener(13, this.resizeListener);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void dispose(Event event) {
        ScrollBar vBar;
        ScrollBar hBar;
        this.table.removeListener(15, this.tableListener);
        this.table.removeListener(3, this.tableListener);
        if (this.column != null) {
            this.column.removeListener(12, this.disposeColumnListener);
            this.column.removeListener(10, this.resizeListener);
            this.column.removeListener(11, this.resizeListener);
            this.column = null;
        }
        if (this.row != null) {
            this.row.removeListener(12, this.disposeItemListener);
            this.row = null;
        }
        if ((hBar = this.table.getHorizontalBar()) != null) {
            hBar.removeListener(13, this.resizeListener);
        }
        if ((vBar = this.table.getVerticalBar()) != null) {
            vBar.removeListener(13, this.resizeListener);
        }
    }

    void keyDown(Event event) {
        if (this.row == null) {
            return;
        }
        switch (event.character) {
            case '\r': {
                this.notifyListeners(14, new Event());
                return;
            }
        }
        int rowIndex = this.table.indexOf(this.row);
        int columnIndex = this.column == null ? 0 : this.table.indexOf(this.column);
        switch (event.keyCode) {
            case 0x1000001: {
                this.setRowColumn(Math.max(0, rowIndex - 1), columnIndex, true);
                break;
            }
            case 0x1000002: {
                this.setRowColumn(Math.min(rowIndex + 1, this.table.getItemCount() - 1), columnIndex, true);
                break;
            }
            case 0x1000003: 
            case 0x1000004: {
                int leadKey;
                int columnCount = this.table.getColumnCount();
                if (columnCount == 0) break;
                int n = leadKey = (this.getStyle() & 0x4000000) != 0 ? 0x1000004 : 0x1000003;
                if (event.keyCode == leadKey) {
                    this.setRowColumn(rowIndex, Math.max(0, columnIndex - 1), true);
                    break;
                }
                this.setRowColumn(rowIndex, Math.min(columnCount - 1, columnIndex + 1), true);
                break;
            }
            case 0x1000007: {
                this.setRowColumn(0, columnIndex, true);
                break;
            }
            case 0x1000008: {
                int i = this.table.getItemCount() - 1;
                this.setRowColumn(i, columnIndex, true);
                break;
            }
            case 0x1000005: {
                int index = this.table.getTopIndex();
                if (index == rowIndex) {
                    Rectangle rect = this.table.getClientArea();
                    TableItem item = this.table.getItem(index);
                    Rectangle itemRect = item.getBounds(0);
                    rect.height -= itemRect.y;
                    int height = this.table.getItemHeight();
                    int page = Math.max(1, rect.height / height);
                    index = Math.max(0, index - page + 1);
                }
                this.setRowColumn(index, columnIndex, true);
                break;
            }
            case 0x1000006: {
                int index = this.table.getTopIndex();
                Rectangle rect = this.table.getClientArea();
                TableItem item = this.table.getItem(index);
                Rectangle itemRect = item.getBounds(0);
                rect.height -= itemRect.y;
                int height = this.table.getItemHeight();
                int page = Math.max(1, rect.height / height);
                int end = this.table.getItemCount() - 1;
                index = Math.min(end, index + page - 1);
                if (index == rowIndex) {
                    index = Math.min(end, index + page - 1);
                }
                this.setRowColumn(index, columnIndex, true);
            }
        }
    }

    void paint(Event event) {
        String text;
        if (this.row == null) {
            return;
        }
        int columnIndex = this.column == null ? 0 : this.table.indexOf(this.column);
        GC gc = event.gc;
        Display display = this.getDisplay();
        gc.setBackground(this.getBackground());
        gc.setForeground(this.getForeground());
        gc.fillRectangle(event.x, event.y, event.width, event.height);
        int x = 0;
        Point size = this.getSize();
        Image image = this.row.getImage(columnIndex);
        if (image != null) {
            Rectangle imageSize = image.getBounds();
            int imageY = (size.y - imageSize.height) / 2;
            gc.drawImage(image, x, imageY);
            x += imageSize.width;
        }
        if ((text = this.row.getText(columnIndex)) != "") {
            int alignmnent;
            Rectangle bounds = this.row.getBounds(columnIndex);
            Point extent = gc.stringExtent(text);
            String platform = SWT.getPlatform();
            if ("win32".equals(platform)) {
                if (this.table.getColumnCount() == 0 || columnIndex == 0) {
                    x += 2;
                } else {
                    alignmnent = this.column.getAlignment();
                    switch (alignmnent) {
                        case 16384: {
                            x += 6;
                            break;
                        }
                        case 131072: {
                            x = bounds.width - extent.x - 6;
                            break;
                        }
                        case 0x1000000: {
                            x += (bounds.width - x - extent.x) / 2;
                        }
                    }
                }
            } else if (this.table.getColumnCount() == 0) {
                x += 5;
            } else {
                alignmnent = this.column.getAlignment();
                switch (alignmnent) {
                    case 16384: {
                        x += 5;
                        break;
                    }
                    case 131072: {
                        x = bounds.width - extent.x - 2;
                        break;
                    }
                    case 0x1000000: {
                        x += (bounds.width - x - extent.x) / 2 + 2;
                    }
                }
            }
            int textY = (size.y - extent.y) / 2;
            gc.drawString(text, x, textY);
        }
        if (this.isFocusControl()) {
            gc.setBackground(display.getSystemColor(2));
            gc.setForeground(display.getSystemColor(1));
            gc.drawFocus(0, 0, size.x, size.y);
        }
    }

    void tableFocusIn(Event event) {
        if (this.isDisposed()) {
            return;
        }
        if (this.isVisible()) {
            this.setFocus();
        }
    }

    void tableMouseDown(Event event) {
        if (this.isDisposed() || !this.isVisible()) {
            return;
        }
        Point pt = new Point(event.x, event.y);
        Rectangle clientRect = this.table.getClientArea();
        int columnCount = this.table.getColumnCount();
        int maxColumnIndex = columnCount == 0 ? 0 : columnCount - 1;
        int start = this.table.getTopIndex();
        int end = this.table.getItemCount();
        int i = start;
        while (i < end) {
            TableItem item = this.table.getItem(i);
            int j = 0;
            while (j <= maxColumnIndex) {
                Rectangle rect = item.getBounds(j);
                if (rect.y > clientRect.y + clientRect.height) {
                    return;
                }
                if (rect.contains(pt)) {
                    this.setRowColumn(i, j, true);
                    this.setFocus();
                    return;
                }
                ++j;
            }
            ++i;
        }
    }

    void traverse(Event event) {
        switch (event.detail) {
            case 4: 
            case 32: 
            case 64: {
                event.doit = false;
                return;
            }
        }
        event.doit = true;
    }

    void setRowColumn(int row, int column, boolean notify) {
        TableItem item = row == -1 ? null : this.table.getItem(row);
        TableColumn col = column == -1 || this.table.getColumnCount() == 0 ? null : this.table.getColumn(column);
        this.setRowColumn(item, col, notify);
    }

    void setRowColumn(TableItem row, TableColumn column, boolean notify) {
        if (this.row == row && this.column == column) {
            return;
        }
        if (this.row != null && this.row != row) {
            this.row.removeListener(12, this.disposeItemListener);
            this.row = null;
        }
        if (this.column != null && this.column != column) {
            this.column.removeListener(12, this.disposeColumnListener);
            this.column.removeListener(10, this.resizeListener);
            this.column.removeListener(11, this.resizeListener);
            this.column = null;
        }
        if (row != null) {
            if (this.row != row) {
                this.row = row;
                row.addListener(12, this.disposeItemListener);
                this.table.showItem(row);
            }
            if (this.column != column && column != null) {
                this.column = column;
                column.addListener(12, this.disposeColumnListener);
                column.addListener(10, this.resizeListener);
                column.addListener(11, this.resizeListener);
                this.table.showColumn(column);
            }
            int columnIndex = column == null ? 0 : this.table.indexOf(column);
            this.setBounds(row.getBounds(columnIndex));
            this.redraw();
            if (notify) {
                this.notifyListeners(13, new Event());
            }
        }
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if (visible) {
            this.resize();
        }
        super.setVisible(visible);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.removeListener(13, listener);
        this.removeListener(14, listener);
    }

    void resize() {
        if (this.row == null) {
            this.setBounds(-200, -200, 0, 0);
        } else {
            int columnIndex = this.column == null ? 0 : this.table.indexOf(this.column);
            this.setBounds(this.row.getBounds(columnIndex));
        }
    }

    public int getColumn() {
        this.checkWidget();
        return this.column == null ? 0 : this.table.indexOf(this.column);
    }

    public TableItem getRow() {
        this.checkWidget();
        return this.row;
    }

    public void setBackground(Color color) {
        if (color == null) {
            color = this.getDisplay().getSystemColor(27);
        }
        super.setBackground(color);
        this.redraw();
    }

    public void setForeground(Color color) {
        if (color == null) {
            color = this.getDisplay().getSystemColor(26);
        }
        super.setForeground(color);
        this.redraw();
    }

    public void setSelection(int row, int column) {
        int maxColumnIndex;
        this.checkWidget();
        int columnCount = this.table.getColumnCount();
        int n = maxColumnIndex = columnCount == 0 ? 0 : columnCount - 1;
        if (row < 0 || row >= this.table.getItemCount() || column < 0 || column > maxColumnIndex) {
            SWT.error(5);
        }
        this.setRowColumn(row, column, false);
    }

    public void setSelection(TableItem row, int column) {
        int maxColumnIndex;
        this.checkWidget();
        int columnCount = this.table.getColumnCount();
        int n = maxColumnIndex = columnCount == 0 ? 0 : columnCount - 1;
        if (row == null || row.isDisposed() || column < 0 || column > maxColumnIndex) {
            SWT.error(5);
        }
        this.setRowColumn(this.table.indexOf(row), column, false);
    }
}

