/*
 * Decompiled with CFR 0.152.
 */
package swingwt.awt;

import java.io.Serializable;
import swingwt.awt.Component;
import swingwt.awt.Container;
import swingwt.awt.Dimension;
import swingwt.awt.Insets;
import swingwt.awt.LayoutManager;

public class TableLayout
implements LayoutManager,
Serializable {
    protected int hgap = 4;
    protected int vgap = 4;
    protected int rows;
    protected int cols;
    protected boolean leftToRight = true;

    public TableLayout() {
        this(1, 0, 4, 4);
    }

    public TableLayout(int rows, int cols) {
        this(rows, cols, 4, 4, true);
    }

    public TableLayout(int rows, int cols, boolean leftToRight) {
        this(rows, cols, 4, 4, leftToRight);
    }

    public TableLayout(int rows, int cols, int hgap, int vgap) {
        this(rows, cols, hgap, vgap, true);
    }

    public TableLayout(int rows, int cols, int hgap, int vgap, boolean leftToRight) {
        if (rows == 0 && cols == 0) {
            throw new IllegalArgumentException("rows and cols cannot both be zero");
        }
        this.rows = rows;
        this.cols = cols;
        this.hgap = hgap;
        this.vgap = vgap;
        this.leftToRight = leftToRight;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        if (rows == 0 && this.cols == 0) {
            throw new IllegalArgumentException("rows and cols cannot both be zero");
        }
        this.rows = rows;
    }

    public int getColumns() {
        return this.cols;
    }

    public void setColumns(int cols) {
        if (cols == 0 && this.rows == 0) {
            throw new IllegalArgumentException("rows and cols cannot both be zero");
        }
        this.cols = cols;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public Dimension preferredLayoutSize(Container parent) {
        Insets insets = parent.getInsets();
        int ncomponents = parent.getComponentCount();
        int nrows = this.rows;
        int ncols = this.cols;
        if (nrows > 0) {
            ncols = (ncomponents + nrows - 1) / nrows;
        } else {
            nrows = (ncomponents + ncols - 1) / ncols;
        }
        int w = 0;
        int h = 0;
        for (int i = 0; i < ncomponents; ++i) {
            Component comp = parent.getComponent(i);
            Dimension d = comp.getPreferredSize();
            if (w < d.width) {
                w = d.width;
            }
            if (h >= d.height) continue;
            h = d.height;
        }
        return new Dimension(insets.left + insets.right + ncols * w + (ncols - 1) * this.hgap, insets.top + insets.bottom + nrows * h + (nrows - 1) * this.vgap);
    }

    public Dimension minimumLayoutSize(Container parent) {
        Insets insets = parent.getInsets();
        int ncomponents = parent.getComponentCount();
        int nrows = this.rows;
        int ncols = this.cols;
        if (nrows > 0) {
            ncols = (ncomponents + nrows - 1) / nrows;
        } else {
            nrows = (ncomponents + ncols - 1) / ncols;
        }
        int w = 0;
        int h = 0;
        for (int i = 0; i < ncomponents; ++i) {
            Component comp = parent.getComponent(i);
            Dimension d = comp.getMinimumSize();
            if (w < d.width) {
                w = d.width;
            }
            if (h >= d.height) continue;
            h = d.height;
        }
        return new Dimension(insets.left + insets.right + ncols * w + (ncols - 1) * this.hgap, insets.top + insets.bottom + nrows * h + (nrows - 1) * this.vgap);
    }

    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        int ncomponents = parent.getComponentCount();
        int nrows = this.rows;
        int ncols = this.cols;
        if (ncomponents == 0) {
            return;
        }
        if (this.leftToRight) {
            int[] maxWidths = new int[this.cols];
            int cc = 0;
            for (int i = 0; i < ncomponents; ++i) {
                int cw = parent.getComponent((int)i).getPreferredSize().width;
                if (cw > maxWidths[cc]) {
                    maxWidths[cc] = cw;
                }
                if (++cc != this.cols) continue;
                cc = 0;
            }
            int[] colPoints = new int[this.cols];
            for (int i = 0; i < this.cols; ++i) {
                colPoints[i] = i != 0 ? colPoints[i - 1] + this.hgap + maxWidths[i - 1] : this.hgap;
            }
            cc = 0;
            int highestInRow = 0;
            int curRowPos = 0;
            for (int i = 0; i < parent.getComponentCount(); ++i) {
                parent.getComponent(i).setBounds(colPoints[cc], curRowPos, parent.getComponent((int)i).getPreferredSize().width, parent.getComponent((int)i).getPreferredSize().height);
                if (parent.getComponent((int)i).getPreferredSize().height > highestInRow) {
                    highestInRow = parent.getComponent((int)i).getPreferredSize().height;
                }
                if (++cc != this.cols) continue;
                cc = 0;
                curRowPos += highestInRow + this.vgap;
                highestInRow = 0;
            }
        } else {
            int totRows = parent.getHeight() / (parent.getComponent((int)0).getPreferredSize().height + this.vgap);
            int[] maxWidths = new int[this.cols * 20];
            int cr = 0;
            int cc = 0;
            for (int i = 0; i < ncomponents; ++i) {
                int ch = parent.getComponent((int)i).getPreferredSize().width;
                if (ch > maxWidths[cc]) {
                    maxWidths[cc] = ch;
                }
                if (++cr != totRows) continue;
                cr = 0;
                ++cc;
            }
            if (this.cols < cc) {
                this.cols = cc;
            }
            int[] colPoints = new int[this.cols * 2];
            for (int i = 0; i < this.cols; ++i) {
                colPoints[i] = i != 0 ? colPoints[i - 1] + this.hgap + maxWidths[i - 1] : this.hgap;
            }
            cc = 0;
            int curRowPos = 0;
            cr = 0;
            for (int i = 0; i < parent.getComponentCount(); ++i) {
                parent.getComponent(i).setBounds(colPoints[cc], curRowPos, parent.getComponent((int)i).getPreferredSize().width, parent.getComponent((int)i).getPreferredSize().height);
                curRowPos += parent.getComponent((int)i).getPreferredSize().height + this.vgap;
                if (++cr != totRows) continue;
                cr = 0;
                curRowPos = 0;
                ++cc;
            }
        }
    }
}

