package Hardware::PCI::Table;

#   $Id: Table.pm,v 1.7 2003/01/19 23:26:20 sdague Exp $

#   Copyright (c) 2001-2002 International Business Machines

#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
 
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
 
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#   Sean Dague <sean@dague.net>

# This module is generated automagically by pcitable2pm.pl from the pcitable file
# which is in the kudzu rpm for Red Hat 7.2 and the pcitable file from Mandrake 8.1+
# CVS tree.  (When in conflict, the Red Hat devices were prefered) 

use strict;
use Carp;
use Util::Log qw(:all);
use vars qw($PCI $VERSION @ISA @EXPORT_OK @EXPORT %EXPORT_TAGS);
use base qw(Exporter);

%EXPORT_TAGS = ( 
                'all' => [
                          qw(pci_entry pci_module pci_type pci_vendor pci_product)
                         ],
               );

@EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

$VERSION = sprintf("%d.%02d", q$Revision: 1.7 $ =~ /(\d+)\.(\d+)/);

sub _load_overrides {
    my ($file) = @_;
    if(! -e $file) {
        return 1;
    }
    open(IN,$file) or croak("Couldn't load overrides file $file");
    while(<IN>) {
        s/^\s+//;
        my ($vend, $id, $type, $module, $vendor, $product) = split(/\s+/,$_);
        if($vend and $id and $type and $module) {
             verbose("Added $type:$module entry for '$vend $id'");
             $PCI->{$vend}->{$id} = {
                                     type => $type,
                                     module => $module,
                                     vendor => $vendor,
                                     product => $product,
                                    };
        }
    }
    close(IN);
    return 1;
}

sub _device_lookup {
    my ($vend, $dev) = @_;
    my %hash;
    if($vend =~ /^(\w{4})(\w{4})$/) {
        return %{$PCI->{$1}->{$2}} if $PCI->{$1}->{$2};
    } elsif (length($vend) == length($dev) and length($dev) == 4) {
        return %{$PCI->{$vend}->{$dev}} if $PCI->{$vend}->{$dev};
    } else {
        return %hash;
    }
    return %hash;
}

sub pci_entry {
    my %hash = _device_lookup(@_);
    return \%hash;
}

sub pci_vendor {
    my %hash = _device_lookup(@_);
    return $hash{vendor};
}

sub pci_module {
    my %hash = _device_lookup(@_);
    return $hash{module};
}

sub pci_type {
    my %hash = _device_lookup(@_);
    return $hash{type};
}

sub pci_product {
    my %hash = _device_lookup(@_);
    return $hash{product};
}

$PCI = {

'0e11' => {
	'0508' => {
		'type' => 'tokenring',
		'module' => 'tmspci',
		'vendor' => 'Compaq',
		'product' => 'Netelligent 4/16 Token Ring',
		},
	'a0fc' => {
		'type' => 'scsi',
		'module' => 'cpqfc',
		'vendor' => 'Compaq',
		'product' => 'Fibre Channel Host Controller',
		},
	'ae10' => {
		'type' => 'scsi',
		'module' => 'cpqarray',
		'vendor' => 'Compaq',
		'product' => 'Smart-2/P RAID Controller',
		},
	'ae32' => {
		'type' => 'ethernet',
		'module' => 'tlan',
		'vendor' => 'Compaq',
		'product' => 'Netelligent 10/100',
		},
	'ae34' => {
		'type' => 'ethernet',
		'module' => 'tlan',
		'vendor' => 'Compaq',
		'product' => 'Netelligent 10',
		},
	'ae35' => {
		'type' => 'ethernet',
		'module' => 'tlan',
		'vendor' => 'Compaq',
		'product' => 'Integrated NetFlex-3/P',
		},
	'ae40' => {
		'type' => 'ethernet',
		'module' => 'tlan',
		'vendor' => 'Compaq',
		'product' => 'Netelligent 10/100 Dual',
		},
	'ae43' => {
		'type' => 'ethernet',
		'module' => 'tlan',
		'vendor' => 'Compaq',
		'product' => 'ProLiant Integrated Netelligent 10/100',
		},
	'ae6c' => {
		'type' => 'ethernet',
		'module' => 'tlan',
		'vendor' => 'Compaq',
		'product' => 'Northstar',
		},
	'b011' => {
		'type' => 'ethernet',
		'module' => 'tlan',
		'vendor' => 'Compaq',
		'product' => 'Integrated Netelligent 10/100',
		},
	'b012' => {
		'type' => 'ethernet',
		'module' => 'tlan',
		'vendor' => 'Compaq',
		'product' => 'Netelligent 10 T/2',
		},
	'b030' => {
		'type' => 'ethernet',
		'module' => 'tlan',
		'vendor' => 'Compaq',
		'product' => 'Netelligent WS 5100',
		},
	'b060' => {
		'type' => 'scsi',
		'module' => 'cciss',
		'vendor' => 'Compaq',
		'product' => 'Smart Array 5300 Controller',
		},
	'b178' => {
		'type' => 'scsi',
		'module' => 'cciss',
		'vendor' => 'Compaq',
		'product' => 'Smart Array 5i/532',
		},
	'f130' => {
		'type' => 'ethernet',
		'module' => 'tlan',
		'vendor' => 'Compaq',
		'product' => 'NetFlex-3/P ThunderLAN 1.0',
		},
	'f150' => {
		'type' => 'ethernet',
		'module' => 'tlan',
		'vendor' => 'Compaq',
		'product' => 'NetFlex-3/P ThunderLAN 2.3',
		},
	},
'1000' => {
	'0001' => {
		'type' => 'scsi',
		'module' => 'ncr53c8xx',
		'vendor' => 'Symbios',
		'product' => '53c810',
		},
	'0002' => {
		'type' => 'scsi',
		'module' => 'sym53c8xx',
		'vendor' => 'Symbios',
		'product' => '53c820',
		},
	'0003' => {
		'type' => 'scsi',
		'module' => 'ncr53c8xx',
		'vendor' => 'Symbios',
		'product' => '53c825',
		},
	'0004' => {
		'type' => 'scsi',
		'module' => 'ncr53c8xx',
		'vendor' => 'Symbios',
		'product' => '53c815',
		},
	'0005' => {
		'type' => 'scsi',
		'module' => 'sym53c8xx',
		'vendor' => 'Symbios',
		'product' => '53c810AP',
		},
	'0006' => {
		'type' => 'scsi',
		'module' => 'sym53c8xx',
		'vendor' => 'Symbios',
		'product' => '53c860',
		},
	'000a' => {
		'type' => 'scsi',
		'module' => 'sym53c8xx',
		'vendor' => 'Symbios',
		'product' => '53c1510',
		},
	'000b' => {
		'type' => 'scsi',
		'module' => 'sym53c8xx',
		'vendor' => 'Symbios',
		'product' => '53c896',
		},
	'000c' => {
		'type' => 'scsi',
		'module' => 'ncr53c8xx',
		'vendor' => 'Symbios',
		'product' => '53c895',
		},
	'000d' => {
		'type' => 'scsi',
		'module' => 'sym53c8xx',
		'vendor' => 'Symbios',
		'product' => '53c885',
		},
	'000f' => {
		'type' => 'scsi',
		'module' => 'sym53c8xx',
		'vendor' => 'Symbios',
		'product' => '53c875',
		},
	'0010' => {
		'type' => 'scsi',
		'module' => 'sym53c8xx',
		'vendor' => 'Symbios',
		'product' => '53c895',
		},
	'0012' => {
		'type' => 'scsi',
		'module' => 'sym53c8xx',
		'vendor' => 'Symbios',
		'product' => '53c895a',
		},
	'0013' => {
		'type' => 'scsi',
		'module' => 'sym53c8xx',
		'vendor' => 'Symbios',
		'product' => '53c875a',
		},
	'0020' => {
		'type' => 'scsi',
		'module' => 'sym53c8xx',
		'vendor' => 'Symbios',
		'product' => '53c1010 Ultra3 SCSI Adapter',
		},
	'0021' => {
		'type' => 'scsi',
		'module' => 'sym53c8xx',
		'vendor' => 'Symbios',
		'product' => '53c1010 66MHz Ultra3 SCSI Adapter',
		},
	'0030' => {
		'type' => 'scsi',
		'module' => 'mptscsih',
		'vendor' => 'Symbios',
		'product' => '53c1030',
		},
	'0040' => {
		'type' => 'scsi',
		'module' => 'mptscsih',
		'vendor' => 'Symbios',
		'product' => '53c1035',
		},
	'008f' => {
		'type' => 'scsi',
		'module' => 'sym53c8xx',
		'vendor' => 'Symbios',
		'product' => '53c875J',
		},
	'0621' => {
		'type' => 'scsi',
		'module' => 'mptscsih',
		'vendor' => 'Symbios',
		'product' => 'FC909',
		},
	'0622' => {
		'type' => 'scsi',
		'module' => 'mptscsih',
		'vendor' => 'Symbios',
		'product' => 'FC929',
		},
	'0623' => {
		'type' => 'scsi',
		'module' => 'mptscsih',
		'vendor' => 'Symbios',
		'product' => 'FC929 LAN',
		},
	'0624' => {
		'type' => 'scsi',
		'module' => 'mptscsih',
		'vendor' => 'Symbios',
		'product' => 'FC919',
		},
	'0625' => {
		'type' => 'scsi',
		'module' => 'mptscsih',
		'vendor' => 'Symbios',
		'product' => 'FC919 LAN',
		},
	'0626' => {
		'type' => 'scsi',
		'module' => 'mptscsih',
		'vendor' => 'Symbios',
		'product' => 'FC929X',
		},
	'0627' => {
		'type' => 'scsi',
		'module' => 'mptscsih',
		'vendor' => 'Symbios',
		'product' => 'FC929X LAN',
		},
	'0628' => {
		'type' => 'scsi',
		'module' => 'mptscsih',
		'vendor' => 'Symbios',
		'product' => 'FC919X',
		},
	'0629' => {
		'type' => 'scsi',
		'module' => 'mptscsih',
		'vendor' => 'Symbios',
		'product' => 'FC919X LAN',
		},
	'0701' => {
		'type' => 'ethernet',
		'module' => 'yellowfin',
		'vendor' => 'Symbios',
		'product' => '83C885 NT50 DigitalScape Fast Ethernet',
		},
	'0702' => {
		'type' => 'ethernet',
		'module' => 'yellowfin',
		'vendor' => 'Symbios',
		'product' => 'Yellowfin G-NIC gigabit ethernet',
		},
	},
'100b' => {
	'0020' => {
		'type' => 'ethernet',
		'module' => 'natsemi',
		'vendor' => 'National Semi',
		'product' => 'DP83815 (MacPhyter) Ethernet Controller',
		},
	'0022' => {
		'type' => 'ethernet',
		'module' => 'ns83820',
		'vendor' => 'National Semi',
		'product' => 'DP83820 10/100/1000 Ethernet Controller',
		},
	},
'1011' => {
	'0001' => {
		'type' => 'ethernet',
		'module' => 'tulip',
		'vendor' => 'DEC',
		'product' => 'DECchip 21050',
		},
	'0002' => {
		'type' => 'ethernet',
		'module' => 'tulip',
		'vendor' => 'DEC',
		'product' => 'DECchip 21040 [Tulip]',
		},
	'0009' => {
		'type' => 'ethernet',
		'module' => 'tulip',
		'vendor' => 'DEC',
		'product' => 'DECchip 21140 [FasterNet]',
		},
	'000f' => {
		'type' => 'ethernet',
		'module' => 'defxx',
		'vendor' => 'DEC',
		'product' => 'DEFPA / 3C79x FDDILink',
		},
	'0014' => {
		'type' => 'ethernet',
		'module' => 'tulip',
		'vendor' => 'DEC',
		'product' => 'DECchip 21041 [Tulip Pass 3]',
		},
	'0019' => {
		'type' => 'ethernet',
		'module' => 'tulip',
		'vendor' => 'DEC',
		'product' => 'DECchip 21142/43',
		},
	'001a' => {
		'type' => 'ethernet',
		'module' => 'acenic',
		'vendor' => 'DEC',
		'product' => 'Farallon PN9000SX',
		},
	'0021' => {
		'type' => 'ethernet',
		'module' => 'tulip',
		'vendor' => 'DEC',
		'product' => 'DECchip 21052',
		},
	'0022' => {
		'type' => 'ethernet',
		'module' => 'tulip',
		'vendor' => 'DEC',
		'product' => 'DECchip 21150',
		},
	'0046' => {
		'type' => 'scsi',
		'module' => 'cpqarray',
		'vendor' => 'DEC',
		'product' => 'DECchip 21554 [Compaq Smart Array Controller]',
		},
	'1065' => {
		'type' => 'scsi',
		'module' => 'DAC960',
		'vendor' => 'DEC',
		'product' => 'RAID Controller',
		},
	},
'1014' => {
	'0018' => {
		'type' => 'tokenring',
		'module' => 'lanstreamer',
		'vendor' => 'IBM',
		'product' => 'TR Auto LANstreamer',
		},
	'002e' => {
		'type' => 'scsi',
		'module' => 'ips',
		'vendor' => 'IBM',
		'product' => 'ServeRAID-3x',
		},
	'003e' => {
		'type' => 'tokenring',
		'module' => 'olympic',
		'vendor' => 'IBM',
		'product' => '16/4 Token ring UTP/STP controller',
		},
	'005c' => {
		'type' => 'ethernet',
		'module' => 'eepro100',
		'vendor' => 'IBM',
		'product' => 'i82557B 10/100',
		},
	'01bd' => {
		'type' => 'scsi',
		'module' => 'ips',
		'vendor' => 'IBM',
		'product' => 'Netfinity ServeRAID controller',
		},
	'01be' => {
		'type' => 'scsi',
		'module' => 'ips',
		'vendor' => 'IBM',
		'product' => 'ServeRAID-4M',
		},
	'01bf' => {
		'type' => 'scsi',
		'module' => 'ips',
		'vendor' => 'IBM',
		'product' => 'ServeRAID-4L',
		},
	'0208' => {
		'type' => 'scsi',
		'module' => 'ips',
		'vendor' => 'IBM',
		'product' => 'ServeRAID-4Mx',
		},
	'020e' => {
		'type' => 'scsi',
		'module' => 'ips',
		'vendor' => 'IBM',
		'product' => 'ServeRAID-4Lx',
		},
	'022e' => {
		'type' => 'scsi',
		'module' => 'ips',
		'vendor' => 'IBM',
		'product' => 'ServeRAID-4H',
		},
	},
'101a' => {
	'0005' => {
		'type' => 'ethernet',
		'module' => 'hp100',
		'vendor' => 'AT&T GIS (NCR)',
		'product' => '100VG ethernet',
		},
	},
'101e' => {
	'1960' => {
		'type' => 'scsi',
		'module' => 'megaraid',
		'vendor' => 'AMI',
		'product' => 'MegaRAID',
		},
	'9010' => {
		'type' => 'scsi',
		'module' => 'megaraid',
		'vendor' => 'AMI',
		'product' => 'MegaRAID 428 Ultra RAID Controller',
		},
	'9060' => {
		'type' => 'scsi',
		'module' => 'megaraid',
		'vendor' => 'AMI',
		'product' => 'MegaRAID 434 Ultra GT RAID Controller',
		},
	},
'1022' => {
	'2000' => {
		'type' => 'ethernet',
		'module' => 'pcnet32',
		'vendor' => 'Advanced Micro Devices [AMD]',
		'product' => '79c970 [PCnet LANCE]',
		},
	'2001' => {
		'type' => 'ethernet',
		'module' => 'pcnet32',
		'vendor' => 'Advanced Micro Devices [AMD]',
		'product' => '79c978 [HomePNA]',
		},
	'2020' => {
		'type' => 'scsi',
		'module' => 'tmscsim',
		'vendor' => 'Advanced Micro Devices [AMD]',
		'product' => '53c974 [PCscsi]',
		},
	},
'1028' => {
	'0001' => {
		'type' => 'scsi',
		'module' => 'aacraid',
		'vendor' => 'Dell Computer Corporation',
		'product' => 'PowerEdge Expandable RAID Controller 2/Si',
		},
	'0002' => {
		'type' => 'scsi',
		'module' => 'aacraid',
		'vendor' => 'Dell Computer Corporation',
		'product' => 'PowerEdge Expandable RAID Controller 3',
		},
	'0003' => {
		'type' => 'scsi',
		'module' => 'aacraid',
		'vendor' => 'Dell Computer Corporation',
		'product' => 'PowerEdge Expandable RAID Controller 3/Si',
		},
	'0004' => {
		'type' => 'scsi',
		'module' => 'aacraid',
		'vendor' => 'Dell Computer Corporation',
		'product' => 'PowerEdge Expandable RAID Controller 3/Si',
		},
	'0005' => {
		'type' => 'scsi',
		'module' => 'aacraid',
		'vendor' => 'Dell Computer Corporation',
		'product' => 'PowerEdge Expandable RAID Controller 3/Di',
		},
	'0006' => {
		'type' => 'scsi',
		'module' => 'aacraid',
		'vendor' => 'Dell Computer Corporation',
		'product' => 'PowerEdge Expandable RAID Controller 3/Di',
		},
	'0008' => {
		'type' => 'scsi',
		'module' => 'aacraid',
		'vendor' => 'Dell Computer Corporation',
		'product' => 'PowerEdge Expandable RAID Controller 3/Di',
		},
	'000a' => {
		'type' => 'scsi',
		'module' => 'aacraid',
		'vendor' => 'Dell Computer Corporation',
		'product' => 'PowerEdge Expandable RAID Controller 3',
		},
	'000e' => {
		'type' => 'scsi',
		'module' => 'megaraid',
		'vendor' => 'Dell Computer Corporation',
		'product' => 'PowerEdge RAID Controller',
		},
	},
'1036' => {
	'0000' => {
		'type' => 'scsi',
		'module' => 'fdomain',
		'vendor' => 'Future Domain',
		'product' => 'TMC-18C30 [36C70]',
		},
	},
'1039' => {
	'0900' => {
		'type' => 'ethernet',
		'module' => 'sis900',
		'vendor' => 'Silicon Integrated Systems [SiS]',
		'product' => 'SiS900 10/100 Ethernet',
		},
	'7016' => {
		'type' => 'ethernet',
		'module' => 'sis900',
		'vendor' => 'Silicon Integrated Systems [SiS]',
		'product' => 'SiS7016 10/100 Ethernet Adapter',
		},
	},
'103c' => {
	'1030' => {
		'type' => 'ethernet',
		'module' => 'hp100',
		'vendor' => 'HP',
		'product' => 'J2585A DeskDirect 10/100VG NIC',
		},
	'1031' => {
		'type' => 'ethernet',
		'module' => 'hp100',
		'vendor' => 'HP',
		'product' => 'J2585B HP 10/100VG PCI LAN Adapter',
		},
	'10c2' => {
		'type' => 'scsi',
		'module' => 'aacraid',
		'vendor' => 'HP',
		'product' => 'NetRAID-4M',
		},
	},
'1044' => {
	'a400' => {
		'type' => 'scsi',
		'module' => 'eata',
		'vendor' => 'Distributed Tech',
		'product' => 'SmartCache/Raid I-IV Controller',
		},
	'a501' => {
		'type' => 'scsi',
		'module' => 'dpt_i2o',
		'vendor' => 'Distributed Tech',
		'product' => 'SmartRAID V Controller',
		},
	'a511' => {
		'type' => 'scsi',
		'module' => 'dpt_i2o',
		'vendor' => 'Distributed Tech',
		'product' => 'SmartRAID V Controller',
		},
	},
'104a' => {
	'0981' => {
		'type' => 'ethernet',
		'module' => 'tulip',
		'vendor' => 'SGS Thomson',
		'product' => 'DEC-Tulip compatible 10/100 Ethernet',
		},
	'2774' => {
		'type' => 'ethernet',
		'module' => 'tulip',
		'vendor' => 'SGS Thomson',
		'product' => 'DEC-Tulip compatible 10/100 Ethernet',
		},
	},
'104b' => {
	'0140' => {
		'type' => 'scsi',
		'module' => 'BusLogic',
		'vendor' => 'BusLogic',
		'product' => 'BT-946C (old) [multimaster 01]',
		},
	'1040' => {
		'type' => 'scsi',
		'module' => 'BusLogic',
		'vendor' => 'BusLogic',
		'product' => 'BT-946C (BA80C30) [MultiMaster 10]',
		},
	'8130' => {
		'type' => 'scsi',
		'module' => 'BusLogic',
		'vendor' => 'BusLogic',
		'product' => 'Flashpoint LT',
		},
	},
'1050' => {
	'0000' => {
		'type' => 'ethernet',
		'module' => 'ne2k-pci',
		'vendor' => 'Winbond Electronics Corp',
		'product' => 'NE2000',
		},
	'0840' => {
		'type' => 'ethernet',
		'module' => 'winbond-840',
		'vendor' => 'Winbond Electronics Corp',
		'product' => 'W89C840',
		},
	'0940' => {
		'type' => 'ethernet',
		'module' => 'ne2k-pci',
		'vendor' => 'Winbond Electronics Corp',
		'product' => 'W89C940',
		},
	'5a5a' => {
		'type' => 'ethernet',
		'module' => 'ne2k-pci',
		'vendor' => 'Winbond Electronics Corp',
		'product' => 'W89C940F',
		},
	},
'1069' => {
	'0001' => {
		'type' => 'scsi',
		'module' => 'DAC960',
		'vendor' => 'Mylex Corporation',
		'product' => 'DAC960P',
		},
	'0002' => {
		'type' => 'scsi',
		'module' => 'DAC960',
		'vendor' => 'Mylex Corporation',
		'product' => 'DAC960PD',
		},
	'0010' => {
		'type' => 'scsi',
		'module' => 'DAC960',
		'vendor' => 'Mylex Corporation',
		'product' => 'DAC960PX',
		},
	'0020' => {
		'type' => 'scsi',
		'module' => 'DAC960',
		'vendor' => 'Mylex Corporation',
		'product' => 'DAC960 V5',
		},
	'0050' => {
		'type' => 'scsi',
		'module' => 'DAC960',
		'vendor' => 'Mylex Corporation',
		'product' => 'AcceleRAID 352/170/160 support Device',
		},
	'ba55' => {
		'type' => 'scsi',
		'module' => 'DAC960',
		'vendor' => 'Mylex Corporation',
		'product' => 'eXtremeRAID 1100 support Device',
		},
	'ba56' => {
		'type' => 'scsi',
		'module' => 'DAC960',
		'vendor' => 'Mylex Corporation',
		'product' => 'eXtremeRAID 2000/3000 support Device',
		},
	},
'106b' => {
	'0021' => {
		'type' => 'ethernet',
		'module' => 'sungem',
		'vendor' => 'Apple Computer Inc.',
		'product' => 'UniNorth GMAC (Sun GEM)',
		},
	'0024' => {
		'type' => 'ethernet',
		'module' => 'sungem',
		'vendor' => 'Apple Computer Inc.',
		'product' => 'UniNorth/Pangea GMAC (Sun GEM)',
		},
	},
'1077' => {
	'1016' => {
		'type' => 'scsi',
		'module' => 'qla1280',
		'vendor' => 'QLogic Corp.',
		'product' => 'ISP10160 Single Channel Ultra3 SCSI Processor',
		},
	'1020' => {
		'type' => 'scsi',
		'module' => 'qlogicisp',
		'vendor' => 'QLogic Corp.',
		'product' => 'ISP1020 Fast-wide SCSI',
		},
	'1022' => {
		'type' => 'scsi',
		'module' => 'qlogicisp',
		'vendor' => 'Q Logic',
		'product' => 'ISP1022',
		},
	'1080' => {
		'type' => 'scsi',
		'module' => 'qla1280',
		'vendor' => 'QLogic Corp.',
		'product' => 'ISP1080 SCSI Host Adapter',
		},
	'1216' => {
		'type' => 'scsi',
		'module' => 'qla1280',
		'vendor' => 'QLogic Corp.',
		'product' => 'ISP12160 Dual Channel Ultra3 SCSI Processor',
		},
	'1240' => {
		'type' => 'scsi',
		'module' => 'qla1280',
		'vendor' => 'QLogic Corp.',
		'product' => 'ISP1240 SCSI Host Adapter',
		},
	'1280' => {
		'type' => 'scsi',
		'module' => 'qla1280',
		'vendor' => 'QLogic Corp.',
		'product' => 'ISP1280',
		},
	'2020' => {
		'type' => 'scsi',
		'module' => 'qlogicisp',
		'vendor' => 'Q Logic',
		'product' => 'ISP2020A',
		},
	'2100' => {
		'type' => 'scsi',
		'module' => 'qla2x00',
		'vendor' => 'QLogic Corp.',
		'product' => 'QLA2100 64-bit Fibre Channel Adapter',
		},
	},
'107e' => {
	'0004' => {
		'type' => 'ethernet',
		'module' => 'iph5526',
		'vendor' => 'Interphase Corporation',
		'product' => '5526 Fibre Channel Host Adapter',
		},
	'0005' => {
		'type' => 'ethernet',
		'module' => 'iph5526',
		'vendor' => 'Interphase Corporation',
		'product' => 'x526 Fibre Channel Host Adapter',
		},
	},
'108d' => {
	'0002' => {
		'type' => 'tokenring',
		'module' => 'ibmtr',
		'vendor' => 'Olicom',
		'product' => '16/4 Token Ring',
		},
	'0004' => {
		'type' => 'tokenring',
		'module' => 'ibmtr',
		'vendor' => 'Olicom',
		'product' => 'RapidFire 3139 Token-Ring 16/4 PCI Adapter',
		},
	'0005' => {
		'type' => 'tokenring',
		'module' => 'ibmtr',
		'vendor' => 'Olicom',
		'product' => 'GoCard 3250 Token-Ring 16/4 CardBus PC Card',
		},
	'0007' => {
		'type' => 'tokenring',
		'module' => 'ibmtr',
		'vendor' => 'Olicom',
		'product' => 'RapidFire 3141 Token-Ring 16/4 PCI Fiber Adapter',
		},
	'0012' => {
		'type' => 'ethernet',
		'module' => 'tlan',
		'vendor' => 'Olicom',
		'product' => 'OC-2325',
		},
	'0013' => {
		'type' => 'ethernet',
		'module' => 'tlan',
		'vendor' => 'Olicom',
		'product' => 'OC-2183/2185',
		},
	'0014' => {
		'type' => 'ethernet',
		'module' => 'tlan',
		'vendor' => 'Olicom',
		'product' => 'OC-2326',
		},
	'0019' => {
		'type' => 'ethernet',
		'module' => 'tlan',
		'vendor' => 'Olicom',
		'product' => 'OC-2327/2250 10/100 Ethernet Adapter',
		},
	},
'108e' => {
	'1001' => {
		'type' => 'ethernet',
		'module' => 'sunhme',
		'vendor' => 'Sun',
		'product' => 'Happy Meal',
		},
	'1101' => {
		'type' => 'ethernet',
		'module' => 'sungem',
		'vendor' => 'Sun',
		'product' => 'RIO GEM',
		},
	'2bad' => {
		'type' => 'ethernet',
		'module' => 'sungem',
		'vendor' => 'Sun',
		'product' => 'GEM',
		},
	},
'10a9' => {
	'0009' => {
		'type' => 'ethernet',
		'module' => 'acenic',
		'vendor' => 'Silicon Graphics, Inc.',
		'product' => 'Alteon Gigabit Ethernet',
		},
	},
'10b6' => {
	'0002' => {
		'type' => 'tokenring',
		'module' => 'abyss',
		'vendor' => 'Madge Networks',
		'product' => 'Smart 16/4 PCI Ringnode Mk2',
		},
	},
'10b7' => {
	'0001' => {
		'type' => 'ethernet',
		'module' => 'acenic',
		'vendor' => '3Com Corporation',
		'product' => '3c985 1000BaseSX (SX/TX)',
		},
	'3390' => {
		'type' => 'tokenring',
		'module' => 'tmspci',
		'vendor' => '3Com Corporation',
		'product' => '3c339 TokenLink Velocity',
		},
	'4500' => {
		'type' => 'ethernet',
		'module' => '3c59x',
		'vendor' => '3Com Corporation',
		'product' => '3c450 Cyclone/unknown',
		},
	'5055' => {
		'type' => 'ethernet',
		'module' => '3c59x',
		'vendor' => '3Com Corporation',
		'product' => '3c555 Laptop Hurricane',
		},
	'5057' => {
		'type' => 'ethernet',
		'module' => '3c59x',
		'vendor' => '3Com Corporation',
		'product' => '3c575 [Megahertz] 10/100 LAN CardBus',
		},
	'5157' => {
		'type' => 'ethernet',
		'module' => '3c59x',
		'vendor' => '3Com Corporation',
		'product' => '3c575 [Megahertz] 10/100 LAN CardBus',
		},
	'5257' => {
		'type' => 'ethernet',
		'module' => '3c59x',
		'vendor' => '3Com Corporation',
		'product' => '3CCFE575CT Cyclone CardBus',
		},
	'5900' => {
		'type' => 'ethernet',
		'module' => '3c59x',
		'vendor' => '3Com Corporation',
		'product' => '3c590 10BaseT [Vortex]',
		},
	'5920' => {
		'type' => 'ethernet',
		'module' => '3c59x',
		'vendor' => '3Com Corporation',
		'product' => '3c592 EISA 10mbps Demon/Vortex',
		},
	'5950' => {
		'type' => 'ethernet',
		'module' => '3c59x',
		'vendor' => '3Com Corporation',
		'product' => '3c595 100BaseTX [Vortex]',
		},
	'5951' => {
		'type' => 'ethernet',
		'module' => '3c59x',
		'vendor' => '3Com Corporation',
		'product' => '3c595 100BaseT4 [Vortex]',
		},
	'5952' => {
		'type' => 'ethernet',
		'module' => '3c59x',
		'vendor' => '3Com Corporation',
		'product' => '3c595 100Base-MII [Vortex]',
		},
	'5970' => {
		'type' => 'ethernet',
		'module' => '3c59x',
		'vendor' => '3Com Corporation',
		'product' => '3c597 EISA Fast Demon/Vortex',
		},
	'5b57' => {
		'type' => 'ethernet',
		'module' => '3c59x',
		'vendor' => '3Com Corporation',
		'product' => '3c595 [Megahertz] 10/100 LAN CardBus',
		},
	'6055' => {
		'type' => 'ethernet',
		'module' => '3c59x',
		'vendor' => '3Com Corporation',
		'product' => '3c556 Hurricane CardBus',
		},
	'6056' => {
		'type' => 'ethernet',
		'module' => '3c59x',
		'vendor' => '3Com Corporation',
		'product' => '3c556B Hurricane CardBus',
		},
	'6550' => {
		'type' => 'ethernet',
		'module' => '3c59x',
		'vendor' => '3Com Corporation',
		'product' => '3c575 [Megahertz] 10/100 LAN CardBus',
		},
	'6560' => {
		'type' => 'ethernet',
		'module' => '3c59x',
		'vendor' => '3Com Corporation',
		'product' => '3CCFE656 Cyclone CardBus',
		},
	'6561' => {
		'type' => 'ethernet',
		'module' => '3c59x',
		'vendor' => '3Com Corporation',
		'product' => '3CCFEM656 10/100 LAN+56K Modem CardBus',
		},
	'6562' => {
		'type' => 'ethernet',
		'module' => '3c59x',
		'vendor' => '3Com Corporation',
		'product' => '3CCFEM656 [id 6562] Cyclone CardBus',
		},
	'6563' => {
		'type' => 'ethernet',
		'module' => '3c59x',
		'vendor' => '3Com Corporation',
		'product' => '3CCFEM656B 10/100 LAN+56K Modem CardBus',
		},
	'6564' => {
		'type' => 'ethernet',
		'module' => '3c59x',
		'vendor' => '3Com Corporation',
		'product' => '3CCFEM656 [id 6564] Cyclone CardBus',
		},
	'7646' => {
		'type' => 'ethernet',
		'module' => '3c59x',
		'vendor' => '3Com Corporation',
		'product' => '3cSOHO100-TX Hurricane',
		},
	'9000' => {
		'type' => 'ethernet',
		'module' => '3c59x',
		'vendor' => '3Com Corporation',
		'product' => '3c900 10BaseT [Boomerang]',
		},
	'9001' => {
		'type' => 'ethernet',
		'module' => '3c59x',
		'vendor' => '3Com Corporation',
		'product' => '3c900 Combo [Boomerang]',
		},
	'9004' => {
		'type' => 'ethernet',
		'module' => '3c59x',
		'vendor' => '3Com Corporation',
		'product' => '3c900B-TPO [Etherlink XL TPO]',
		},
	'9005' => {
		'type' => 'ethernet',
		'module' => '3c59x',
		'vendor' => '3Com Corporation',
		'product' => '3c900B-Combo [Etherlink XL Combo]',
		},
	'9006' => {
		'type' => 'ethernet',
		'module' => '3c59x',
		'vendor' => '3Com Corporation',
		'product' => '3c900B-TPC [Etherlink XL TPC]',
		},
	'900a' => {
		'type' => 'ethernet',
		'module' => '3c59x',
		'vendor' => '3Com Corporation',
		'product' => '3c900B-FL [Etherlink XL FL]',
		},
	'9050' => {
		'type' => 'ethernet',
		'module' => '3c59x',
		'vendor' => '3Com Corporation',
		'product' => '3c905 100BaseTX [Boomerang]',
		},
	'9051' => {
		'type' => 'ethernet',
		'module' => '3c59x',
		'vendor' => '3Com Corporation',
		'product' => '3c905 100BaseT4 [Boomerang]',
		},
	'9055' => {
		'type' => 'ethernet',
		'module' => '3c59x',
		'vendor' => '3Com Corporation',
		'product' => '3c905B 100BaseTX [Cyclone]',
		},
	'9056' => {
		'type' => 'ethernet',
		'module' => '3c59x',
		'vendor' => '3Com Corporation',
		'product' => '3c905B-T4 [Fast EtherLink XL 10/100]',
		},
	'9058' => {
		'type' => 'ethernet',
		'module' => '3c59x',
		'vendor' => '3Com Corporation',
		'product' => '3c905B-Combo [Deluxe Etherlink XL 10/100]',
		},
	'905a' => {
		'type' => 'ethernet',
		'module' => '3c59x',
		'vendor' => '3Com Corporation',
		'product' => '3c905B-FX [Fast Etherlink XL FX 10/100]',
		},
	'9200' => {
		'type' => 'ethernet',
		'module' => '3c59x',
		'vendor' => '3Com Corporation',
		'product' => '3c905C-TX/TX-M [Tornado]',
		},
	'9800' => {
		'type' => 'ethernet',
		'module' => '3c59x',
		'vendor' => '3Com Corporation',
		'product' => '3c980-TX [Fast Etherlink XL Server Adapter]',
		},
	'9805' => {
		'type' => 'ethernet',
		'module' => '3c59x',
		'vendor' => '3Com Corporation',
		'product' => '3c980-TX 10/100baseTX NIC [Python-T]',
		},
	},
'10b8' => {
	'0005' => {
		'type' => 'ethernet',
		'module' => 'epic100',
		'vendor' => 'Standard Microsystems Corp [SMC]',
		'product' => '83C170QF',
		},
	'0006' => {
		'type' => 'ethernet',
		'module' => 'epic100',
		'vendor' => 'Standard Microsystems Corp [SMC]',
		'product' => 'LANEPIC',
		},
	},
'10bd' => {
	'0e34' => {
		'type' => 'ethernet',
		'module' => 'ne2k-pci',
		'vendor' => 'Surecom Technology',
		'product' => 'NE-34',
		},
	},
'10c3' => {
	'1100' => {
		'type' => 'ethernet',
		'module' => 'eepro100',
		'vendor' => 'Samsung Semiconductors, Inc.',
		'product' => 'Smartether100 SC1100 LAN Adapter (i82557B)',
		},
	},
'10cd' => {
	'1200' => {
		'type' => 'scsi',
		'module' => 'advansys',
		'vendor' => 'Advanced System Products',
		'product' => 'ASC1200 [(abp940) Fast SCSI-II]',
		},
	'1300' => {
		'type' => 'scsi',
		'module' => 'advansys',
		'vendor' => 'Advanced System Products',
		'product' => 'ABP940-U / ABP960-U',
		},
	'2300' => {
		'type' => 'scsi',
		'module' => 'advansys',
		'vendor' => 'Advanced System Products',
		'product' => 'ABP940-UW',
		},
	'2500' => {
		'type' => 'scsi',
		'module' => 'advansys',
		'vendor' => 'Advanced System Products',
		'product' => 'ABP940-U2W',
		},
	},
'10d9' => {
	'0512' => {
		'type' => 'ethernet',
		'module' => 'tulip',
		'vendor' => 'Macronix, Inc. [MXIC]',
		'product' => 'MX98713',
		},
	'0531' => {
		'type' => 'ethernet',
		'module' => 'tulip',
		'vendor' => 'Macronix, Inc. [MXIC]',
		'product' => 'MX987x5',
		},
	'8625' => {
		'type' => 'ethernet',
		'module' => 'tulip',
		'vendor' => 'Macronix, Inc. [MXIC]',
		'product' => 'MX86250',
		},
	},
'10da' => {
	'0508' => {
		'type' => 'tokenring',
		'module' => 'tmspci',
		'vendor' => 'Compaq IPG-Austin',
		'product' => 'TC4048 Token Ring 4/16',
		},
	},
'10ec' => {
	'8029' => {
		'type' => 'ethernet',
		'module' => 'ne2k-pci',
		'vendor' => 'Realtek',
		'product' => 'RTL-8029(AS)',
		},
	'8129' => {
		'type' => 'ethernet',
		'module' => '8139too',
		'vendor' => 'Realtek',
		'product' => 'RTL-8129',
		},
	'8138' => {
		'type' => 'ethernet',
		'module' => '8139too',
		'vendor' => 'Realtek',
		'product' => 'RT8139 (B/C) Cardbus Fast Ethernet Adapter',
		},
	'8139' => {
		'type' => 'ethernet',
		'module' => '8139too',
		'vendor' => 'Realtek',
		'product' => 'RTL-8139/8139C',
		},
	},
'1103' => {
	'0004' => {
		'type' => 'scsi',
		'module' => 'hptraid',
		'vendor' => 'Triones',
		'product' => 'HPT366',
		},
	},
'1106' => {
	'0926' => {
		'type' => 'ethernet',
		'module' => 'ne2k-pci',
		'vendor' => 'VIA Technologies',
		'product' => 'VT82C926 [Amazon]',
		},
	'3043' => {
		'type' => 'ethernet',
		'module' => 'via-rhine',
		'vendor' => 'VIA Technologies',
		'product' => 'VT86C100A [Rhine]',
		},
	'3065' => {
		'type' => 'ethernet',
		'module' => 'via-rhine',
		'vendor' => 'VIA Technologies',
		'product' => 'VT6102 [Rhine-II]',
		},
	'6100' => {
		'type' => 'ethernet',
		'module' => 'via-rhine',
		'vendor' => 'VIA Technologies',
		'product' => 'VT85C100A [Rhine II]',
		},
	},
'1113' => {
	'1211' => {
		'type' => 'ethernet',
		'module' => '8139too',
		'vendor' => 'Accton',
		'product' => 'SMC2-1211TX',
		},
	'1216' => {
		'type' => 'ethernet',
		'module' => 'tulip',
		'vendor' => 'Accton',
		'product' => 'EN-1216 Ethernet Adapter',
		},
	'1217' => {
		'type' => 'ethernet',
		'module' => 'tulip',
		'vendor' => 'Accton',
		'product' => 'EN-1217 Ethernet Adapter',
		},
	'9511' => {
		'type' => 'ethernet',
		'module' => 'tulip',
		'vendor' => 'Accton',
		'product' => 'Fast Ethernet Adapter',
		},
	},
'1119' => {
	'0000' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 6000/6020/6050',
		},
	'0001' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 6000B/6010',
		},
	'0002' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 6110/6510',
		},
	'0003' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 6120/6520',
		},
	'0004' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 6530',
		},
	'0005' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 6550',
		},
	'0006' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 6x17',
		},
	'0007' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 6x27',
		},
	'0008' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 6537',
		},
	'0009' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 6557',
		},
	'000a' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 6115/6515',
		},
	'000b' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 6125/6525',
		},
	'000c' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 6535',
		},
	'000d' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 6555',
		},
	'0100' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 6117RP/6517RP',
		},
	'0101' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 6127RP/6527RP',
		},
	'0102' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 6537RP',
		},
	'0103' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 6557RP',
		},
	'0104' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 6111RP/6511RP',
		},
	'0105' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 6121RP/6521RP',
		},
	'0110' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 6117RD/6517RD',
		},
	'0111' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 6127RD/6527RD',
		},
	'0112' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 6537RD',
		},
	'0113' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 6557RD',
		},
	'0114' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 6111RD/6511RD',
		},
	'0115' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 6121RD/6521RD',
		},
	'0118' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 6118RD/6518RD/6618RD',
		},
	'0119' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 6128RD/6528RD/6628RD',
		},
	'011A' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 6x38RD',
		},
	'011B' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 6x58RD',
		},
	'011a' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 6538RD/6638RD',
		},
	'011b' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 6558RD/6658RD',
		},
	'0120' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 6117RP2/6517RP2',
		},
	'0121' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 6127RP2/6527RP2',
		},
	'0122' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 6537RP2',
		},
	'0123' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 6557RP2',
		},
	'0124' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 6111RP2/6511RP2',
		},
	'0125' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 6121RP2/6521RP2',
		},
	'0136' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 6113RS/6513RS',
		},
	'0137' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 6123RS/6523RS',
		},
	'0138' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 6118RS/6518RS/6618RS',
		},
	'0139' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 6128RS/6528RS/6628RS',
		},
	'013a' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 6538RS/6638RS',
		},
	'013b' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 6558RS/6658RS',
		},
	'013c' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 6533RS/6633RS',
		},
	'013d' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 6543RS/6643RS',
		},
	'013e' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 6553RS/6653RS',
		},
	'013f' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 6563RS/6663RS',
		},
	'0166' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 7113RN/7513RN/7613RN',
		},
	'0167' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 7123RN/7523RN/7623RN',
		},
	'0168' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 7118RN/7518RN/7518RN',
		},
	'0169' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 7128RN/7528RN/7628RN',
		},
	'016A' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 7x38RN',
		},
	'016B' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 7x58RN',
		},
	'016a' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 7538RN/7638RN',
		},
	'016b' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 7558RN/7658RN',
		},
	'016c' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 7533RN/7633RN',
		},
	'016d' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 7543RN/7643RN',
		},
	'016e' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 7553RN/7653RN',
		},
	'016f' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 7563RN/7663RN',
		},
	'01d6' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 4x13RZ',
		},
	'01d7' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 4x23RZ',
		},
	'01f6' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 8x13RZ',
		},
	'01f7' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 8x23RZ',
		},
	'01fc' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 8x33RZ',
		},
	'01fd' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 8x43RZ',
		},
	'01fe' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 8x53RZ',
		},
	'01ff' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 8x63RZ',
		},
	'0210' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 6519RD/6619RD',
		},
	'0211' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 6529RD/6629RD',
		},
	'0260' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 7519RN/7619RN',
		},
	'0261' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT 7529RN/7629RN',
		},
	'0300' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'ICP Vortex',
		'product' => 'GDT Raid Controller',
		},
	'ffff' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => '',
		'product' => '',
		},
	},
'111a' => {
	'0000' => {
		'type' => 'atm',
		'module' => 'eni',
		'vendor' => 'Efficient Networks, Inc',
		'product' => '155P-MF1 (FPGA)',
		},
	'0002' => {
		'type' => 'atm',
		'module' => 'eni',
		'vendor' => 'Efficient Networks, Inc',
		'product' => '155P-MF1 (ASIC)',
		},
	},
'1148' => {
	'4000' => {
		'type' => 'ethernet',
		'module' => 'skfp',
		'vendor' => 'Syskonnect (Schneider & Koch)',
		'product' => 'FDDI Adapter',
		},
	'4200' => {
		'type' => 'tokenring',
		'module' => 'tmspci',
		'vendor' => 'Syskonnect (Schneider & Koch)',
		'product' => 'Token Ring adapter',
		},
	'4300' => {
		'type' => 'ethernet',
		'module' => 'sk98lin',
		'vendor' => 'Syskonnect (Schneider & Koch)',
		'product' => 'Gigabit Ethernet',
		},
	},
'114f' => {
	'0003' => {
		'type' => 'ethernet',
		'module' => 'dgrs',
		'vendor' => 'Digi International',
		'product' => 'RightSwitch SE-6',
		},
	},
'1186' => {
	'0100' => {
		'type' => 'ethernet',
		'module' => 'tulip',
		'vendor' => 'D-Link System Inc',
		'product' => 'DC21041',
		},
	'1002' => {
		'type' => 'ethernet',
		'module' => 'sundance',
		'vendor' => 'D-Link System Inc',
		'product' => 'DL10050 Sundance Ethernet',
		},
	'1100' => {
		'type' => 'ethernet',
		'module' => 'tulip',
		'vendor' => 'D-Link Inc',
		'product' => 'Fast Ethernet Adapter',
		},
	'1300' => {
		'type' => 'ethernet',
		'module' => '8139too',
		'vendor' => 'D-Link System Inc',
		'product' => 'RTL8139 Ethernet',
		},
	'1340' => {
		'type' => 'ethernet',
		'module' => '8139too',
		'vendor' => 'D-Link System Inc',
		'product' => 'DFE-690TXD CardBus PC Card',
		},
	'4000' => {
		'type' => 'ethernet',
		'module' => 'dl2k',
		'vendor' => 'D-Link System Inc',
		'product' => 'DL2K Ethernet',
		},
	},
'1191' => {
	'8002' => {
		'type' => 'scsi',
		'module' => 'atp870u',
		'vendor' => 'Artop Electronic Corp',
		'product' => 'AEC6710 SCSI-2 Host Adapter',
		},
	'8010' => {
		'type' => 'scsi',
		'module' => 'atp870u',
		'vendor' => 'Artop Electronic Corp',
		'product' => 'AEC6712UW SCSI',
		},
	'8020' => {
		'type' => 'scsi',
		'module' => 'atp870u',
		'vendor' => 'Artop Electronic Corp',
		'product' => 'AEC6712U SCSI',
		},
	'8030' => {
		'type' => 'scsi',
		'module' => 'atp870u',
		'vendor' => 'Artop Electronic Corp',
		'product' => 'AEC6712S SCSI',
		},
	'8040' => {
		'type' => 'scsi',
		'module' => 'atp870u',
		'vendor' => 'Artop Electronic Corp',
		'product' => 'AEC6712D SCSI',
		},
	'8050' => {
		'type' => 'scsi',
		'module' => 'atp870u',
		'vendor' => 'Artop Electronic Corp',
		'product' => 'AEC6712SUW SCSI',
		},
	},
'119e' => {
	'0001' => {
		'type' => 'atm',
		'module' => 'firestream',
		'vendor' => 'Fujitsu Microelectronics Ltd.',
		'product' => 'FireStream 155',
		},
	'0003' => {
		'type' => 'atm',
		'module' => 'firestream',
		'vendor' => 'Fujitsu Microelectronics Ltd.',
		'product' => 'FireStream 50',
		},
	},
'11ad' => {
	'0002' => {
		'type' => 'ethernet',
		'module' => 'tulip',
		'vendor' => 'Lite-On',
		'product' => 'LNE100TX',
		},
	'c115' => {
		'type' => 'ethernet',
		'module' => 'tulip',
		'vendor' => 'Lite-On',
		'product' => 'LNE100TX [Linksys EtherFast 10/100]',
		},
	},
'11b0' => {
	'0002' => {
		'type' => 'ppp',
		'module' => 'sdladrv',
		'vendor' => 'V3 Semiconductor Inc.',
		'product' => 'V300PSC',
		},
	},
'11f6' => {
	'0112' => {
		'type' => 'ethernet',
		'module' => 'hp100',
		'vendor' => 'Compex',
		'product' => 'ENet100VG4',
		},
	'1401' => {
		'type' => 'ethernet',
		'module' => 'ne2k-pci',
		'vendor' => 'Compex',
		'product' => 'ReadyLink 2000',
		},
	'2011' => {
		'type' => 'ethernet',
		'module' => 'winbond-840',
		'vendor' => 'Compex',
		'product' => 'RL100-ATX 10/100',
		},
	'2201' => {
		'type' => 'ethernet',
		'module' => 'ne2k-pci',
		'vendor' => 'Compex',
		'product' => 'ReadyLink 100TX (Winbond W89C840)',
		},
	'9881' => {
		'type' => 'ethernet',
		'module' => 'tulip',
		'vendor' => 'Compex',
		'product' => 'RL100TX',
		},
	},
'120f' => {
	'0001' => {
		'type' => 'ethernet',
		'module' => 'rrunner',
		'vendor' => 'Essential Communications',
		'product' => 'Roadrunner serial HIPPI',
		},
	},
'1256' => {
	'4201' => {
		'type' => 'scsi',
		'module' => 'pci2220i',
		'vendor' => 'Perceptive Solutions, Inc.',
		'product' => 'PCI-2220I',
		},
	'4401' => {
		'type' => 'scsi',
		'module' => 'pci2220i',
		'vendor' => 'Perceptive Solutions, Inc.',
		'product' => 'PCI-2240I',
		},
	'5201' => {
		'type' => 'scsi',
		'module' => 'pci2000',
		'vendor' => 'Perceptive Solutions, Inc.',
		'product' => 'PCI-2000',
		},
	},
'1259' => {
	'2560' => {
		'type' => 'ethernet',
		'module' => 'eepro100',
		'vendor' => 'Allied Telesyn International',
		'product' => 'AT-2560 Fast Ethernet Adapter (i82557B)',
		},
	},
'125b' => {
	'1400' => {
		'type' => 'ethernet',
		'module' => 'tulip',
		'vendor' => 'Asix Electronics Corporation',
		'product' => 'ALFA GFC2204',
		},
	},
'1266' => {
	'0001' => {
		'type' => 'ethernet',
		'module' => 'eepro100',
		'vendor' => 'Microdyne Corporation',
		'product' => 'NE10/100 Adapter (i82557B)',
		},
	},
'1282' => {
	'9009' => {
		'type' => 'ethernet',
		'module' => 'dmfe',
		'vendor' => 'Davicom Semiconductor, Inc.',
		'product' => 'Ethernet 100/10 MBit',
		},
	'9100' => {
		'type' => 'ethernet',
		'module' => 'tulip',
		'vendor' => 'Davicom Semiconductor, Inc.',
		'product' => 'Ethernet 100/10 MBit',
		},
	'9102' => {
		'type' => 'ethernet',
		'module' => 'tulip',
		'vendor' => 'Davicom Semiconductor, Inc.',
		'product' => 'Ethernet 100/10 MBit',
		},
	'9132' => {
		'type' => 'ethernet',
		'module' => 'dmfe',
		'vendor' => 'Davicom Semiconductor, Inc.',
		'product' => 'Ethernet 100/10 MBit',
		},
	},
'12ae' => {
	'0001' => {
		'type' => 'ethernet',
		'module' => 'acenic',
		'vendor' => 'Alteon Networks Inc.',
		'product' => 'AceNIC Gigabit Ethernet (Fibre)',
		},
	'0002' => {
		'type' => 'ethernet',
		'module' => 'acenic',
		'vendor' => 'Alteon Networks Inc.',
		'product' => 'AceNIC Gigabit Ethernet (Copper)',
		},
	},
'12c3' => {
	'0058' => {
		'type' => 'ethernet',
		'module' => 'ne2k-pci',
		'vendor' => 'Holtek Microelectronics Inc',
		'product' => 'PCI NE2K Ethernet',
		},
	'5598' => {
		'type' => 'ethernet',
		'module' => 'ne2k-pci',
		'vendor' => 'Holtek Microelectronics Inc',
		'product' => 'PCI NE2K Ethernet',
		},
	},
'1317' => {
	'0981' => {
		'type' => 'ethernet',
		'module' => 'tulip',
		'vendor' => 'Linksys',
		'product' => 'Fast Ethernet 10/100',
		},
	'0985' => {
		'type' => 'ethernet',
		'module' => 'tulip',
		'vendor' => 'Linksys',
		'product' => 'Network Everywhere Fast Ethernet 10/100 model NC100',
		},
	'1985' => {
		'type' => 'ethernet',
		'module' => 'tulip',
		'vendor' => 'Linksys',
		'product' => 'Fast Ethernet 10/100',
		},
	},
'1318' => {
	'0911' => {
		'type' => 'ethernet',
		'module' => 'hamachi',
		'vendor' => 'Packet Engines Inc.',
		'product' => 'PCI Ethernet Adapter',
		},
	},
'134a' => {
	'0001' => {
		'type' => 'scsi',
		'module' => 'dtc',
		'vendor' => 'DTC Technology Corp.',
		'product' => 'Domex 536',
		},
	'0002' => {
		'type' => 'scsi',
		'module' => 'dtc',
		'vendor' => 'DTC Technology Corp.',
		'product' => 'Domex DMX3194UP SCSI Adapter',
		},
	},
'1385' => {
	'620a' => {
		'type' => 'ethernet',
		'module' => 'acenic',
		'vendor' => 'Netgear',
		'product' => 'GA620',
		},
	'630a' => {
		'type' => 'ethernet',
		'module' => 'acenic',
		'vendor' => 'Netgear',
		'product' => 'GA630',
		},
	},
'13c1' => {
	'1000' => {
		'type' => 'scsi',
		'module' => '3w-xxxx',
		'vendor' => '3ware Inc',
		'product' => '3ware ATA-RAID',
		},
	'1001' => {
		'type' => 'scsi',
		'module' => '3w-xxxx',
		'vendor' => '3ware Inc',
		'product' => '3ware 7000-series ATA-RAID',
		},
	'1002' => {
		'type' => 'scsi',
		'module' => '3w-xxxx',
		'vendor' => '3ware Inc',
		'product' => '3ware ATA-RAID',
		},
	},
'13d1' => {
	'ab02' => {
		'type' => 'ethernet',
		'module' => 'tulip',
		'vendor' => 'Abocom Systems Inc',
		'product' => 'Ethernet Adapter',
		},
	'ab03' => {
		'type' => 'ethernet',
		'module' => 'tulip',
		'vendor' => 'Abocom Systems Inc',
		'product' => 'Ethernet Adapter',
		},
	'ab06' => {
		'type' => 'ethernet',
		'module' => '8139too',
		'vendor' => 'Abocom Systems Inc',
		'product' => 'RTL8139 [FE2000VX] CardBus Fast Ethernet Attached Port Adapter',
		},
	},
'13f0' => {
	'0201' => {
		'type' => 'ethernet',
		'module' => 'sundance',
		'vendor' => 'Sundance Technology Inc',
		'product' => 'ST201 Sundance Ethernet',
		},
	},
'1400' => {
	'1401' => {
		'type' => 'ethernet',
		'module' => 'epic100',
		'vendor' => 'Artx Inc',
		'product' => '9432 TX',
		},
	},
'14b9' => {
	'0001' => {
		'type' => 'ethernet',
		'module' => 'aironet4500_card',
		'vendor' => 'AIRONET Wireless Communications',
		'product' => 'PC4800',
		},
	'4500' => {
		'type' => 'ethernet',
		'module' => 'aironet4500_card',
		'vendor' => 'AIRONET Wireless Communications',
		'product' => '',
		},
	'4800' => {
		'type' => 'ethernet',
		'module' => 'aironet4500_card',
		'vendor' => 'AIRONET Wireless Communications',
		'product' => '',
		},
	},
'14e4' => {
	'1644' => {
		'type' => 'ethernet',
		'module' => 'bcm5700',
		'vendor' => 'Broadcom Corporation',
		'product' => 'BCM5700 1000BaseTX',
		},
	'1645' => {
		'type' => 'ethernet',
		'module' => 'bcm5700',
		'vendor' => 'Broadcom Corporation',
		'product' => 'BCM5701 1000BaseTX',
		},
	'1647' => {
		'type' => 'ethernet',
		'module' => 'bcm5700',
		'vendor' => 'Broadcom Corporation',
		'product' => 'BCM5701 1000BaseTX',
		},
	},
'14f1' => {
	'1803' => {
		'type' => 'ethernet',
		'module' => 'tulip',
		'vendor' => 'Conexant LANfinity',
		'product' => '',
		},
	},
'1500' => {
	'1360' => {
		'type' => 'ethernet',
		'module' => '8139too',
		'vendor' => 'Delta Electronics',
		'product' => '8139 10/100BaseTX',
		},
	},
'1516' => {
	'0800' => {
		'type' => 'ethernet',
		'module' => 'fealnx',
		'vendor' => 'Myson Technology Inc',
		'product' => '800 network controller',
		},
	'0803' => {
		'type' => 'ethernet',
		'module' => 'fealnx',
		'vendor' => 'Myson Technology Inc',
		'product' => '803 network controller',
		},
	'0891' => {
		'type' => 'ethernet',
		'module' => 'fealnx',
		'vendor' => 'Myson Technology Inc',
		'product' => '891 network controller',
		},
	},
'1619' => {
	'0400' => {
		'type' => 'ppp',
		'module' => 'farsync',
		'vendor' => 'FarSite Communications Ltd',
		'product' => 'FarSync T2P (2 port X.21/V.35/V.24)',
		},
	'0440' => {
		'type' => 'ppp',
		'module' => 'farsync',
		'vendor' => 'FarSite Communications Ltd',
		'product' => 'FarSync T4P (4 port X.21/V.35/V.24)',
		},
	},
'1d44' => {
	'a400' => {
		'type' => 'scsi',
		'module' => 'eata',
		'vendor' => 'DPT',
		'product' => 'PM2x24/PM3224',
		},
	},
'4033' => {
	'1360' => {
		'type' => 'ethernet',
		'module' => '8139too',
		'vendor' => 'Addtron Technology Co, Inc.',
		'product' => 'RTL8139 Ethernet',
		},
	},
'4a14' => {
	'5000' => {
		'type' => 'ethernet',
		'module' => 'ne2k-pci',
		'vendor' => 'NetVin',
		'product' => 'NV5000SC',
		},
	},
'8086' => {
	'0039' => {
		'type' => 'ethernet',
		'module' => 'tulip',
		'vendor' => 'Intel Corporation',
		'product' => '21145',
		},
	'0600' => {
		'type' => 'scsi',
		'module' => 'gdth',
		'vendor' => 'Intel Corporation',
		'product' => 'RAID Controller',
		},
	'1000' => {
		'type' => 'ethernet',
		'module' => 'e1000',
		'vendor' => 'Intel Corporation',
		'product' => '82542 Gigabit Ethernet Controller',
		},
	'1001' => {
		'type' => 'ethernet',
		'module' => 'e1000',
		'vendor' => 'Intel Corporation',
		'product' => '82543GC Gigabit Ethernet Controller',
		},
	'1004' => {
		'type' => 'ethernet',
		'module' => 'e1000',
		'vendor' => 'Intel Corporation',
		'product' => '82543GC Gigabit Ethernet Controller',
		},
	'1008' => {
		'type' => 'ethernet',
		'module' => 'e1000',
		'vendor' => 'Intel Corporation',
		'product' => '82544EI Gigabit Ethernet Controller',
		},
	'1009' => {
		'type' => 'ethernet',
		'module' => 'e1000',
		'vendor' => 'Intel Corporation',
		'product' => '82544EI Gigabit Ethernet Controller',
		},
	'100c' => {
		'type' => 'ethernet',
		'module' => 'e1000',
		'vendor' => 'Intel Corporation',
		'product' => '82544GC Gigabit Ethernet Controller',
		},
	'100d' => {
		'type' => 'ethernet',
		'module' => 'e1000',
		'vendor' => 'Intel Corporation',
		'product' => '82544GC Gigabit Ethernet Controller',
		},
	'100e' => {
		'type' => 'ethernet',
		'module' => 'e1000',
		'vendor' => 'Intel Corporation',
		'product' => '82540EM Gigabit Ethernet Controller',
		},
	'100f' => {
		'type' => 'ethernet',
		'module' => 'e1000',
		'vendor' => 'Intel Corporation',
		'product' => '82545EM Gigabit Ethernet Controller',
		},
	'1010' => {
		'type' => 'ethernet',
		'module' => 'e1000',
		'vendor' => 'Intel Corporation',
		'product' => '82546EB Gigabit Ethernet Controller',
		},
	'1011' => {
		'type' => 'ethernet',
		'module' => 'e1000',
		'vendor' => 'Intel Corporation',
		'product' => '82545EM Gigabit Ethernet Controller',
		},
	'1012' => {
		'type' => 'ethernet',
		'module' => 'e1000',
		'vendor' => 'Intel Corporation',
		'product' => '82546EB Gigabit Ethernet Controller',
		},
	'1029' => {
		'type' => 'ethernet',
		'module' => 'eepro100',
		'vendor' => 'Intel Corporation',
		'product' => '82559 Ethernet Controller',
		},
	'1030' => {
		'type' => 'ethernet',
		'module' => 'eepro100',
		'vendor' => 'Intel Corporation',
		'product' => '82559 InBusiness 10/100',
		},
	'1031' => {
		'type' => 'ethernet',
		'module' => 'eepro100',
		'vendor' => 'Intel Corporation',
		'product' => '82801CAM (ICH3) PRO/100 VE (LOM) Ethernet Controller',
		},
	'1032' => {
		'type' => 'ethernet',
		'module' => 'eepro100',
		'vendor' => 'Intel Corporation',
		'product' => '82801CAM (ICH3) PRO/100 VE Ethernet Controller',
		},
	'1033' => {
		'type' => 'ethernet',
		'module' => 'eepro100',
		'vendor' => 'Intel Corporation',
		'product' => '82801CAM (ICH3) PRO/100 VM (LOM) Ethernet Controller',
		},
	'1034' => {
		'type' => 'ethernet',
		'module' => 'eepro100',
		'vendor' => 'Intel Corporation',
		'product' => '82801CAM (ICH3) PRO/100 VM Ethernet Controller',
		},
	'1035' => {
		'type' => 'ethernet',
		'module' => 'eepro100',
		'vendor' => 'Intel Corporation',
		'product' => '82801CAM (ICH3)/82562EH (LOM) Ethernet Controller',
		},
	'1036' => {
		'type' => 'ethernet',
		'module' => 'eepro100',
		'vendor' => 'Intel Corporation',
		'product' => '82801CAM (ICH3) 82562EH Ethernet Controller',
		},
	'1037' => {
		'type' => 'ethernet',
		'module' => 'eepro100',
		'vendor' => 'Intel Corporation',
		'product' => '82801CAM (ICH3) Chipset Ethernet Controller',
		},
	'1038' => {
		'type' => 'ethernet',
		'module' => 'eepro100',
		'vendor' => 'Intel Corporation',
		'product' => '82801CAM (ICH3) PRO/100 VM (KM) Ethernet Controller',
		},
	'1039' => {
		'type' => 'ethernet',
		'module' => 'eepro100',
		'vendor' => 'Intel Corporation',
		'product' => '82801BD PRO/100 VE (LOM) Ethernet Controller',
		},
	'103a' => {
		'type' => 'ethernet',
		'module' => 'eepro100',
		'vendor' => 'Intel Corporation',
		'product' => '82801BD PRO/100 VE (CNR) Ethernet Controller',
		},
	'103b' => {
		'type' => 'ethernet',
		'module' => 'eepro100',
		'vendor' => 'Intel Corporation',
		'product' => '82801BD PRO/100 VM (LOM) Ethernet Controller',
		},
	'103c' => {
		'type' => 'ethernet',
		'module' => 'eepro100',
		'vendor' => 'Intel Corporation',
		'product' => '82801BD PRO/100 VM (CNR) Ethernet Controller',
		},
	'103d' => {
		'type' => 'ethernet',
		'module' => 'eepro100',
		'vendor' => 'Intel Corporation',
		'product' => '82801BD PRO/100 VE (MOB) Ethernet Controller',
		},
	'103e' => {
		'type' => 'ethernet',
		'module' => 'eepro100',
		'vendor' => 'Intel Corporation',
		'product' => '82801BD PRO/100 VM (MOB) Ethernet Controller',
		},
	'1059' => {
		'type' => 'ethernet',
		'module' => 'eepro100',
		'vendor' => 'Intel Corporation',
		'product' => '82551QM Ethernet Controller',
		},
	'1209' => {
		'type' => 'ethernet',
		'module' => 'eepro100',
		'vendor' => 'Intel Corporation',
		'product' => '82559ER',
		},
	'1227' => {
		'type' => 'ethernet',
		'module' => 'eepro100',
		'vendor' => 'Intel Corporation',
		'product' => '82865 EtherExpress PRO/100A',
		},
	'1228' => {
		'type' => 'ethernet',
		'module' => 'eepro100',
		'vendor' => 'Intel Corporation',
		'product' => '82556 EtherExpress PRO/100 Smart',
		},
	'1229' => {
		'type' => 'ethernet',
		'module' => 'eepro100',
		'vendor' => 'Intel Corporation',
		'product' => '82557/8/9 [Ethernet Pro 100]',
		},
	'1960' => {
		'type' => 'scsi',
		'module' => 'megaraid',
		'vendor' => 'Dell Computer Coropration',
		'product' => 'PowerEdge RAID Controller 2/SC',
		},
	'2449' => {
		'type' => 'ethernet',
		'module' => 'eepro100',
		'vendor' => 'Intel Corporation',
		'product' => '82801BA/BAM/CA/CAM Ethernet Controller',
		},
	'2459' => {
		'type' => 'ethernet',
		'module' => 'eepro100',
		'vendor' => 'Intel Corporation',
		'product' => '82801E Ethernet Controller 0',
		},
	'245d' => {
		'type' => 'ethernet',
		'module' => 'eepro100',
		'vendor' => 'Intel Corporation',
		'product' => '82801E Ethernet Controller 1',
		},
	'5200' => {
		'type' => 'ethernet',
		'module' => 'eepro100',
		'vendor' => 'Intel Corporation',
		'product' => 'EtherExpress PRO/100 Intelligent Server',
		},
	'5201' => {
		'type' => 'ethernet',
		'module' => 'eepro100',
		'vendor' => 'Intel Corporation',
		'product' => 'EtherExpress PRO/100 Intelligent Server',
		},
	},
'8e2e' => {
	'3000' => {
		'type' => 'ethernet',
		'module' => 'ne2k-pci',
		'vendor' => 'KTI',
		'product' => 'ET32P2',
		},
	},
'9004' => {
	'1078' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-7810',
		},
	'2178' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-7821',
		},
	'3860' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AHA-2930CU',
		},
	'5075' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-755x',
		},
	'5078' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AHA-7850',
		},
	'5175' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-755x',
		},
	'5178' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-7851',
		},
	'5275' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-755x',
		},
	'5278' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-7852',
		},
	'5375' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-755x',
		},
	'5378' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-7850',
		},
	'5475' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-755x',
		},
	'5478' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-7850',
		},
	'5575' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AVA-2930',
		},
	'5578' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-7855',
		},
	'5675' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-755x',
		},
	'5678' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-7856',
		},
	'5775' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-755x',
		},
	'5778' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-7850',
		},
	'5800' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-5800',
		},
	'6038' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-3860',
		},
	'6075' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-1480 / APA-1480',
		},
	'6078' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-7860',
		},
	'6178' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-7861',
		},
	'6278' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-7860',
		},
	'6378' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-7860',
		},
	'6478' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-786x',
		},
	'6578' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-786x',
		},
	'6678' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-786x',
		},
	'6778' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-786x',
		},
	'6915' => {
		'type' => 'ethernet',
		'module' => 'starfire',
		'vendor' => 'Adaptec',
		'product' => 'ANA620xx/ANA69011A',
		},
	'7078' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AHA-294x / AIC-7870',
		},
	'7178' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AHA-2940/2940W / AIC-7871',
		},
	'7278' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AHA-3940/3940W / AIC-7872',
		},
	'7378' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AHA-3985 / AIC-7873',
		},
	'7478' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AHA-2944/2944W / AIC-7874',
		},
	'7578' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AHA-3944/3944W / AIC-7875',
		},
	'7678' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AHA-4944W/UW / AIC-7876',
		},
	'7778' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-787x',
		},
	'7810' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-7810',
		},
	'7815' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-7815 RAID+Memory Controller IC',
		},
	'7850' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-7850',
		},
	'7855' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AHA-2930',
		},
	'7860' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-7860',
		},
	'7870' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-7870',
		},
	'7871' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AHA-2940',
		},
	'7872' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AHA-3940',
		},
	'7873' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AHA-3980',
		},
	'7874' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AHA-2944',
		},
	'7880' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-7880P',
		},
	'7890' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-7890',
		},
	'7891' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-789x',
		},
	'7892' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-789x',
		},
	'7893' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-789x',
		},
	'7894' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-789x',
		},
	'7895' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AHA-2940U/UW / AHA-39xx / AIC-7895',
		},
	'7896' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-789x',
		},
	'7897' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-789x',
		},
	'8078' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-7880U',
		},
	'8178' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AHA-2940U/UW/D / AIC-7881U',
		},
	'8278' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AHA-3940U/UW/UWD / AIC-7882U',
		},
	'8378' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AHA-3940U/UW / AIC-7883U',
		},
	'8478' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AHA-2944UW / AIC-7884U',
		},
	'8578' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AHA-3944U/UWD / AIC-7885',
		},
	'8678' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AHA-4944UW / AIC-7886',
		},
	'8778' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AHA-2940UW Pro / AIC-788x',
		},
	'8878' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AHA-2930UW / AIC-7888',
		},
	'8b78' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'ABA-1030',
		},
	'ec78' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AHA-4944W/UW',
		},
	'ffff' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Unknown Vendor',
		'product' => 'AIC7xxx compatible SCSI controller',
		},
	},
'9005' => {
	'0010' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AHA-2940U2/U2W',
		},
	'0011' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AHA-2930U2',
		},
	'0013' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => '78902',
		},
	'001f' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AHA-2940U2/U2W / 7890/7891',
		},
	'0020' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-7890',
		},
	'002f' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-7890',
		},
	'0030' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-7890',
		},
	'003f' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-7890',
		},
	'0050' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AHA-3940U2x/395U2x',
		},
	'0051' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AHA-3950U2D',
		},
	'0053' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-7896 SCSI Controller',
		},
	'005f' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-7896U2/7897U2',
		},
	'0080' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-7892A U160/m',
		},
	'0081' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-7892B U160/m',
		},
	'0083' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-7892D U160/m',
		},
	'008f' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-7892P U160/m',
		},
	'00c0' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AHA-3960D / AIC-7899A U160/m',
		},
	'00c1' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-7899B U160/m',
		},
	'00c3' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-7899D U160/m',
		},
	'00cf' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Adaptec',
		'product' => 'AIC-7899P U160/m',
		},
	'0283' => {
		'type' => 'scsi',
		'module' => 'aacraid',
		'vendor' => 'Adaptec',
		'product' => 'AAC-RAID',
		},
	'0284' => {
		'type' => 'scsi',
		'module' => 'aacraid',
		'vendor' => 'Adaptec',
		'product' => 'AAC-RAID',
		},
	'0285' => {
		'type' => 'scsi',
		'module' => 'aacraid',
		'vendor' => 'Adaptec',
		'product' => 'AAC-RAID',
		},
	'1364' => {
		'type' => 'scsi',
		'module' => 'aacraid',
		'vendor' => 'Adaptec',
		'product' => 'Dell PowerEdge RAID Controller 2',
		},
	'1365' => {
		'type' => 'scsi',
		'module' => 'aacraid',
		'vendor' => 'Adaptec',
		'product' => 'Dell PowerEdge RAID Controller 2',
		},
	'ffff' => {
		'type' => 'scsi',
		'module' => 'aic7xxx',
		'vendor' => 'Unknown Vendor',
		'product' => 'AIC7xxx compatible SCSI controller',
		},
	},
'ffff' => {
	'8139' => {
		'type' => 'ethernet',
		'module' => '8139too',
		'vendor' => 'RealTek',
		'product' => 'RTL-8139 Fast Ethernet',
		},
	},

        };

1;

