/*
 *	tardy - a tar post-processor
 *	Copyright (C) 1998, 1999 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: functions to manipulate tar input mode setting
 */

#include <tar/input/filter/mode_set.h>


tar_input_filter_mode_set::~tar_input_filter_mode_set()
{
}


tar_input_filter_mode_set::tar_input_filter_mode_set(tar_input *arg_fp,
	long arg_bits) :
    tar_input_filter(arg_fp),
    bits(arg_bits & 07777)
{
}


int
tar_input_filter_mode_set::read_header(tar_header &h)
{
    int ok = tar_input_filter::read_header(h);
    if (ok)
    {
	if (h.mode & 0444)
	    h.mode |= 0444;
	if (h.mode & 0111)
	    h.mode |= 0111;
	h.mode |= bits;
	if (h.type == tar_header::type_link_symbolic)
	    h.mode |= 0777;
    }
    return ok;
}
